/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import com.google.gwt.user.client.ui.SuggestOracle;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileURIOracle
extends SuggestOracle {
    private List<FileURISuggestion> suggestions = new ArrayList<FileURISuggestion>();
    private UIAssetFile file;

    public FileURIOracle() {
    }

    public FileURIOracle(UIAssetFile file) {
        this.file = file;
    }

    public void add(UIAssetFilePath filePath) {
        FileURISuggestion suggestion = new FileURISuggestion(filePath);
        this.suggestions.add(suggestion);
    }

    public void addAll(Collection<UIAssetFilePath> filePaths) {
        for (UIAssetFilePath filePath : filePaths) {
            this.add(filePath);
        }
    }

    public void clear() {
        this.suggestions.clear();
    }

    public void requestSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        List<FileURISuggestion> filteredSuggestions = this.getFilteredSuggestions(request);
        SuggestOracle.Response response = new SuggestOracle.Response(filteredSuggestions);
        callback.onSuggestionsReady(request, response);
    }

    private List<FileURISuggestion> getFilteredSuggestions(SuggestOracle.Request request) {
        ArrayList<FileURISuggestion> result = new ArrayList<FileURISuggestion>();
        int size = 0;
        String query = request.getQuery();
        if (query == null || query.trim().length() == 0) {
            return result;
        }
        query = query.trim().toLowerCase();
        int limit = request.getLimit();
        String filterFieldValue = this.getFilterFieldValue();
        for (FileURISuggestion suggestion : this.suggestions) {
            boolean filterValid;
            String fileSeparator;
            String filterValue = null;
            String path = suggestion.getFilePath().getFilePath();
            String string = fileSeparator = path.contains("/") ? "/" : "\\";
            if (filterFieldValue != null && filterFieldValue.trim().length() > 0) {
                filterValue = String.valueOf(fileSeparator) + filterFieldValue + fileSeparator;
            }
            boolean bl = filterValid = filterValue == null ? true : path.contains(filterValue);
            if (!filterValid || path == null || !path.toLowerCase().contains(query)) continue;
            result.add(suggestion);
            if (limit > 0 && limit <= ++size) break;
        }
        return result;
    }

    private String getFilterFieldValue() {
        UIField providerInfoField = this.file.getParentAsset().getRootAsset().getRootField().getChildren().getField("ProviderInfo");
        if (providerInfoField != null) {
            UIField identifierField = ((UIComplexField)providerInfoField).getChildren().getField("Identifier");
            if (identifierField != null) {
                UIField idField = ((UIComplexField)identifierField).getChildren().getField("Id");
                if (idField != null && idField instanceof UIStringField) {
                    return (String)((UIStringField)idField).getValue();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private class FileURISuggestion
    implements SuggestOracle.Suggestion {
        private UIAssetFilePath filePath;

        public FileURISuggestion(UIAssetFilePath filePath) {
            this.filePath = filePath;
        }

        public String getDisplayString() {
            return this.filePath.getFilePath();
        }

        public String getReplacementString() {
            return this.filePath.getFilePath();
        }

        public UIAssetFilePath getFilePath() {
            return this.filePath;
        }
    }
}

