/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetContentTable;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.SimpleFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileMetadataWidgetBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileView
extends Composite {
    private DisclosureContainer disclosureContainer;
    private SimpleContainer container;
    private SimpleContainer tableContainer;
    private AssetContentTable table;
    private TitleViewMessages messages;
    private final UIAssetFileDefinition fileDefinition;
    private final List<UIAssetFilePath> filePaths;
    private AssetTree.AssetInfo input;
    private boolean readOnly = false;
    private Set<Long> fileIDs = new HashSet<Long>();
    private long generatedFileID = -1L;
    private IUIAssetFactory assetFactory = new UIAssetFactory();
    private UIAssetFile newFile = null;
    private List<HandlerRegistration> newFileHandlers = new ArrayList<HandlerRegistration>();
    private Map<UIAssetFile, LabelWidget> rowIdentifier = new HashMap<UIAssetFile, LabelWidget>();
    private Map<String, Integer> columnIndices = new HashMap<String, Integer>();
    private static final String FILE_ID_COLUMN = "FileID";
    private static final String METADATA_COLUMN_PREFIX = "Metadata_";
    private static final String PARENT_FILE_ID_COLUMN = "ParentFileID";
    private static final String DELETE_BUTTON_COLUMN = "Delete";
    private static final String FILE_TABLE_CONTAINER_STYLE = "file-container";

    public FileView(UIAssetFileDefinition fileDefinition, List<UIAssetFilePath> filePaths, boolean readOnly) {
        this.fileDefinition = fileDefinition;
        this.filePaths = filePaths;
        this.readOnly = readOnly;
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.container = new SimpleContainer();
        this.initWidget((Widget)this.container);
        this.initialize();
    }

    private void initialize() {
        this.disclosureContainer = new RoundedDisclosureContainer(this.messages.fileSectionHeading(), true);
        this.container.add((Widget)this.disclosureContainer);
        this.table = new AssetContentTable();
        this.tableContainer = new SimpleContainer();
        this.tableContainer.setStyleName(FILE_TABLE_CONTAINER_STYLE);
        this.tableContainer.setWidget((Widget)this.table);
        this.disclosureContainer.setContent((Widget)this.tableContainer);
        int columnIndex = 0;
        this.table.addHeading(this.messages.fileIdColumn());
        this.columnIndices.put(FILE_ID_COLUMN, columnIndex++);
        for (UIAssetFileFieldDefinition fieldDefinition : this.fileDefinition.getFieldDefinitions()) {
            this.table.addHeading(fieldDefinition.getDisplayName());
            this.columnIndices.put(METADATA_COLUMN_PREFIX + fieldDefinition.getName(), columnIndex++);
        }
        this.table.addHeading(this.messages.parentFileIdColumn());
        this.columnIndices.put(PARENT_FILE_ID_COLUMN, columnIndex++);
        this.columnIndices.put(DELETE_BUTTON_COLUMN, columnIndex++);
    }

    public void setInput(AssetTree.AssetInfo asset) {
        this.input = asset;
        this.updateFileIDs();
        this.refresh();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    List<UIAssetFilePath> getFilePaths() {
        return this.filePaths;
    }

    private void updateFileIDs() {
        this.fileIDs.clear();
        this.generatedFileID = -1L;
        if (this.input == null) {
            return;
        }
        for (UIAssetFile file : this.input.getAsset().getFiles()) {
            if (file.getId() == null) continue;
            this.fileIDs.add(file.getId());
        }
        for (UIAssetFile file : this.input.getAsset().getFiles()) {
            if (file.getId() != null) continue;
            this.generateFileID(file);
        }
    }

    private void generateFileID(UIAssetFile file) {
        while (this.fileIDs.contains(this.generatedFileID)) {
            --this.generatedFileID;
        }
        file.setId(this.generatedFileID--);
        this.fileIDs.add(file.getId());
    }

    public void refresh() {
        this.disclosureContainer.setOpen(true);
        this.table.removeAllRows();
        this.rowIdentifier.clear();
        this.clearNewFileState();
        if (this.input == null) {
            return;
        }
        for (UIAssetFile file : this.input.getAsset().getFiles()) {
            this.buildRow(file);
        }
        this.addNewFileRow();
    }

    private void buildRow(UIAssetFile file) {
        int row = this.table.addRow();
        LabelWidget fileIDLabel = new LabelWidget(file.getId().toString());
        this.table.addCell(row, (Widget)fileIDLabel);
        this.rowIdentifier.put(file, fileIDLabel);
        for (UIAssetFileFieldDefinition fieldDefinition : this.fileDefinition.getFieldDefinitions()) {
            Widget widget = this.buildMetadataWidget(file, fieldDefinition);
            this.table.addCell(row, widget);
        }
        Widget parentFileWidget = this.buildParentFileWidget(file);
        this.table.addCell(row, parentFileWidget);
        Widget deleteButton = this.buildDeleteButton(file);
        this.table.addCell(row, deleteButton);
        this.table.addTableRowStyle(row, this.table.getCellCount(row), "assetContentTable-cell-body-delete");
    }

    private void addNewFileRow() {
        this.newFile = this.assetFactory.createAssetFile(this.fileDefinition);
        this.generateFileID(this.newFile);
        this.buildRow(this.newFile);
    }

    private void clearNewFileState() {
        this.newFile = null;
        for (HandlerRegistration registration : this.newFileHandlers) {
            registration.removeHandler();
        }
        this.newFileHandlers.clear();
    }

    private void handleFileUpdated(UIAssetFile file) {
        if (file.equals(this.newFile)) {
            this.input.getAsset().addFile(file);
            this.clearNewFileState();
            this.updateParentFileWidgets();
            this.showDeleteButton(file);
            this.addNewFileRow();
        }
    }

    private void handleFileDeleted(UIAssetFile file) {
        this.updateParentFileWidgets();
    }

    private Widget buildParentFileWidget(final UIAssetFile file) {
        final ListBoxWidget widget = new ListBoxWidget();
        this.updateParentFileWidgetItems(file, (ListBoxWidget<UIAssetFile>)widget);
        Long fileID = file.getId();
        boolean isReadOnly = this.readOnly || fileID != null && fileID > -1L;
        widget.setEnabled(!isReadOnly);
        widget.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FileView.this.handleParentFileChanged(file, (ListBoxWidget<UIAssetFile>)widget, event);
            }
        });
        return widget;
    }

    private void updateParentFileWidgets() {
        ListBoxWidget widget = null;
        for (UIAssetFile file : this.rowIdentifier.keySet()) {
            int row = this.table.getRow((Widget)this.rowIdentifier.get(file));
            int column = this.columnIndices.get(PARENT_FILE_ID_COLUMN);
            widget = (ListBoxWidget)this.table.getCellWidget(row, column);
            this.updateParentFileWidgetItems(file, (ListBoxWidget<UIAssetFile>)widget);
        }
    }

    private void updateParentFileWidgetItems(UIAssetFile file, ListBoxWidget<UIAssetFile> widget) {
        widget.clear();
        widget.addItem("", null);
        for (UIAssetFile otherFile : this.input.getAsset().getFiles()) {
            if (otherFile.equals(file)) continue;
            widget.addItem(otherFile.getId().toString(), (Object)otherFile);
        }
        UIAssetFile parentFile = file.getParentFile();
        int index = widget.getIndex((Object)parentFile);
        if (index == -1) {
            widget.addItem(parentFile.getId().toString(), (Object)parentFile);
        }
        widget.setSelectedItem((Object)parentFile);
    }

    private void handleParentFileChanged(UIAssetFile file, ListBoxWidget<UIAssetFile> widget, ChangeEvent event) {
        UIAssetFile newParent = (UIAssetFile)widget.getSelectedItem();
        if (!this.validateParentFileUpdate(file, newParent)) {
            widget.setSelectedItem((Object)file.getParentFile());
            return;
        }
        file.setParentFile(newParent);
        this.handleFileUpdated(file);
    }

    private boolean validateParentFileUpdate(UIAssetFile file, UIAssetFile newParent) {
        if (this.readOnly) {
            return false;
        }
        if (file.getId() != null && file.getId() > -1L) {
            Window.alert((String)this.messages.fileParentChangeError());
            return false;
        }
        if (this.isDescendant(file, newParent)) {
            Window.alert((String)this.messages.fileParentDescendantError());
            return false;
        }
        return true;
    }

    private boolean isDescendant(UIAssetFile file, UIAssetFile descendant) {
        ArrayList<UIAssetFile> descendants = new ArrayList<UIAssetFile>();
        descendants.add(file);
        int index = 0;
        while (index < descendants.size()) {
            UIAssetFile current = (UIAssetFile)descendants.get(index);
            for (UIAssetFile inputFile : this.input.getAsset().getFiles()) {
                if (!current.equals(inputFile.getParentFile()) || descendants.contains(inputFile)) continue;
                descendants.add(inputFile);
            }
            ++index;
        }
        return descendants.contains(descendant);
    }

    private Widget buildDeleteButton(final UIAssetFile file) {
        ImageWidget deleteImage = new ImageWidget("cms_contentmgmt_ui/resources/images/title_metadata_delete.gif");
        final PushButtonWidget button = new PushButtonWidget(deleteImage);
        boolean isReadOnly = this.readOnly || file.equals(this.newFile);
        button.setEnabled(!isReadOnly);
        button.setVisible(!isReadOnly);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FileView.this.handleDeleteButtonClicked(file, (Widget)button, event);
            }
        });
        return button;
    }

    private void showDeleteButton(UIAssetFile file) {
        int row = this.table.getRow((Widget)this.rowIdentifier.get(file));
        int column = this.columnIndices.get(DELETE_BUTTON_COLUMN);
        FocusWidget button = (FocusWidget)this.table.getCellWidget(row, column);
        button.setEnabled(true);
        button.setVisible(true);
    }

    private void handleDeleteButtonClicked(UIAssetFile file, Widget button, ClickEvent event) {
        if (!this.validateFileDelete(file)) {
            return;
        }
        int row = this.table.getRow(button);
        this.table.removeRow(row);
        this.input.getAsset().getFiles().remove(file);
        this.rowIdentifier.remove(file);
        this.handleFileDeleted(file);
    }

    private boolean validateFileDelete(UIAssetFile file) {
        if (this.readOnly || file.equals(this.newFile)) {
            return false;
        }
        for (UIAssetFile inputFile : this.input.getAsset().getFiles()) {
            if (!file.equals(inputFile.getParentFile())) continue;
            Window.alert((String)this.messages.fileDeleteWithChildrenError());
            return false;
        }
        return true;
    }

    private Widget buildMetadataWidget(UIAssetFile file, UIAssetFileFieldDefinition definition) {
        UIAssetFileField field = file.getFields().get(definition.getName());
        if (field == null) {
            field = this.assetFactory.createAssetFileField(definition);
            file.addField(field);
        }
        FileMetadataWidgetBuilder builder = new FileMetadataWidgetBuilder(this, file);
        SimpleFieldWidget<?, ?, ?> fieldWidget = null;
        try {
            fieldWidget = builder.build(file, definition, field, this.readOnly);
        }
        catch (MetadataTypeMismatchException ex) {
            String typeName = this.getTypeName(ex.getFieldDefinition());
            String receivedTypeName = this.getTypeName(ex.getReceivedField());
            String message = this.messages.metadataTypeMismatchError(typeName, receivedTypeName);
            LabelWidget label = new LabelWidget(message);
            label.addStyleName("fieldLabel-datatypeError");
            return label;
        }
        DataTypeWidget<?> widget = fieldWidget.getDataTypeWidget();
        if (file.equals(this.newFile) && widget instanceof HasKeyUpHandlers) {
            WidgetKeyEventHandler handler = new WidgetKeyEventHandler(this, file, field, fieldWidget);
            HasKeyUpHandlers keyAwareWidget = (HasKeyUpHandlers)widget;
            this.newFileHandlers.add(keyAwareWidget.addKeyUpHandler((KeyUpHandler)handler));
        }
        return fieldWidget;
    }

    private String getTypeName(UIFieldDefinition fieldDefinition) {
        String name = null;
        name = fieldDefinition instanceof UIComplexFieldDefinition ? this.messages.complexTypeName() : (fieldDefinition instanceof UISimpleFieldDefinition ? ((UISimpleFieldDefinition)fieldDefinition).getDatatype().getName() : this.messages.unknownTypeName());
        return name;
    }

    private String getTypeName(UIField field) {
        String name = null;
        name = field instanceof UIComplexField ? this.messages.complexTypeName() : (field instanceof UISimpleField ? ((UISimpleField)field).getDatatype().getName() : this.messages.unknownTypeName());
        return name;
    }

    void handleMetadataValueChanged(UIAssetFile file, UIAssetFileField field, SimpleFieldWidget<?, ?, ?> widget) {
        this.handleFileUpdated(file);
    }

    private void handleKeyUpEvent(UIAssetFile file, UIAssetFileField field, SimpleFieldWidget<?, ?, ?> widget, KeyUpEvent event) {
        if (!file.equals(this.newFile)) {
            return;
        }
        String stringValue = widget.getTextValue();
        if (stringValue != null && stringValue.length() > 0) {
            this.handleFileUpdated(file);
        }
    }

    public void validate(List<AssetValidationMessage> messages) {
        int startIndex = this.columnIndices.get(FILE_ID_COLUMN) + 1;
        int endIndex = this.columnIndices.get(PARENT_FILE_ID_COLUMN) - 1;
        SimpleFieldWidget widget = null;
        int row = 0;
        while (row < this.table.getRowCount()) {
            int column = startIndex;
            while (column <= endIndex) {
                widget = (SimpleFieldWidget)this.table.getCellWidget(row, column);
                if (!widget.isValidValue()) {
                    int index = column - startIndex;
                    String name = ((UIAssetFileFieldDefinition)this.fileDefinition.getFieldDefinitions().get(index)).getDisplayName();
                    String error = widget.getCurrentToolTip();
                    messages.add(new AssetValidationMessage(this.input, name, (Widget)widget, error));
                }
                ++column;
            }
            ++row;
        }
    }

    private static final class WidgetKeyEventHandler
    implements KeyUpHandler {
        private FileView fileView;
        private UIAssetFile file;
        private UIAssetFileField field;
        private SimpleFieldWidget<?, ?, ?> widget;

        public WidgetKeyEventHandler(FileView view, UIAssetFile file, UIAssetFileField field, SimpleFieldWidget<?, ?, ?> widget) {
            this.fileView = view;
            this.file = file;
            this.field = field;
            this.widget = widget;
        }

        public void onKeyUp(KeyUpEvent event) {
            this.fileView.handleKeyUpEvent(this.file, this.field, this.widget, event);
        }
    }
}

