/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.history.UIProgressItem;
import com.tandbergtv.cms.portal.content.client.title.model.history.UITitleHistory;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressHistoryPanel;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressItemColumn;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressItemRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleProgressService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;

class ProgressItemDataProvider
implements DataProvider<Long, ProgressItemRecord> {
    private TitleViewMessages messages;
    private List<Column<?, ProgressItemRecord>> columns;
    private ProgressHistoryPanel parent;
    public static final String USER_COLUMN_NAME = "sourceComponentName";
    public static final String DATE_COLUMN_NAME = "timestamp";
    public static final String ACTION_COLUMN_NAME = "name";
    public static final String REVISION_COLUMN_NAME = "titleVersion";

    public ProgressItemDataProvider(ProgressHistoryPanel parent) {
        this.parent = parent;
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.initializeColumns();
    }

    private void initializeColumns() {
        this.columns = new ArrayList();
        String displayName = null;
        ProgressItemColumn column = null;
        this.columns.add(this.prepareUserColumn());
        displayName = this.messages.progressTableActionColumn();
        column = new ProgressItemColumn(ACTION_COLUMN_NAME, displayName){

            @Override
            protected String getColumnText(ProgressItemRecord record) {
                return ProgressItemDataProvider.this.getActionValue(record.getProgressItem());
            }
        };
        this.columns.add((Column<?, ProgressItemRecord>)column);
        displayName = this.messages.progressTableDateColumn();
        column = new ProgressItemColumn(DATE_COLUMN_NAME, displayName){

            @Override
            protected String getColumnText(ProgressItemRecord record) {
                return ProgressItemDataProvider.this.getDateValue(record.getProgressItem());
            }
        };
        this.columns.add((Column<?, ProgressItemRecord>)column);
        this.columns.add(this.prepareRevisionColumn());
    }

    private Column<String, ProgressItemRecord> prepareRevisionColumn() {
        String displayName = this.messages.progressTableRevisionColumn();
        return new ColumnBase<String, ProgressItemRecord>(REVISION_COLUMN_NAME, displayName){

            public View<String> getView(final ProgressItemRecord record) {
                final boolean isLatestVersion = this.isProgressTitleVersionLatest(record);
                return new View<String>(){

                    public String getStyleName() {
                        return !isLatestVersion ? "table-data-link" : null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(ProgressItemDataProvider.this.getRevisionValue(record.getProgressItem()));
                        if (!isLatestVersion) {
                            label.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    String revision = record.getProgressItem().getTitleRevision();
                                    ProgressItemDataProvider.this.parent.getTab().showTitleRevision(revision);
                                }
                            });
                        }
                        return label;
                    }

                    public void release() {
                    }
                };
            }

            private boolean isProgressTitleVersionLatest(ProgressItemRecord record) {
                return record.getProgressItem().isLatestRevision();
            }
        };
    }

    private Column<String, ProgressItemRecord> prepareUserColumn() {
        String displayName = this.messages.progressTableUserColumn();
        return new ColumnBase<String, ProgressItemRecord>(USER_COLUMN_NAME, displayName){

            public View<String> getView(final ProgressItemRecord record) {
                final ITitleProgressService.Hyperlink hl = ProgressItemDataProvider.this.getHyperlinkInfoFromAppropriateComponent(record.getProgressItem());
                return new View<String>(){

                    public String getStyleName() {
                        return hl != null && hl.getTargetHistoryToken() != null ? "table-data-link" : null;
                    }

                    public Widget getWidget() {
                        if (hl != null) {
                            if (hl.getTargetHistoryToken() != null) {
                                return new HyperlinkWidget(hl.getText(), hl.isAsHTML(), hl.getTargetHistoryToken());
                            }
                            return new LabelWidget(hl.getText());
                        }
                        return new LabelWidget(record.getProgressItem().getSourceComponentName());
                    }

                    public void release() {
                    }
                };
            }
        };
    }

    private ITitleProgressService.Hyperlink getHyperlinkInfoFromAppropriateComponent(UIProgressItem item) {
        ServiceLoader serviceLoader = NeptuneApplication.getApplication().getServiceLoader();
        List services = serviceLoader.loadServices(ITitleProgressService.class);
        for (ITitleProgressService service : services) {
            ITitleProgressService.Hyperlink hl = service.getLink(item.getSourceComponentName(), item.getSourceEntityName(), item.getSourceId(), item.getTitleRevision());
            if (hl == null) continue;
            return hl;
        }
        return null;
    }

    public List<Column<?, ProgressItemRecord>> getColumns() {
        return this.columns;
    }

    public ProgressItemColumn getColumn(String columnName) {
        ProgressItemColumn match = null;
        for (Column<?, ProgressItemRecord> column : this.columns) {
            if (!(column instanceof ProgressItemColumn) || !columnName.equals(column.getName())) continue;
            match = (ProgressItemColumn)column;
            break;
        }
        return match;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public void getRecord(Long key, AsyncCallback<ProgressItemRecord> callback) {
        UIProgressItem progressItem = new UIProgressItem();
        progressItem.setId(key);
        callback.onSuccess((Object)new ProgressItemRecord(progressItem));
    }

    public void getRecords(final AsyncCallback<List<ProgressItemRecord>> callback) {
        this.parent.getTab().getViewInput().getHistory((AsyncCallback<UITitleHistory>)new NeptuneAsyncCallback<UITitleHistory>(){

            public void onNeptuneSuccess(UITitleHistory result) {
                ArrayList<ProgressItemRecord> records = new ArrayList<ProgressItemRecord>();
                for (UIProgressItem progressItem : result.getProgressItems()) {
                    records.add(new ProgressItemRecord(progressItem));
                }
                callback.onSuccess(records);
                ProgressItemDataProvider.this.parent.handleGetRecordsSuccess(result, records.size());
            }

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                ProgressItemDataProvider.this.parent.handleGetRecordsFailure(caught);
            }
        });
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private String getActionValue(UIProgressItem progressItem) {
        return progressItem.getName();
    }

    private String getDateValue(UIProgressItem progressItem) {
        if (progressItem.getTimestamp() == null) {
            return null;
        }
        String pattern = this.messages.historyDatePattern();
        DateTimeFormat format = DateTimeFormat.getFormat((String)pattern);
        return format.format(progressItem.getTimestamp());
    }

    private String getRevisionValue(UIProgressItem progressItem) {
        return progressItem.getTitleRevision();
    }
}

