/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.metadata;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewConstants;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleMetadataTab;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class TitleValidationView
extends Composite {
    private TitleMetadataTab parentTab;
    private TitleValidationViewInput input;
    private SimpleContainer mainContainer;
    private LabelWidget blankLabel;
    private TitleViewMessages messages;
    private TitleViewConstants constants;
    private static final String WIDGET_STYLE = "titleValidationView";
    private static final String SECTION_HEADING_STYLE = "titleValidationView-sectionHeading";
    private static final String ERROR_HEADING_STYLE = "titleValidationView-sectionHeading-error";
    private static final String WARN_HEADING_STYLE = "titleValidationView-sectionHeading-warning";
    private static final String INFO_HEADING_STYLE = "titleValidationView-sectionHeading-information";
    private static final String MESSAGE_STYLE = "titleValidationView-message";
    private static final String ERROR_MESSAGE_STYLE = "titleValidationView-message-error";
    private static final String WARN_MESSAGE_STYLE = "titleValidationView-message-warning";
    private static final String INFO_MESSAGE_STYLE = "titleValidationView-message-information";
    private static final String FIELD_LINK_STYLE = "titleValidationView-fieldLink";
    private static final String VALIDATION_WIDGET_STYLE = "titleValidationView-messageWidget";

    public TitleValidationView(TitleMetadataTab parentTab) {
        this.parentTab = parentTab;
        this.initialize();
    }

    private void initialize() {
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.constants = (TitleViewConstants)GWT.create(TitleViewConstants.class);
        this.mainContainer = new SimpleContainer();
        this.mainContainer.addStyleName(WIDGET_STYLE);
        this.blankLabel = new LabelWidget("");
        this.mainContainer.setWidget((Widget)this.blankLabel);
        this.initWidget((Widget)this.mainContainer);
    }

    public void setInput(TitleValidationViewInput input) {
        this.input = input;
        this.refresh();
    }

    public void refresh() {
        int infoCount;
        int warningCount;
        this.setVisible(false);
        this.mainContainer.setWidget((Widget)new LabelWidget(""));
        if (this.input == null || !this.input.hasValidationMessages()) {
            return;
        }
        VerticalContainer messagePanel = new VerticalContainer();
        this.filterTitleValidationMessages();
        int errorCount = this.input.getErrorMessageCount();
        if (errorCount > 0) {
            Widget widget;
            String sectionHeading = this.messages.titleValidationErrorHeading(errorCount);
            LabelWidget sectionLabel = new LabelWidget(sectionHeading);
            sectionLabel.addStyleName(SECTION_HEADING_STYLE);
            sectionLabel.addStyleName(ERROR_HEADING_STYLE);
            messagePanel.add((Widget)sectionLabel);
            for (AssetValidationMessage assetValidationMessage : this.input.getAssetValidationMessages()) {
                widget = this.buildMetadataValidationMessageWidget(assetValidationMessage);
                messagePanel.add(widget);
            }
            for (UITitleValidationMessage uITitleValidationMessage : this.input.getTitleValidationMessages()) {
                if (!UITitleValidationMessageType.Error.equals((Object)uITitleValidationMessage.getMessageType())) continue;
                widget = this.buildTitleValidationMessageWidget(uITitleValidationMessage);
                messagePanel.add(widget);
            }
        }
        if ((warningCount = this.input.getWarningMessageCount()) > 0) {
            String sectionHeading = this.messages.titleValidationWarningHeading(warningCount);
            LabelWidget labelWidget = new LabelWidget(sectionHeading);
            labelWidget.addStyleName(SECTION_HEADING_STYLE);
            labelWidget.addStyleName(WARN_HEADING_STYLE);
            messagePanel.add((Widget)labelWidget);
            for (UITitleValidationMessage message : this.input.getTitleValidationMessages()) {
                if (!UITitleValidationMessageType.Warning.equals((Object)message.getMessageType())) continue;
                Widget widget = this.buildTitleValidationMessageWidget(message);
                messagePanel.add(widget);
            }
        }
        if ((infoCount = this.input.getInformationMessageCount()) > 0) {
            String string = this.messages.titleValidationInformationHeading(infoCount);
            LabelWidget sectionLabel = new LabelWidget(string);
            sectionLabel.addStyleName(SECTION_HEADING_STYLE);
            sectionLabel.addStyleName(INFO_HEADING_STYLE);
            messagePanel.add((Widget)sectionLabel);
            for (UITitleValidationMessage message : this.input.getTitleValidationMessages()) {
                if (!UITitleValidationMessageType.Information.equals((Object)message.getMessageType())) continue;
                Widget widget = this.buildTitleValidationMessageWidget(message);
                messagePanel.add(widget);
            }
        }
        this.mainContainer.setWidget((Widget)messagePanel);
        this.setVisible(true);
    }

    private void filterTitleValidationMessages() {
        ArrayList<UITitleValidationMessage> messagesToDisplay = new ArrayList<UITitleValidationMessage>();
        for (UITitleValidationMessage message : this.input.getTitleValidationMessages()) {
            this.setMessageText(message);
            if (this.messageExists(message, messagesToDisplay)) continue;
            messagesToDisplay.add(message);
        }
        this.input.getTitleValidationMessages().clear();
        this.input.getTitleValidationMessages().addAll(messagesToDisplay);
    }

    private void setMessageText(UITitleValidationMessage message) {
        if (message.getErrorCode() != null) {
            try {
                message.setMessage(this.constants.getString(message.getErrorCode()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean messageExists(UITitleValidationMessage message, List<UITitleValidationMessage> messages) {
        for (UITitleValidationMessage m : messages) {
            if (!m.getMessage().equalsIgnoreCase(message.getMessage())) continue;
            return true;
        }
        return false;
    }

    private Widget buildMetadataValidationMessageWidget(final AssetValidationMessage message) {
        HorizontalContainer widget = new HorizontalContainer();
        String assetType = message.getAsset().getDefinition().getDisplayName();
        String fieldName = message.getFieldName();
        String fieldText = this.messages.titleValidationMessageField(assetType, fieldName);
        LabelWidget fieldLabel = new LabelWidget(fieldText);
        fieldLabel.addStyleName(MESSAGE_STYLE);
        fieldLabel.addStyleName(ERROR_MESSAGE_STYLE);
        fieldLabel.addStyleName(FIELD_LINK_STYLE);
        fieldLabel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleValidationView.this.handleFieldLabelClicked(message, event);
            }
        });
        widget.add((Widget)fieldLabel);
        LabelWidget messageLabel = new LabelWidget(message.getMessage());
        messageLabel.addStyleName(MESSAGE_STYLE);
        messageLabel.addStyleName(ERROR_MESSAGE_STYLE);
        widget.add((Widget)messageLabel);
        widget.addStyleName(VALIDATION_WIDGET_STYLE);
        return widget;
    }

    private void handleFieldLabelClicked(AssetValidationMessage message, ClickEvent event) {
        this.parentTab.showWidget(message);
    }

    private Widget buildTitleValidationMessageWidget(UITitleValidationMessage message) {
        LabelWidget widget = new LabelWidget(message.getMessage());
        String styleName = null;
        switch (message.getMessageType()) {
            case Error: {
                styleName = ERROR_MESSAGE_STYLE;
                break;
            }
            case Warning: {
                styleName = WARN_MESSAGE_STYLE;
                break;
            }
            case Information: {
                styleName = INFO_MESSAGE_STYLE;
            }
        }
        widget.addStyleName(MESSAGE_STYLE);
        if (styleName != null) {
            widget.addStyleName(styleName);
        }
        widget.addStyleName(VALIDATION_WIDGET_STYLE);
        return widget;
    }
}

