/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.contentmgmt.service.asset.ITitleManager;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.history.UITitleHistory;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleStatus;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleFileIOException;
import com.tandbergtv.cms.portal.content.client.title.service.TitlePreviewException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleServiceException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleValidationUIException;
import com.tandbergtv.cms.portal.content.server.title.history.UITitleHistoryBuilder;
import com.tandbergtv.cms.portal.content.server.title.metadata.AssetModelConverter;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.core.FatalTitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.ejb.EJBException;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleViewService
implements ITitleViewService,
NeptuneRemoteService {
    private IAssetSpecificationManager specificationManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManager/local", ITitleManager.class);
    private static final Logger logger = Logger.getLogger(TitleViewService.class);
    private static final String ERROR_MESSAGE_BUNDLE = "com.tandbergtv.cms.portal.content.server.title.TitleViewServiceErrorMessages";

    @Override
    public List<String> getSpecificationNames() throws NeptuneException {
        ArrayList<String> specificationNames = new ArrayList<String>();
        Collection specifications = this.specificationManager.getAllSpecifications();
        for (Specification s : specifications) {
            specificationNames.add(s.getName());
        }
        Collections.sort(specificationNames);
        return specificationNames;
    }

    @Override
    @Transactional
    public UITitle createTitle(UITitle title) throws NeptuneException, TitleValidationUIException {
        UITitle uITitle = title;
        return (UITitle)TitleViewService.createTitle_aroundBody1$advice(this, uITitle, TransactionEnforcer.aspectOf(), TitleViewService.class.getDeclaredMethod("createTitle", UITitle.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public UITitle createTitleAsDraft(UITitle title) throws NeptuneException {
        UITitle uITitle = title;
        return (UITitle)TitleViewService.createTitleAsDraft_aroundBody3$advice(this, uITitle, TransactionEnforcer.aspectOf(), TitleViewService.class.getDeclaredMethod("createTitleAsDraft", UITitle.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public UITitle updateTitleMetadata(UITitle title, Long requestKey, String action, String listOfAssetIds) throws NeptuneException {
        UITitle uITitle = title;
        Long l = requestKey;
        String string = action;
        String string2 = listOfAssetIds;
        return (UITitle)TitleViewService.updateTitleMetadata_aroundBody5$advice(this, uITitle, l, string, string2, TransactionEnforcer.aspectOf(), TitleViewService.class.getDeclaredMethod("updateTitleMetadata", UITitle.class, Long.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public UITitle updateTitleMetadataAsDraft(UITitle title) throws NeptuneException, TitleServiceException {
        UITitle uITitle = title;
        return (UITitle)TitleViewService.updateTitleMetadataAsDraft_aroundBody7$advice(this, uITitle, TransactionEnforcer.aspectOf(), TitleViewService.class.getDeclaredMethod("updateTitleMetadataAsDraft", UITitle.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public UITitleMetadata getTitleMetadata(Long titleId) throws NeptuneException {
        Long l = titleId;
        return (UITitleMetadata)TitleViewService.getTitleMetadata_aroundBody9$advice(this, l, TransactionEnforcer.aspectOf(), TitleViewService.class.getDeclaredMethod("getTitleMetadata", Long.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public UITitleHistory getTitleHistory(Long titleId) throws NeptuneException {
        Long l = titleId;
        return (UITitleHistory)TitleViewService.getTitleHistory_aroundBody11$advice(this, l, TransactionEnforcer.aspectOf(), TitleViewService.class.getDeclaredMethod("getTitleHistory", Long.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public UITitleMetadata getTitleMetadata(Long titleId, String titleRevision) throws NeptuneException, TitleServiceException {
        Long l = titleId;
        String string = titleRevision;
        return (UITitleMetadata)TitleViewService.getTitleMetadata_aroundBody13$advice(this, l, string, TransactionEnforcer.aspectOf(), TitleViewService.class.getDeclaredMethod("getTitleMetadata", Long.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void rollbackTitle(Long titleId, String titleRevision) throws NeptuneException {
        Long l = titleId;
        String string = titleRevision;
        TitleViewService.rollbackTitle_aroundBody15$advice(this, l, string, TransactionEnforcer.aspectOf(), TitleViewService.class.getDeclaredMethod("rollbackTitle", Long.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void rollbackTitleAsDraft(Long titleId, String titleRevision) throws NeptuneException {
        Long l = titleId;
        String string = titleRevision;
        TitleViewService.rollbackTitleAsDraft_aroundBody17$advice(this, l, string, TransactionEnforcer.aspectOf(), TitleViewService.class.getDeclaredMethod("rollbackTitleAsDraft", Long.class, String.class).getAnnotation(Transactional.class), null);
    }

    private void logRollbackFailure(Long titleId, String revision, Exception e) {
        String msg = "Failed to roll back to title[Id=" + titleId + ", revision=" + revision + "], error: " + e.getMessage();
        logger.error((Object)msg, (Throwable)e);
    }

    @Override
    public String previewTitle(UITitle title, String specificationName) throws NeptuneException, TitlePreviewException {
        Specification specification = null;
        specification = specificationName != null ? this.specificationManager.getSpecification(specificationName) : this.specificationManager.getDefaultSpecification();
        Title titleToPreview = this.buildTitle(title);
        try {
            return this.titleManager.previewTitle(titleToPreview, specification);
        }
        catch (TranslationException e) {
            logger.error((Object)("Failed to preview title XML for specification: " + specificationName), (Throwable)e);
            throw new TitlePreviewException("Cannot translate title to specification XML.");
        }
    }

    @Override
    public List<UIAssetFilePath> getAvailableFilePaths() throws NeptuneException {
        ArrayList<UIAssetFilePath> filePaths = new ArrayList<UIAssetFilePath>();
        File unmappedFolder = this.titleManager.getUnmappedFileRepository();
        String unmappedFolderPath = unmappedFolder.getAbsolutePath();
        List unmappedFiles = null;
        try {
            unmappedFiles = this.titleManager.getUnmappedFiles();
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to get the unmapped files from the server.", (Throwable)ex);
            throw new TitleFileIOException("Failed to get the unmapped files, error: " + ex.getMessage());
        }
        String repositoryPath = null;
        String relativePath = null;
        int index = unmappedFolderPath.length() + 1;
        for (File file : unmappedFiles) {
            String filePath = file.getAbsolutePath();
            if (filePath.startsWith(unmappedFolderPath)) {
                repositoryPath = filePath.substring(0, index);
                relativePath = filePath.substring(index);
            } else {
                repositoryPath = "";
                relativePath = filePath;
            }
            UIAssetFilePath assetFilePath = new UIAssetFilePath();
            assetFilePath.setRepositoryPath(repositoryPath);
            assetFilePath.setRelativePath(relativePath);
            filePaths.add(assetFilePath);
        }
        Collections.sort(filePaths, new Comparator<UIAssetFilePath>(){

            @Override
            public int compare(UIAssetFilePath o1, UIAssetFilePath o2) {
                return o1.getFilePath().compareTo(o2.getFilePath());
            }
        });
        return filePaths;
    }

    public String getRelativePath() {
        return "service/content/title/ITitleViewService";
    }

    public Class<? extends TitleViewService> getServiceImplementation() {
        return this.getClass();
    }

    private Title buildTitle(UITitle uiTitle) {
        Title title = new Title();
        title.setId(uiTitle.getId());
        AssetModelConverter converter = new AssetModelConverter();
        title.setAsset(converter.convert(uiTitle.getMetadata().getRootAsset()));
        return title;
    }

    private UITitle buildUITitle(Title title) {
        UITitle uiTitle = new UITitle();
        uiTitle.setId(title.getId());
        uiTitle.setMetadata(this.buildMetadata(title));
        return uiTitle;
    }

    private UITitleMetadata buildMetadata(Title title) {
        UITitleMetadata metadata = new UITitleMetadata();
        AssetModelConverter converter = new AssetModelConverter();
        metadata.setRootAsset(converter.convert(title.getAsset()));
        metadata.setActive(title.getIsActive());
        if (title.getStatus() != null) {
            metadata.setTitleStatus(this.getUITitleStatus(title.getStatus()));
        }
        return metadata;
    }

    private UITitleHistory buildHistory(Title title) {
        UITitleHistoryBuilder historyBuilder = new UITitleHistoryBuilder();
        return historyBuilder.build(title);
    }

    private void buildValidationMessages(List<TitleValidationMessage> validationMessages, List<UITitleValidationMessage> uiMessages) {
        if (validationMessages != null) {
            for (TitleValidationMessage validationMessage : validationMessages) {
                uiMessages.add(this.buildValidationMessage(validationMessage));
            }
        }
    }

    private void buildActionResultMessages(String message, List<UITitleValidationMessage> uiMessages) {
        if (message != null && !message.trim().isEmpty()) {
            UITitleValidationMessage tvm = new UITitleValidationMessage(message, UITitleValidationMessageType.Warning);
            uiMessages.add(tvm);
        }
    }

    private UITitleStatus getUITitleStatus(TitleStatus status) {
        if (status == null) {
            return null;
        }
        UITitleStatus uiStatus = null;
        switch (status) {
            case DRAFT: {
                uiStatus = UITitleStatus.DRAFT;
                break;
            }
            case COMMITTED: {
                uiStatus = UITitleStatus.COMMITTED;
                break;
            }
            case APPROVED: {
                uiStatus = UITitleStatus.APPROVED;
                break;
            }
            case READY: {
                uiStatus = UITitleStatus.READY;
                break;
            }
            case RETIRED: {
                uiStatus = UITitleStatus.RETIRED;
            }
        }
        return uiStatus;
    }

    private UITitleValidationMessage buildValidationMessage(TitleValidationMessage validationMessage) {
        String message = validationMessage.getMessage();
        UITitleValidationMessageType uiType = null;
        switch (validationMessage.getType()) {
            case Error: {
                uiType = UITitleValidationMessageType.Error;
                break;
            }
            case Warning: {
                uiType = UITitleValidationMessageType.Warning;
                break;
            }
            case Info: {
                uiType = UITitleValidationMessageType.Information;
            }
        }
        return new UITitleValidationMessage(message, uiType, validationMessage.getCode());
    }

    private void throwUIValidationException(TitleValidationException e, String message) throws TitleValidationUIException {
        ArrayList<UITitleValidationMessage> uiMessages = new ArrayList<UITitleValidationMessage>();
        this.buildValidationMessages(e.getMessages(), uiMessages);
        boolean fatal = e instanceof FatalTitleValidationException;
        if (fatal) {
            message = this.buildLocalizedMessage((FatalTitleValidationException)e);
        }
        throw new TitleValidationUIException(uiMessages, fatal, message);
    }

    @Override
    public void sendSelectAssetNotification(Long titleId, Long assetId, Long requestKey) throws NeptuneException {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"CM0107");
        WPCLCommand command = new WPCLCommand("task-complete");
        message.setCommand(command);
        MessageKeyImpl key = new MessageKeyImpl((Object)requestKey);
        message.setKey((IMessageKey)key);
        message.getPayload().putValue("Title Id", String.valueOf(titleId));
        message.getPayload().putValue("Asset Id", String.valueOf(assetId));
        IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
        try {
            router.send(new WPCLConverter().convert(message));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to send the message to Workflow: " + e.getMessage(), e);
        }
    }

    @Override
    public void sendValidationSuccessConfirmation(Long requestKey) throws NeptuneException {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"CM0108");
        WPCLCommand command = new WPCLCommand("task-complete");
        message.setCommand(command);
        MessageKeyImpl key = new MessageKeyImpl((Object)requestKey);
        message.setKey((IMessageKey)key);
        IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
        try {
            router.send(new WPCLConverter().convert(message));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to send the message to Workflow: " + e.getMessage(), e);
        }
    }

    private TitleServiceException buildTitleServiceException(RuntimeException rte) throws TitleServiceException {
        TitleServiceException uiException = null;
        TitlePersistenceException exception = null;
        if (rte instanceof EJBException) {
            Exception innerException = ((EJBException)rte).getCausedByException();
            if (innerException instanceof TitlePersistenceException) {
                exception = (TitlePersistenceException)innerException;
            } else {
                uiException = new TitleServiceException(innerException.getMessage(), false);
            }
        } else if (rte instanceof TitlePersistenceException) {
            exception = (TitlePersistenceException)rte;
        }
        if (exception != null) {
            String errorCode = exception.getErrorCode();
            String localizedMessage = this.buildLocalizedMessage(exception);
            uiException = "TPS-003".equals(errorCode) ? new ReadDeletedTitleException(localizedMessage) : new TitleServiceException(localizedMessage, true);
        } else if (uiException != null) {
            uiException = new TitleServiceException(rte.getMessage(), false);
        }
        return uiException;
    }

    private String buildLocalizedMessage(TitlePersistenceException e) {
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(ERROR_MESSAGE_BUNDLE, locale);
        String message = bundle.getString(e.getErrorCode());
        MessageFormat format = new MessageFormat(message, locale);
        return format.format(e.getParameters().toArray());
    }

    private String buildLocalizedMessage(FatalTitleValidationException e) {
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(ERROR_MESSAGE_BUNDLE, locale);
        return bundle.getString(e.getErrorCode());
    }

    private static final /* synthetic */ UITitle createTitle_aroundBody0(TitleViewService this_, UITitle title) {
        Title titleToSave = this_.buildTitle(title);
        SaveResult result = null;
        try {
            result = this_.titleManager.createTitle(titleToSave);
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                String error = "Failed to create the title because of fatal validation errors.";
                logger.error((Object)error, (Throwable)e);
            }
            String message = "Failed to create the title because of validation errors.";
            this_.throwUIValidationException(e, message);
        }
        catch (JMSException e) {
            logger.error((Object)"Failed to create title.", (Throwable)e);
            String msg = "Failed to create title because of failure performing title validation.";
            throw new TitleServiceException(msg);
        }
        catch (RuntimeException e) {
            logger.error((Object)"Failed to create title.", (Throwable)e);
            throw this_.buildTitleServiceException(e);
        }
        UITitle uiTitle = this_.buildUITitle(result.getTitle());
        List<UITitleValidationMessage> uiMessages = uiTitle.getMetadata().getValidationMessages();
        this_.buildValidationMessages(result.getValidationMessages(), uiMessages);
        return uiTitle;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object createTitle_aroundBody1$advice(TitleViewService this_, UITitle transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return TitleViewService.createTitle_aroundBody0(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            UITitle uITitle = TitleViewService.createTitle_aroundBody0(this_, transactional);
            object.commit();
            return uITitle;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ UITitle createTitleAsDraft_aroundBody2(TitleViewService this_, UITitle title) {
        Title titleToSave = this_.buildTitle(title);
        Title savedTitle = null;
        try {
            savedTitle = this_.titleManager.createTitleAsDraft(titleToSave);
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                String error = "Failed to create title as draft because of fatal validation errors.";
                logger.error((Object)error, (Throwable)e);
            }
            String message = "Failed to create title as draft because of validation errors.";
            this_.throwUIValidationException(e, message);
        }
        catch (RuntimeException e) {
            logger.error((Object)"Failed to create title as draft.", (Throwable)e);
            throw this_.buildTitleServiceException(e);
        }
        return this_.buildUITitle(savedTitle);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object createTitleAsDraft_aroundBody3$advice(TitleViewService this_, UITitle transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return TitleViewService.createTitleAsDraft_aroundBody2(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            UITitle uITitle = TitleViewService.createTitleAsDraft_aroundBody2(this_, transactional);
            object.commit();
            return uITitle;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ UITitle updateTitleMetadata_aroundBody4(TitleViewService this_, UITitle title, Long requestKey, String action, String listOfAssetIds) {
        Title titleToSave = this_.buildTitle(title);
        SaveResult result = null;
        try {
            result = this_.titleManager.updateTitleMetadata(titleToSave, requestKey, action, listOfAssetIds);
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                String error = "Failed to update title because of fatal validation errors.";
                logger.error((Object)error, (Throwable)e);
            }
            String message = "Failed to update title because of validation errors.";
            this_.throwUIValidationException(e, message);
        }
        catch (JMSException e) {
            logger.error((Object)"Failed to update title.", (Throwable)e);
            String msg = "Failed to update title because of failure performing title validation.";
            throw new TitleServiceException(msg);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to update title[" + title.getId() + "]."), (Throwable)e);
            throw this_.buildTitleServiceException(e);
        }
        UITitle uiTitle = this_.buildUITitle(result.getTitle());
        List<UITitleValidationMessage> uiMessages = uiTitle.getMetadata().getValidationMessages();
        this_.buildValidationMessages(result.getValidationMessages(), uiMessages);
        Map actionMap = result.getActionResponseMap();
        if (actionMap != null) {
            String message = "The following asset(s) (" + (String)actionMap.get("unmappedAssets") + ") do not have original files. " + "Manual task will not be closed until original files are specified.";
            this_.buildActionResultMessages(message, uiMessages);
        }
        return uiTitle;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object updateTitleMetadata_aroundBody5$advice(TitleViewService this_, UITitle transactional, Long ajc_aroundClosure, String string, String string2, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            return TitleViewService.updateTitleMetadata_aroundBody4(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            UITitle uITitle = TitleViewService.updateTitleMetadata_aroundBody4(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
            transactionManager2.commit();
            return uITitle;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ UITitle updateTitleMetadataAsDraft_aroundBody6(TitleViewService this_, UITitle title) {
        Title titleToSave = this_.buildTitle(title);
        Title savedTitle = null;
        try {
            savedTitle = this_.titleManager.updateTitleMetadataAsDraft(titleToSave);
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                String error = "Failed to update title as draft because of fatal validation errors.";
                logger.error((Object)error, (Throwable)e);
            }
            String message = "Failed to update title as draft because of validation errors.";
            this_.throwUIValidationException(e, message);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to update title[" + title.getId() + "] as draft."), (Throwable)e);
            throw this_.buildTitleServiceException(e);
        }
        return this_.buildUITitle(savedTitle);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object updateTitleMetadataAsDraft_aroundBody7$advice(TitleViewService this_, UITitle transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return TitleViewService.updateTitleMetadataAsDraft_aroundBody6(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            UITitle uITitle = TitleViewService.updateTitleMetadataAsDraft_aroundBody6(this_, transactional);
            object.commit();
            return uITitle;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ UITitleMetadata getTitleMetadata_aroundBody8(TitleViewService this_, Long titleId) {
        Title title = null;
        try {
            title = this_.titleManager.getTitle(titleId);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to read title[" + titleId + "] from the server."), (Throwable)e);
            throw this_.buildTitleServiceException(e);
        }
        return this_.buildMetadata(title);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getTitleMetadata_aroundBody9$advice(TitleViewService this_, Long transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return TitleViewService.getTitleMetadata_aroundBody8(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            UITitleMetadata uITitleMetadata = TitleViewService.getTitleMetadata_aroundBody8(this_, transactional);
            object.commit();
            return uITitleMetadata;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ UITitleHistory getTitleHistory_aroundBody10(TitleViewService this_, Long titleId) {
        Title title = null;
        try {
            title = this_.titleManager.getTitle(titleId);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to read title[" + titleId + "] from the server."), (Throwable)e);
            throw this_.buildTitleServiceException(e);
        }
        return this_.buildHistory(title);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getTitleHistory_aroundBody11$advice(TitleViewService this_, Long transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return TitleViewService.getTitleHistory_aroundBody10(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            UITitleHistory uITitleHistory = TitleViewService.getTitleHistory_aroundBody10(this_, transactional);
            object.commit();
            return uITitleHistory;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ UITitleMetadata getTitleMetadata_aroundBody12(TitleViewService this_, Long titleId, String titleRevision) {
        Title title = null;
        try {
            title = this_.titleManager.getTitle(titleId, titleRevision);
        }
        catch (SearchException e) {
            String msg = "Failed to get title[Id=" + titleId + ", revision=" + titleRevision + "], error: " + e.getMessage();
            logger.error((Object)msg, (Throwable)e);
            throw new TitleServiceException("Failed to find title revision " + titleRevision + " for title ID " + titleId);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to read versioned title[" + titleId + ", " + titleRevision + "] from the server."), (Throwable)e);
            throw this_.buildTitleServiceException(e);
        }
        return this_.buildMetadata(title);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getTitleMetadata_aroundBody13$advice(TitleViewService this_, Long transactional, String ajc_aroundClosure, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_11 = e;
            void var11_12 = isTransactionOwner;
            return TitleViewService.getTitleMetadata_aroundBody12(this_, transactional, ajc_aroundClosure);
        }
        try {
            transactionManager.begin();
            void var12_13 = e;
            void var13_14 = isTransactionOwner;
            UITitleMetadata uITitleMetadata = TitleViewService.getTitleMetadata_aroundBody12(this_, transactional, ajc_aroundClosure);
            transactionManager.commit();
            return uITitleMetadata;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void rollbackTitle_aroundBody14(TitleViewService this_, Long titleId, String titleRevision) {
        try {
            this_.titleManager.rollbackTitle(titleId, titleRevision);
        }
        catch (MetadataException e) {
            this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            throw new TitleServiceException("Failed to roll back title to revision " + titleRevision);
        }
        catch (SearchException e) {
            this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            throw new TitleServiceException("Failed to find title revision " + titleRevision + " for roll back.");
        }
        catch (TranslationException e) {
            this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            throw new TitleServiceException("Failed to roll back title to revision " + titleRevision);
        }
        catch (InvalidRevisionException e) {
            this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            throw new TitleServiceException("Failed to roll back title to revision " + titleRevision + ", revision matches the current revision.");
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            }
            String message = "Failed to roll back title to revision " + titleRevision + " due to validation errors.";
            this_.throwUIValidationException(e, message);
        }
        catch (RuntimeException e) {
            this_.logRollbackFailure(titleId, titleRevision, e);
            throw this_.buildTitleServiceException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object rollbackTitle_aroundBody15$advice(TitleViewService this_, Long transactional, String ajc_aroundClosure, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_11 = e;
            void var11_12 = isTransactionOwner;
            TitleViewService.rollbackTitle_aroundBody14(this_, transactional, ajc_aroundClosure);
            return null;
        }
        try {
            transactionManager.begin();
            void var12_13 = e;
            void var13_14 = isTransactionOwner;
            TitleViewService.rollbackTitle_aroundBody14(this_, transactional, ajc_aroundClosure);
            Object var8_9 = null;
            transactionManager.commit();
            return var8_9;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void rollbackTitleAsDraft_aroundBody16(TitleViewService this_, Long titleId, String titleRevision) {
        try {
            this_.titleManager.rollbackAndSaveAsDraft(titleId, titleRevision);
        }
        catch (MetadataException e) {
            this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            throw new TitleServiceException("Failed to roll back title to revision " + titleRevision);
        }
        catch (SearchException e) {
            this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            throw new TitleServiceException("Failed to find title revision " + titleRevision + " for roll back.");
        }
        catch (TranslationException e) {
            this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            throw new TitleServiceException("Failed to roll back title to revision " + titleRevision);
        }
        catch (InvalidRevisionException e) {
            this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            throw new TitleServiceException("Failed to roll back title to revision " + titleRevision + ", revision matches the current revision.");
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                this_.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            }
            String message = "Failed to roll back title to revision " + titleRevision + " due to validation errors.";
            this_.throwUIValidationException(e, message);
        }
        catch (RuntimeException e) {
            this_.logRollbackFailure(titleId, titleRevision, e);
            throw this_.buildTitleServiceException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object rollbackTitleAsDraft_aroundBody17$advice(TitleViewService this_, Long transactional, String ajc_aroundClosure, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_11 = e;
            void var11_12 = isTransactionOwner;
            TitleViewService.rollbackTitleAsDraft_aroundBody16(this_, transactional, ajc_aroundClosure);
            return null;
        }
        try {
            transactionManager.begin();
            void var12_13 = e;
            void var13_14 = isTransactionOwner;
            TitleViewService.rollbackTitleAsDraft_aroundBody16(this_, transactional, ajc_aroundClosure);
            Object var8_9 = null;
            transactionManager.commit();
            return var8_9;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

