/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.metadata;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIItemAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.server.title.metadata.UISimpleFieldBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataTypeProvider;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.ParentChildRelation;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class UIAssetBuilder {
    private static final Logger logger = Logger.getLogger(UIAssetBuilder.class);
    private Map<String, UIFieldDataType> dataTypes = new HashMap<String, UIFieldDataType>();
    private AssetUtil assetUtil = new AssetUtil();

    public UIAssetBuilder() {
        this.initializeDataTypeMap();
    }

    private void initializeDataTypeMap() {
        List all = new UIFieldDataTypeProvider().getAll();
        for (UIFieldDataType dataType : all) {
            this.dataTypes.put(dataType.getName(), dataType);
        }
    }

    public UIAsset build(Asset asset) {
        UIAsset uiAsset = null;
        if ((asset = this.assetUtil.unWrap(asset)).getClass().equals(Group.class)) {
            uiAsset = this.buildGroup((Group)Group.class.cast(asset));
        } else if (asset.getClass().equals(Item.class)) {
            uiAsset = this.buildItem((Item)Item.class.cast(asset));
        } else {
            logger.debug((Object)("Ignoring asset subclass: " + asset.getClass().getName() + " when building UI Asset."));
        }
        return uiAsset;
    }

    private UIGroupAsset buildGroup(Group group) {
        UIGroupAsset uiGroup = new UIGroupAsset();
        this.copyProperties((Asset)group, uiGroup);
        uiGroup.setAssetType(group.getType());
        for (Relation relation : group.getRelations()) {
            Asset child;
            if (!ParentChildRelation.class.isInstance(relation) || (child = this.assetUtil.unWrap(relation.getTargetAsset())) instanceof File) continue;
            uiGroup.addChild(this.build(child));
        }
        return uiGroup;
    }

    private UIItemAsset buildItem(Item item) {
        UIItemAsset uiItem = new UIItemAsset();
        this.copyProperties((Asset)item, uiItem);
        uiItem.setAssetType(item.getType());
        return uiItem;
    }

    private void copyProperties(Asset asset, UIAsset uiAsset) {
        uiAsset.setId(asset.getId());
        uiAsset.setActive(AssetState.ACTIVE.equals((Object)asset.getState()));
        this.buildFields(asset, uiAsset);
        this.buildFiles(asset, uiAsset, null);
        Collections.sort(uiAsset.getFiles(), new Comparator<UIAssetFile>(){

            @Override
            public int compare(UIAssetFile o1, UIAssetFile o2) {
                return o2.getId().compareTo(o1.getId());
            }
        });
    }

    private void buildFields(Asset asset, UIAsset uiAsset) {
        FieldTreeNode rootFieldTreeNode = asset.getFieldTree().getRootElement();
        UIComplexField uiRootField = uiAsset.getRootField();
        for (FieldTreeNode fieldTreeNode : rootFieldTreeNode.getChildren()) {
            UIField uiField = this.buildField(fieldTreeNode);
            uiRootField.addField(uiField);
        }
    }

    private UIField buildField(FieldTreeNode fieldNode) {
        UIField uiField = null;
        if (!fieldNode.isLeafNode()) {
            UIComplexField complexField = new UIComplexField();
            complexField.setName(fieldNode.getName());
            for (FieldTreeNode childFieldNode : fieldNode.getChildren()) {
                UIField childField = this.buildField(childFieldNode);
                complexField.addField(childField);
            }
            uiField = complexField;
        } else {
            String dataTypeName = fieldNode.getField().getDataType();
            UIFieldDataType dataType = this.dataTypes.get(dataTypeName);
            UISimpleFieldBuilder fieldBuilder = new UISimpleFieldBuilder();
            uiField = fieldBuilder.build(fieldNode, dataType);
        }
        return uiField;
    }

    private void buildFiles(Asset asset, UIAsset uiAsset, UIAssetFile uiAssetFile) {
        for (Relation relation : asset.getRelations()) {
            Asset child;
            if (!ParentChildRelation.class.isInstance(relation) || !((child = this.assetUtil.unWrap(relation.getTargetAsset())) instanceof File)) continue;
            UIAssetFile uiFile = this.buildFile((File)File.class.cast(child));
            uiAsset.addFile(uiFile);
            uiFile.setParentFile(uiAssetFile);
            this.buildFiles(child, uiAsset, uiFile);
        }
    }

    private UIAssetFile buildFile(File file) {
        UIAssetFile uiFile = new UIAssetFile();
        uiFile.setId(file.getId());
        uiFile.setActive(AssetState.ACTIVE.equals((Object)file.getState()));
        UISimpleFieldBuilder fieldBuilder = new UISimpleFieldBuilder();
        for (Field field : file.getFields()) {
            FieldTreeNode fieldNode = new FieldTreeNode();
            fieldNode.setName(field.getTtvXPath());
            fieldNode.setField(field);
            String dataTypeName = field.getDataType();
            UIFieldDataType dataType = this.dataTypes.get(dataTypeName);
            UISimpleField<?> uiField = fieldBuilder.build(fieldNode, dataType);
            UIAssetFileField uiFileField = new UIAssetFileField();
            uiFileField.setField(uiField);
            uiFile.addField(uiFileField);
        }
        return uiFile;
    }
}

