/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.criteria;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.ret.RetNode;
import com.ericsson.cms.criteria.ret.RetOperator;
import com.ericsson.cms.criteria.ret.RetTree;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="expList")
public class ExpList
extends ExpNode {
    private static final long serialVersionUID = -58138914851857917L;
    public static final String AND = "AND";
    public static final String OR = "OR";
    protected String operator;
    protected List<ExpNode> nodes;

    public ExpList() {
        this.nodes = new ArrayList<ExpNode>();
        this.operator = AND;
    }

    public ExpList(String operator, List<ExpNode> nodes) {
        this.nodes = nodes;
        this.operator = operator;
    }

    public ExpList(Integer nodeId, String operator, Date createDate, Date updateDate, List<ExpNode> nodes) {
        super(nodeId, createDate, updateDate);
        this.nodes = nodes;
        this.operator = operator;
    }

    public ExpList(String operator) {
        this.operator = operator;
        this.nodes = new ArrayList<ExpNode>();
    }

    public void setNodes(List<ExpNode> nodes) {
        this.nodes = nodes;
    }

    @XmlElementWrapper(name="nodes")
    @XmlElement(name="node", nillable=true)
    public List<ExpNode> getNodes() {
        return this.nodes;
    }

    public void setOperator(String operator) {
        if (!operator.equals(AND) && !operator.equals(OR)) {
            throw new IllegalArgumentException("Operator should be \"AND\" or \"OR\" the value passed in was: " + operator);
        }
        this.operator = operator;
    }

    @XmlElement(nillable=true)
    public String getOperator() {
        return this.operator;
    }

    public String getSqlOperator() {
        return this.getOperator() == AND ? " and " : " or ";
    }

    public void addItem(ExpNode node) {
        this.nodes.add(node);
    }

    @Override
    public RetTree getAsOptimizedTree() {
        RetTree tree = new RetTree();
        tree.setRoot(this.buildTree(this));
        return tree;
    }

    protected RetNode buildTree(ExpList currExpList) {
        RetOperator rootNode;
        List<ExpNode> currList = currExpList.getNodes();
        if (currList.size() == 0) {
            throw new IllegalArgumentException("the size of the currExpList should be greater than zero");
        }
        if (currList.size() == 1) {
            if (currList.get(0) instanceof ExpValue) {
                return ((ExpValue)currList.get(0)).getAsRetOperand();
            }
            if (currList.get(0) instanceof ExpList) {
                return this.buildTree((ExpList)currList.get(0));
            }
        }
        RetOperator currOper = rootNode = new RetOperator(currExpList.getOperator());
        for (int i = 0; i < currList.size(); ++i) {
            ExpNode currNode = currList.get(i);
            if (i < currList.size() - 1) {
                if (currNode instanceof ExpValue) {
                    currOper.setLeft(((ExpValue)currNode).getAsRetOperand());
                } else if (currNode instanceof ExpList) {
                    currOper.setLeft(this.buildTree((ExpList)currNode));
                }
                if (i >= currList.size() - 2) continue;
                RetOperator temp = new RetOperator(currOper.getOperator());
                currOper.setRight(temp);
                currOper = temp;
                continue;
            }
            if (currNode instanceof ExpValue) {
                currOper.setRight(((ExpValue)currNode).getAsRetOperand());
                continue;
            }
            if (!(currNode instanceof ExpList)) continue;
            currOper.setRight(this.buildTree((ExpList)currNode));
        }
        return rootNode;
    }

    public boolean hasCriteria() {
        if (this.nodes == null) {
            return false;
        }
        return this.nodes.size() > 0;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public ExpList clone() {
        ArrayList<ExpNode> nodesClone = new ArrayList<ExpNode>();
        if (this.nodes == null) {
            return new ExpList(this.operator, null);
        }
        for (ExpNode node : this.nodes) {
            nodesClone.add(node.clone());
        }
        return new ExpList(this.operator, nodesClone);
    }
}

