/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TimeBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UIGenericType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.DateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class DataTypeSpecificWidget
extends HorizontalContainer {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private UIFieldDataType currDataType;
    private TextBoxWidget textWidget;
    private DateBox dateBox;
    private TimeBox timeWidget;
    private boolean isRegex = false;
    private DateTimeFormat dateFormater = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
    private ListBoxWidget<Boolean> boolWidget = new ListBoxWidget();

    public DataTypeSpecificWidget() {
        this.addTheWidgets();
        this.resetField(new StringDataType(), false);
    }

    public DataTypeSpecificWidget(UIFieldDataType DataType, String value) {
        this.addTheWidgets();
        this.setValue(DataType, this.isRegex, value);
    }

    public void setVisibleLength(int length) {
        this.textWidget.setVisibleLength(length);
        this.timeWidget.setVisibleLength(length);
        this.dateBox.getTextBox().setVisibleLength(length);
    }

    public boolean hasContents() {
        if (this.currDataType instanceof BooleanDataType) {
            return true;
        }
        if (this.currDataType instanceof IntegerDataType) {
            return !this.textWidget.getText().equals("");
        }
        if (this.currDataType instanceof FloatDataType) {
            return !this.textWidget.getText().equals("");
        }
        if (this.currDataType instanceof StringDataType) {
            return !this.textWidget.getText().equals("");
        }
        if (this.currDataType instanceof DateDataType) {
            return !this.dateBox.getTextBox().getText().equals("");
        }
        return this.currDataType instanceof TimeDataType;
    }

    private void addTheWidgets() {
        this.textWidget = new TextBoxWidget();
        this.textWidget.addChangeHandler(this.getValidatedTextHandler());
        this.textWidget.setMaxLength(1000);
        this.dateBox = new DateBoxWidget();
        this.dateBox.setTitle(String.valueOf(this.myConstants.validDateTitle()) + " " + this.dateFormater.getPattern());
        DateBox.DefaultFormat fmt = new DateBox.DefaultFormat(this.dateFormater);
        this.dateBox.setFormat((DateBox.Format)fmt);
        this.boolWidget.addItem(this.myConstants.falseText(), (Object)false);
        this.boolWidget.addItem(this.myConstants.trueText(), (Object)true);
        this.boolWidget.setSelectedIndex(0);
        this.timeWidget = new TimeBox();
        this.add((Widget)this.textWidget);
        this.add((Widget)this.dateBox);
        this.add((Widget)this.boolWidget);
        this.add((Widget)this.timeWidget);
        this.resetErrorState();
    }

    private ChangeHandler getValidatedTextHandler() {
        return new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                DataTypeSpecificWidget.this.validate(true);
            }
        };
    }

    public boolean validate() {
        return this.validate(false);
    }

    private boolean isValidRegex(String s) {
        return true;
    }

    public boolean validate(boolean ignoreBlanks) {
        if (this.currDataType == null || this.currDataType instanceof BooleanDataType) {
            return true;
        }
        if (!this.hasContents()) {
            if (ignoreBlanks) {
                this.setUiErrorState(true);
                return true;
            }
            this.setUiErrorState(false);
            return false;
        }
        if (this.isRegex) {
            boolean isValidRegex = this.isValidRegex(this.textWidget.getText());
            this.setUiErrorState(isValidRegex);
            return isValidRegex;
        }
        if (this.currDataType instanceof DateDataType) {
            return this.dateBox.getValue() != null;
        }
        String s = this.currDataType instanceof TimeDataType ? this.timeWidget.getValue() : this.textWidget.getText();
        boolean validationResult = this.currDataType.isValid(s);
        this.setUiErrorState(validationResult);
        return validationResult;
    }

    public void resetField(UIFieldDataType dataType, boolean isRegex) {
        this.isRegex = isRegex;
        this.currDataType = dataType;
        if (dataType == null) {
            this.dateBox.setVisible(false);
            this.boolWidget.setVisible(false);
            this.textWidget.setVisible(false);
            this.timeWidget.setVisible(false);
        } else if (dataType instanceof BooleanDataType) {
            this.dateBox.setVisible(false);
            this.boolWidget.setVisible(true);
            this.textWidget.setVisible(false);
            this.timeWidget.setVisible(false);
        } else if (dataType instanceof DateDataType) {
            this.dateBox.setVisible(true);
            this.boolWidget.setVisible(false);
            this.textWidget.setVisible(false);
            this.timeWidget.setVisible(false);
        } else if (dataType instanceof TimeDataType) {
            this.dateBox.setVisible(false);
            this.boolWidget.setVisible(false);
            this.textWidget.setVisible(false);
            this.timeWidget.setVisible(true);
        } else {
            this.dateBox.setVisible(false);
            this.boolWidget.setVisible(false);
            this.timeWidget.setVisible(false);
            this.textWidget.setVisible(true);
            if (dataType instanceof StringDataType) {
                this.textWidget.setTitle(this.myConstants.validStringTitle());
            } else if (dataType instanceof IntegerDataType) {
                this.textWidget.setTitle(this.myConstants.validIntegerTitle());
            } else if (dataType instanceof FloatDataType) {
                this.textWidget.setTitle(this.myConstants.validFloatTitle());
            }
            this.validate(true);
        }
    }

    public void resetFieldWithGenericType(UIGenericType genericType) {
        UIFieldDataType dataType = genericType.getDataType();
        if (dataType instanceof IntegerDataType || dataType instanceof StringDataType || dataType instanceof FloatDataType) {
            this.textWidget.setText(genericType.toString());
        } else if (dataType instanceof DateDataType) {
            this.dateBox.setValue(genericType.getDateValue());
        } else if (dataType instanceof BooleanDataType) {
            this.boolWidget.setSelectedItem((Object)genericType.getBooleanValue());
        } else if (dataType instanceof TimeDataType) {
            this.timeWidget.setValue(genericType.toString());
        }
        this.resetField(dataType, this.isRegex);
    }

    public Object getValue() {
        if (this.currDataType instanceof BooleanDataType) {
            return this.boolWidget.getSelectedItem();
        }
        if (this.currDataType instanceof IntegerDataType) {
            return this.textWidget.getText().equals("") ? null : Long.valueOf(Long.parseLong(this.textWidget.getText()));
        }
        if (this.currDataType instanceof FloatDataType) {
            return this.textWidget.getText().equals("") ? null : Float.valueOf(Float.parseFloat(this.textWidget.getText()));
        }
        if (this.currDataType instanceof StringDataType) {
            return this.textWidget.getText();
        }
        if (this.currDataType instanceof DateDataType) {
            return this.dateBox.getValue();
        }
        if (this.currDataType instanceof TimeDataType) {
            return this.timeWidget.toString();
        }
        return null;
    }

    public void setValue(UIFieldDataType dataType, boolean isRegex, String value) {
        if (dataType instanceof IntegerDataType || dataType instanceof StringDataType || dataType instanceof FloatDataType) {
            this.textWidget.setText(value);
        } else if (dataType instanceof DateDataType) {
            this.dateBox.setValue(this.dateFormater.parse(this.stripTime(value)));
        } else if (dataType instanceof BooleanDataType) {
            this.boolWidget.setSelectedItem((Object)new Boolean(value));
        } else if (dataType instanceof TimeDataType) {
            this.timeWidget.setValue(value);
        }
        this.resetField(dataType, isRegex);
    }

    public String getValueAsString() {
        if (this.currDataType instanceof BooleanDataType) {
            return ((Boolean)this.boolWidget.getSelectedItem()).toString();
        }
        if (this.currDataType instanceof IntegerDataType || this.currDataType instanceof StringDataType || this.currDataType instanceof FloatDataType) {
            return this.textWidget.getText();
        }
        if (this.currDataType instanceof TimeDataType) {
            return this.timeWidget.toString();
        }
        if (this.currDataType instanceof DateDataType) {
            return this.addTime(this.dateFormater.format(this.dateBox.getValue()));
        }
        return null;
    }

    private void setUiErrorState(boolean valid) {
        String style = valid ? "whitebox" : "pinkbox";
        this.textWidget.setStyleName(style);
    }

    private void resetErrorState() {
        this.setUiErrorState(true);
    }

    private String addTime(String date) {
        String suffix = "T00:00:00.000";
        return String.valueOf(date) + suffix;
    }

    private String stripTime(String date) {
        return date.substring(0, 10);
    }

    public UIFieldDataType getCurrDataType() {
        return this.currDataType;
    }

    public void setCurrDataType(UIFieldDataType currDataType) {
        this.currDataType = currDataType;
    }

    public TextBoxWidget getTextWidget() {
        return this.textWidget;
    }
}

