/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRowBase;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlTreeObject;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class PredicateList
extends PredicateRowBase {
    public static int OP_AND = 0;
    public static int OP_OR = 1;
    private int listOperator;
    private LabelWidget label;
    private Widget container = this.createContainer();

    public PredicateList() {
        this.container.setVisible(false);
        this.add(this.container);
    }

    @Override
    protected FlexTable createContainer() {
        this.label = new LabelWidget(this.myConstants.and());
        this.label.setStyleName("bracket-label");
        this.label.addClickHandler(this.getToggleImageListener());
        VerticalContainer labelContainer = new VerticalContainer();
        labelContainer.add((Widget)this.label);
        FlexTable tableContainer = new FlexTable();
        tableContainer.setWidget(0, 0, (Widget)this.label);
        tableContainer.getCellFormatter().setStyleName(0, 0, "bracket");
        tableContainer.setWidget(0, 1, (Widget)this.childrenPanel);
        return tableContainer;
    }

    private ClickHandler getToggleImageListener() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                LabelWidget label = (LabelWidget)event.getSource();
                boolean and = label.getText().contains(PredicateList.this.myConstants.and());
                PredicateList.this.listOperator = and ? OP_OR : OP_AND;
                String s = and ? PredicateList.this.myConstants.or() : PredicateList.this.myConstants.and();
                label.setText(s);
            }
        };
    }

    public int getOperator() {
        return this.listOperator;
    }

    public void setOperator(int op) {
        this.listOperator = op;
        this.label.setText(this.listOperator == OP_AND ? this.myConstants.and() : this.myConstants.or());
    }

    @Override
    public boolean validate() {
        boolean result = true;
        for (PredicateRowBase pr : this.children) {
            if (pr.validate()) continue;
            result = false;
        }
        return result;
    }

    public boolean contains(XmlTreeObject treeObject) {
        return this.predicateRowsWithTreeObject(treeObject) > 0;
    }

    public int predicateRowsWithTreeObject(XmlTreeObject treeObject) {
        int count = 0;
        for (PredicateRowBase row : this.children) {
            if (row instanceof PredicateList) {
                count += ((PredicateList)row).predicateRowsWithTreeObject(treeObject);
                continue;
            }
            PredicateRow predRow = (PredicateRow)row;
            if (treeObject == null || predRow.isDeleted() || !treeObject.equals(predRow.getXmlTreeObject())) continue;
            ++count;
        }
        return count;
    }

    public boolean treeIsEmpty() {
        PredicateList root = this.findRoot();
        return this.countChildren(root) == 0;
    }

    public void cleanUpOperatorListVisible() {
        PredicateList root = this.findRoot();
        this.cleanUpOperListVisibleRec(root);
    }

    private boolean cleanUpOperListVisibleRec(PredicateList rootNode) {
        boolean allClear = true;
        for (PredicateRowBase base : rootNode.children) {
            if (base instanceof PredicateRow && !((PredicateRow)base).isDeleted()) {
                allClear = false;
                continue;
            }
            if (!(base instanceof PredicateList) || this.cleanUpOperListVisibleRec((PredicateList)base)) continue;
            allClear = false;
        }
        rootNode.setOperatorListVisible(!allClear);
        return allClear;
    }

    private PredicateList findRoot() {
        PredicateRowBase currList = this;
        while (currList.parentList != null) {
            currList = currList.parentList;
        }
        return currList;
    }

    public boolean isEmpty() {
        return this.countChildren(this) == 0;
    }

    public void setOperatorListVisible(boolean visible) {
        this.container.setVisible(visible);
    }

    private int countChildren(PredicateList list) {
        int foundChild = 0;
        for (PredicateRowBase item : list.getChildRowNodes()) {
            if (item instanceof PredicateRow && !((PredicateRow)item).isDeleted()) {
                ++foundChild;
                continue;
            }
            if (!(item instanceof PredicateList)) continue;
            foundChild += this.countChildren((PredicateList)item);
        }
        return foundChild;
    }
}

