/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class TimeBox
extends HorizontalContainer {
    private TextBoxWidget timeWidget = new TextBoxWidget();
    private TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private static TimeDataType TIME = new TimeDataType();

    public TimeBox() {
        this("00:00:00");
    }

    public TimeBox(String value) {
        this.setValue(value);
        this.putDaUiTogether();
    }

    public void setVisibleLength(int length) {
        this.timeWidget.setVisibleLength(length);
    }

    protected void putDaUiTogether() {
        TextBoxWidget box = this.timeWidget;
        box.setTitle(this.myConstants.validTimeTitle());
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TimeBox.this.normalize();
                TimeBox.this.updateWidgetErrorState(TIME.isValid(TimeBox.this.timeWidget.getText()));
            }
        });
        this.add((Widget)this.timeWidget);
    }

    public void normalize() {
        String[] strValues = this.timeWidget.getText().split(":");
        int[] intValues = new int[3];
        if (strValues.length > 3) {
            return;
        }
        int i = 0;
        while (i < strValues.length) {
            String val = strValues[i];
            try {
                intValues[i] = Integer.parseInt(val);
            }
            catch (NumberFormatException x) {
                return;
            }
            ++i;
        }
        i = 2;
        while (i > 0) {
            int n = i - 1;
            intValues[n] = intValues[n] + intValues[i] / 60;
            intValues[i] = intValues[i] % 60;
            --i;
        }
        if (intValues[0] > 23 || intValues[1] > 59 || intValues[2] > 59) {
            return;
        }
        this.timeWidget.setText(String.valueOf(this.padWitZero(intValues[0])) + ":" + this.padWitZero(intValues[1]) + ":" + this.padWitZero(intValues[2]));
    }

    private String padWitZero(int num) {
        if (num > 9) {
            return "" + num;
        }
        return "0" + num;
    }

    public void updateWidgetErrorState(boolean valid) {
        String style = valid ? "whitebox" : "pinkbox";
        this.timeWidget.setStyleName(style);
    }

    public String toString() {
        return this.timeWidget.getText();
    }

    public void setValue(String value) {
        this.timeWidget.setText(value);
    }

    public String getValue() {
        return this.timeWidget.getText();
    }
}

