/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlSelectionHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import java.util.Iterator;
import java.util.List;

public class XmlSelection
extends PopupContainer {
    private TreeWidget tree = new TreeWidget();
    private TreeWidget subtree = new TreeWidget();
    private XmlSelectionHandler handler;
    private int currentPosition = 0;
    private static final int BOX_HEIGHT_INT = 200;
    private ScrollContainer full = new ScrollContainer();
    private ScrollContainer partial = new ScrollContainer();
    private List<TreeItem> items;
    private Timer tfull = new Timer(){

        public void run() {
            XmlSelection.this.full.setScrollPosition(XmlSelection.this.currentPosition);
        }
    };
    private Timer tpartial = new Timer(){

        public void run() {
            XmlSelection.this.partial.setScrollPosition(XmlSelection.this.currentPosition);
        }
    };

    public XmlSelection(UIAssetSpecification spec) {
        super(true);
        this.subtree.addSelectionHandler(this.getSelectionHandler());
        this.tree.addSelectionHandler(this.getSelectionHandler());
        this.items = TreeCreator.populateTree(spec);
        for (TreeItem item : this.items) {
            this.tree.addItem(item);
        }
        this.full.setSize("250px", "200px");
        this.full.add((Widget)this.tree);
        this.partial.setSize("250px", "200px");
        this.partial.add((Widget)this.subtree);
        this.setWidget((Widget)this.full);
        this.addScrollHack();
    }

    private void addScrollHack() {
        this.tree.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                XmlSelection.this.currentPosition = XmlSelection.this.full.getScrollPosition();
            }
        });
        this.tree.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                XmlSelection.this.tfull.schedule(5);
            }
        });
        this.subtree.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                XmlSelection.this.currentPosition = XmlSelection.this.full.getScrollPosition();
            }
        });
        this.subtree.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                XmlSelection.this.tpartial.schedule(5);
            }
        });
    }

    public void show(int x, int y, XmlSelectionHandler handler, XmlTreeObject xmlObj) {
        this.handler = handler;
        if (this.getWidget() != this.full) {
            this.setWidget((Widget)this.full);
        }
        if (xmlObj != null) {
            String assType = xmlObj.getAssetType();
            String xpath = xmlObj.getXpath();
            TreeItem item = this.findItem(assType, xpath);
            this.tree.setSelectedItem(item, true);
        }
        this.showTree(x, y);
    }

    public void show(int x, int y, XmlTreeObject xmlObj, XmlSelectionHandler handler, TreeItem subitem) {
        this.handler = handler;
        if (subitem == null) {
            this.show(x, y, handler, xmlObj);
        } else {
            this.subtree.clear();
            this.subtree.addItem(subitem);
            if (this.getWidget() != this.partial) {
                this.setWidget((Widget)this.partial);
            }
            if (xmlObj != null) {
                String assType = xmlObj.getAssetType();
                String xpath = xmlObj.getXpath();
                TreeItem item = this.findItem(assType, xpath, this.subtree);
                this.subtree.setSelectedItem(item, true);
            }
            this.showTree(x, y);
        }
    }

    private void showTree(final int x, final int y) {
        this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                int height = Window.getClientHeight();
                int yOffset = 0;
                if (y + 200 > height) {
                    yOffset = 200;
                }
                XmlSelection.this.setPopupPosition(x, y - yOffset);
            }
        });
    }

    private SelectionHandler<TreeItem> getSelectionHandler() {
        return new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                TreeItem item = (TreeItem)event.getSelectedItem();
                if (XmlSelection.this.handler.isSelectable(item)) {
                    XmlSelection.this.expandParents(item);
                    item.setState(true);
                    item.setSelected(true);
                    XmlSelection.this.handler.onXmlSelection(item);
                    XmlSelection.this.hide();
                }
            }
        };
    }

    public XmlTreeObject findObject(String sectionType, String xpath) {
        TreeItem item = this.findItem(sectionType, xpath);
        if (item != null) {
            XmlTreeObject obj = (XmlTreeObject)item.getUserObject();
            return obj;
        }
        return null;
    }

    public TreeItem findItem(String sectionType, String xpath) {
        return this.findItem(sectionType, xpath, this.tree);
    }

    private TreeItem findItem(String assetType, String xpath, TreeWidget tree) {
        Iterator iterator = tree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            XmlTreeObject findObj = (XmlTreeObject)item.getUserObject();
            String findSectionType = findObj.getAssetType();
            String findXPath = findObj.getXpath();
            if (findSectionType == null || !findSectionType.equals(assetType) || findXPath == null || !findXPath.equals(xpath)) continue;
            return item;
        }
        return null;
    }

    public TreeItem findItem(XmlTreeObject obj) {
        return this.findItem(obj.getAssetType(), obj.getXpath());
    }

    public void setSelectedValue(TreeItem item) {
        this.tree.setSelectedItem(item);
    }

    private void expandParents(TreeItem item) {
        if (item.getParentItem() != null) {
            TreeItem p = item.getParentItem();
            p.setState(true);
            this.expandParents(p);
        }
    }
}

