/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.model.datatype;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IUIFieldDataTypeVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

public class FloatDataType
extends UIFieldDataType {
    public static final String NAME = "float";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return NAMES != null ? NAMES.floatName() : this.getName();
    }

    @Override
    public void accept(IUIFieldDataTypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isValid(String s) {
        char[] chars = s.toCharArray();
        int i = 0;
        boolean foundDec = false;
        boolean foundDigit = false;
        int maxCharacters = 6;
        if (chars.length == 0) {
            return true;
        }
        if (chars[i] == '+' || chars[i] == '-') {
            ++maxCharacters;
            ++i;
        }
        while (i < chars.length) {
            if (chars[i] == '.') {
                if (foundDec) {
                    return false;
                }
                ++maxCharacters;
                foundDec = true;
            } else {
                if (chars[i] < '0' || chars[i] > '9') {
                    return false;
                }
                foundDigit = true;
            }
            if (i > maxCharacters) {
                return false;
            }
            ++i;
        }
        return foundDigit;
    }
}

