/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.view.datatype;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasKeyDownHandlers;
import com.google.gwt.event.dom.client.HasKeyPressHandlers;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.HasMouseMoveHandlers;
import com.google.gwt.event.dom.client.HasMouseOutHandlers;
import com.google.gwt.event.dom.client.HasMouseOverHandlers;
import com.google.gwt.event.dom.client.HasMouseUpHandlers;
import com.google.gwt.event.dom.client.HasMouseWheelHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.DataTypeWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.IValueConverter;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.ValueFormatException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;

public class TypedListBoxWidget<DataType>
extends DataTypeWidget<DataType>
implements HasName,
HasClickHandlers,
HasKeyDownHandlers,
HasKeyPressHandlers,
HasKeyUpHandlers,
HasMouseDownHandlers,
HasMouseMoveHandlers,
HasMouseOutHandlers,
HasMouseOverHandlers,
HasMouseUpHandlers,
HasMouseWheelHandlers {
    private ListBoxWidget<DataType> listBox;
    private IValueConverter<DataType> valueConverter;
    private ListBoxEventHandler eventHandler = new ListBoxEventHandler();
    private boolean hasAdditionalValue = false;
    private boolean isAdditionalValueInvalid = false;

    public TypedListBoxWidget(IValueConverter<DataType> converter) {
        this.valueConverter = converter;
        this.listBox = new ListBoxWidget(false);
        this.listBox.addChangeHandler((ChangeHandler)this.eventHandler);
        this.initWidget((Widget)this.listBox);
    }

    public String getName() {
        return this.listBox.getName();
    }

    public void setName(String name) {
        this.listBox.setName(name);
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.addDomHandler((EventHandler)handler, BlurEvent.getType());
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.addDomHandler((EventHandler)handler, FocusEvent.getType());
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.addDomHandler((EventHandler)handler, KeyDownEvent.getType());
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.addDomHandler((EventHandler)handler, KeyPressEvent.getType());
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.addDomHandler((EventHandler)handler, KeyUpEvent.getType());
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseDownEvent.getType());
    }

    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseMoveEvent.getType());
    }

    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOutEvent.getType());
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOverEvent.getType());
    }

    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseUpEvent.getType());
    }

    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseWheelEvent.getType());
    }

    public int getTabIndex() {
        return this.listBox.getTabIndex();
    }

    public void setTabIndex(int index) {
        this.listBox.setTabIndex(index);
    }

    public void setAccessKey(char key) {
        this.listBox.setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this.listBox.setFocus(focused);
    }

    public DataType getValue() {
        return (DataType)this.listBox.getSelectedItem();
    }

    public void setValue(DataType value) {
        this.setValue(value, false);
    }

    public void setValue(DataType value, boolean fireEvents) {
        Object oldValue = this.listBox.getSelectedItem();
        this.removeAdditionalValue();
        int index = this.listBox.getIndex(value);
        if (index == -1) {
            String itemName = this.valueConverter.getStringValue(value);
            this.putAdditionalValue(itemName, value, false);
            index = this.listBox.getIndex(value);
        }
        this.listBox.setSelectedIndex(index);
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, (Object)oldValue, value);
        }
        this.updateWidgetState();
    }

    private void putAdditionalValue(String name, DataType value, boolean invalid) {
        this.removeAdditionalValue();
        this.listBox.insertItem(name, value, 0);
        this.hasAdditionalValue = true;
        this.isAdditionalValueInvalid = invalid;
    }

    private void removeAdditionalValue() {
        if (this.hasAdditionalValue) {
            this.listBox.removeItemAtIndex(0);
        }
        this.hasAdditionalValue = false;
        this.isAdditionalValueInvalid = false;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<DataType> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public void addItem(String itemName, DataType item) {
        this.listBox.addItem(itemName, item);
    }

    public void insertItem(String itemName, DataType item, int index) {
        this.listBox.insertItem(itemName, item, index);
    }

    public void setItem(String itemName, DataType item, int index) {
        this.listBox.setItem(itemName, item, index);
    }

    public void removeItem(DataType item) {
        this.listBox.removeItem(item);
    }

    public void removeItemAtIndex(int index) {
        this.listBox.removeItemAtIndex(index);
    }

    public void clear() {
        this.listBox.clear();
    }

    public int getItemCount() {
        return this.listBox.getItemCount();
    }

    public String getItemText(int index) {
        return this.listBox.getItemText(index);
    }

    public void setItemText(int index, String text) {
        this.listBox.setItemText(index, text);
    }

    public DataType getItem(int index) {
        return (DataType)this.listBox.getItem(index);
    }

    public void setItem(int index, DataType value) {
        this.listBox.setItem(index, value);
    }

    public int getIndex(DataType item) {
        return this.listBox.getIndex(item);
    }

    public int getSelectedIndex() {
        return this.listBox.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.listBox.setSelectedIndex(index);
    }

    public DataType getSelectedItem() {
        return (DataType)this.listBox.getSelectedItem();
    }

    public void setSelectedItem(DataType item) {
        this.listBox.setSelectedItem(item);
    }

    public boolean isItemSelected(int index) {
        return this.listBox.isItemSelected(index);
    }

    public void setItemSelected(int index, boolean selected) {
        this.listBox.setItemSelected(index, selected);
    }

    public int getVisibleItemCount() {
        return this.listBox.getVisibleItemCount();
    }

    public void setVisibleItemCount(int visibleItems) {
        this.listBox.setVisibleItemCount(visibleItems);
    }

    public boolean isMultipleSelect() {
        return this.listBox.isMultipleSelect();
    }

    @Override
    public boolean isValidValue() {
        boolean invalid = this.hasAdditionalValue && this.isAdditionalValueInvalid;
        return !invalid || this.listBox.getSelectedIndex() != 0;
    }

    @Override
    public String getTextValue() {
        return this.valueConverter.getStringValue(this.getSelectedItem());
    }

    @Override
    public void setTextValue(String textValue) {
        try {
            DataType value = this.valueConverter.getTypedValue(textValue);
            this.setValue(value);
        }
        catch (ValueFormatException vfe) {
            this.putAdditionalValue(textValue, null, true);
            this.listBox.setSelectedIndex(0);
            this.updateWidgetState();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.listBox.isEnabled();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.listBox.setEnabled(!readOnly);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.listBox.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.listBox.isEnabled();
    }

    @Override
    protected void updateStyle() {
        if (this.isInErrorState()) {
            this.listBox.addStyleDependentName("dataTypeError");
        } else {
            this.listBox.removeStyleDependentName("dataTypeError");
        }
    }

    @Override
    public String getCurrentToolTip() {
        return this.listBox.getTitle();
    }

    @Override
    protected void setCurrentToolTip(String toolTip) {
        this.listBox.setTitle(toolTip);
    }

    private final class ListBoxEventHandler
    implements ChangeHandler {
        private ListBoxEventHandler() {
        }

        public void onChange(ChangeEvent event) {
            TypedListBoxWidget.this.updateWidgetState();
            if (TypedListBoxWidget.this.hasAdditionalValue && TypedListBoxWidget.this.getSelectedIndex() != 0) {
                TypedListBoxWidget.this.removeAdditionalValue();
            }
            ValueChangeEvent.fire((HasValueChangeHandlers)TypedListBoxWidget.this, TypedListBoxWidget.this.getSelectedItem());
        }
    }
}

