/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.specification;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IUIFieldDataTypeVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataTypeProvider;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIBooleanOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIDateOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIFloatOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIIntegerOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIStringOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UITimeOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.server.specification.IUIValueOptionProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class UIAssetFileDefinitionBuilder {
    private static final String FILE_FIELD_KEYS = "FieldDefinitionKeys";
    private static final String VALUE_SEPARATOR = ",";
    private static final String KEY_SEPARATOR = ".";
    private static final String FIELD_DATATYPE_KEY = "DataType";
    private static final String FIELD_NAME_KEY = "Name";
    private static final String FIELD_DISPLAYNAME_KEY = "DisplayName";
    private static final String FIELD_ANYVALUEALLOWED_KEY = "AnyValueAllowed";
    private static final String FIELD_DISPLAYFORMAT_KEY = "DisplayFormat";
    private static final String FIELD_OPTIONPROVIDER_KEY = "OptionProvider";
    private static final String FIELD_OPTIONKEYS_KEY = "OptionKeys";
    private static final String OPTION_KEY_PREFIX = ".OptionKey.";
    private static final String FIELD_OPTIONKEY_NAME = "Name";
    private static final String FIELD_OPTIONKEY_VALUE = "Value";
    private ResourceBundle configurationBundle;
    private ResourceBundle localizationBundle;
    private Map<String, UIFieldDataType> datatypes = new HashMap<String, UIFieldDataType>();
    private UIFieldDataType defaultDataType = new StringDataType();

    public UIAssetFileDefinitionBuilder() {
        this.configurationBundle = ResourceBundle.getBundle(this.getClass().getName());
        this.localizationBundle = ResourceBundle.getBundle(String.valueOf(this.getClass().getName()) + "Keys");
        List<UIFieldDataType> allDataTypes = new UIFieldDataTypeProvider().getAll();
        for (UIFieldDataType datatype : allDataTypes) {
            this.datatypes.put(datatype.getName(), datatype);
        }
    }

    public UIAssetFileDefinition build(TitleConf titleConf) {
        UIAssetFileDefinition definition = new UIAssetFileDefinition();
        this.buildFieldDefinitions(titleConf, definition);
        return definition;
    }

    private void buildFieldDefinitions(TitleConf titleConf, UIAssetFileDefinition definition) {
        List<String> fieldDefinitionKeys = this.getFieldDefinitionKeys(titleConf);
        for (String key : fieldDefinitionKeys) {
            UIAssetFileFieldDefinition fieldDefinition = new UIAssetFileFieldDefinition();
            fieldDefinition.setFieldDefinition(this.buildFieldDefinition(key));
            definition.addFieldDefinition(fieldDefinition);
        }
    }

    private UISimpleFieldDefinition buildFieldDefinition(String key) {
        String defaultTypeName = this.defaultDataType.getName();
        String dataTypeName = this.getFieldDefinitionProperty(key, FIELD_DATATYPE_KEY, defaultTypeName);
        UIFieldDataType dataType = this.datatypes.get(dataTypeName);
        FieldDefinitionBuilder builder = new FieldDefinitionBuilder();
        return builder.build(key, dataType);
    }

    private String getFieldDefinitionProperty(String fieldDefinitionKey, String suffix) {
        String key = String.valueOf(fieldDefinitionKey) + KEY_SEPARATOR + suffix;
        return this.configurationBundle.getString(key);
    }

    private String getFieldDefinitionProperty(String fieldDefinitionKey, String suffix, String defaultValue) {
        String value = null;
        String key = String.valueOf(fieldDefinitionKey) + KEY_SEPARATOR + suffix;
        try {
            value = this.configurationBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            value = defaultValue;
        }
        return value;
    }

    private List<String> getFieldDefinitionKeys(TitleConf titleConf) {
        String[] values;
        String specificKeyName;
        ArrayList<String> keys = new ArrayList<String>();
        String keyName = FILE_FIELD_KEYS;
        String assetType = titleConf.getName();
        if (assetType != null && assetType.length() > 0 && this.configurationBundle.containsKey(specificKeyName = String.valueOf(keyName) + KEY_SEPARATOR + assetType)) {
            keyName = specificKeyName;
        }
        String keyValue = this.configurationBundle.getString(keyName);
        String[] stringArray = values = keyValue.split(VALUE_SEPARATOR);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value != null && value.trim().length() > 0) {
                keys.add(value.trim());
            }
            ++n2;
        }
        return keys;
    }

    private String getLocalizedValue(String key) {
        String localizedValue = key;
        try {
            localizedValue = this.localizationBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return localizedValue;
    }

    private class FieldDefinitionBuilder
    implements IUIFieldDataTypeVisitor {
        private String key;
        private UISimpleFieldDefinition builtDefinition = null;

        private FieldDefinitionBuilder() {
        }

        public UISimpleFieldDefinition build(String key, UIFieldDataType dataType) {
            this.key = key;
            dataType.accept(this);
            return this.getBuiltDefinition();
        }

        private UISimpleFieldDefinition getBuiltDefinition() {
            UISimpleFieldDefinition definition = this.builtDefinition;
            this.key = null;
            this.builtDefinition = null;
            return definition;
        }

        @Override
        public void visit(BooleanDataType datatype) {
            UIBooleanFieldDefinition definition = new UIBooleanFieldDefinition();
            this.buildDefinition(definition);
            String optionProvider = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONPROVIDER_KEY, null);
            String optionKeys = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEYS_KEY, null);
            if (optionProvider != null) {
                List<UIBooleanOption> options = this.loadOptions(optionProvider, UIBooleanOption.class);
                if (options != null) {
                    for (UIBooleanOption option : options) {
                        definition.getSuggestedValues().add(option);
                    }
                }
            } else if (optionKeys != null) {
                List<String> optionKeyList = this.getOptionKeys(optionKeys);
                for (String optionKey : optionKeyList) {
                    String name = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, "Name");
                    String displayName = UIAssetFileDefinitionBuilder.this.getLocalizedValue(name);
                    String value = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEY_VALUE);
                    Boolean typedValue = new Boolean(value);
                    UIBooleanOption option = new UIBooleanOption(displayName, typedValue);
                    definition.getSuggestedValues().add(option);
                }
            }
            this.builtDefinition = definition;
        }

        @Override
        public void visit(IntegerDataType datatype) {
            UIIntegerFieldDefinition definition = new UIIntegerFieldDefinition();
            this.buildDefinition(definition);
            String optionProvider = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONPROVIDER_KEY, null);
            String optionKeys = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEYS_KEY, null);
            if (optionProvider != null) {
                List<UIIntegerOption> options = this.loadOptions(optionProvider, UIIntegerOption.class);
                if (options != null) {
                    for (UIIntegerOption option : options) {
                        definition.getSuggestedValues().add(option);
                    }
                }
            } else if (optionKeys != null) {
                List<String> optionKeyList = this.getOptionKeys(optionKeys);
                for (String optionKey : optionKeyList) {
                    String name = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, "Name");
                    String displayName = UIAssetFileDefinitionBuilder.this.getLocalizedValue(name);
                    String value = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEY_VALUE);
                    Long typedValue = new Long(value);
                    UIIntegerOption option = new UIIntegerOption(displayName, typedValue);
                    definition.getSuggestedValues().add(option);
                }
            }
            this.builtDefinition = definition;
        }

        @Override
        public void visit(FloatDataType datatype) {
            UIFloatFieldDefinition definition = new UIFloatFieldDefinition();
            this.buildDefinition(definition);
            String optionProvider = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONPROVIDER_KEY, null);
            String optionKeys = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEYS_KEY, null);
            if (optionProvider != null) {
                List<UIFloatOption> options = this.loadOptions(optionProvider, UIFloatOption.class);
                if (options != null) {
                    for (UIFloatOption option : options) {
                        definition.getSuggestedValues().add(option);
                    }
                }
            } else if (optionKeys != null) {
                List<String> optionKeyList = this.getOptionKeys(optionKeys);
                for (String optionKey : optionKeyList) {
                    String name = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, "Name");
                    String displayName = UIAssetFileDefinitionBuilder.this.getLocalizedValue(name);
                    String value = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEY_VALUE);
                    Float typedValue = new Float(value);
                    UIFloatOption option = new UIFloatOption(displayName, typedValue.toString());
                    definition.getSuggestedValues().add(option);
                }
            }
            this.builtDefinition = definition;
        }

        @Override
        public void visit(DateDataType datatype) {
            UIDateFieldDefinition definition = new UIDateFieldDefinition();
            this.buildDefinition(definition);
            String optionProvider = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONPROVIDER_KEY, null);
            String optionKeys = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEYS_KEY, null);
            if (optionProvider != null) {
                List<UIDateOption> options = this.loadOptions(optionProvider, UIDateOption.class);
                if (options != null) {
                    for (UIDateOption option : options) {
                        definition.getSuggestedValues().add(option);
                    }
                }
            } else if (optionKeys != null) {
                List<String> optionKeyList = this.getOptionKeys(optionKeys);
                for (String optionKey : optionKeyList) {
                    String name = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, "Name");
                    String displayName = UIAssetFileDefinitionBuilder.this.getLocalizedValue(name);
                    String value = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEY_VALUE);
                    try {
                        String datePattern = "yyyy-MM-dd'T'HH:mm:ss";
                        SimpleDateFormat format = new SimpleDateFormat(datePattern);
                        format.parse(value);
                        UIDateOption option = new UIDateOption(displayName, value);
                        definition.getSuggestedValues().add(option);
                    }
                    catch (ParseException pe) {
                        throw new RuntimeException("Failed to load the date option value: " + value + " for file field option: " + optionKey);
                    }
                }
            }
            String format = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_DISPLAYFORMAT_KEY, null);
            definition.setDisplayFormat(format);
            this.builtDefinition = definition;
        }

        @Override
        public void visit(TimeDataType datatype) {
            UITimeFieldDefinition definition = new UITimeFieldDefinition();
            this.buildDefinition(definition);
            String optionProvider = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONPROVIDER_KEY, null);
            String optionKeys = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEYS_KEY, null);
            if (optionProvider != null) {
                List<UITimeOption> options = this.loadOptions(optionProvider, UITimeOption.class);
                if (options != null) {
                    for (UITimeOption option : options) {
                        definition.getSuggestedValues().add(option);
                    }
                }
            } else if (optionKeys != null) {
                List<String> optionKeyList = this.getOptionKeys(optionKeys);
                for (String optionKey : optionKeyList) {
                    String name = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, "Name");
                    String displayName = UIAssetFileDefinitionBuilder.this.getLocalizedValue(name);
                    String value = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEY_VALUE);
                    try {
                        String timePattern = "HH:mm:ss";
                        SimpleDateFormat format = new SimpleDateFormat(timePattern);
                        format.parse(value);
                        UITimeOption option = new UITimeOption(displayName, value);
                        definition.getSuggestedValues().add(option);
                    }
                    catch (ParseException pe) {
                        throw new RuntimeException("Failed to load the date option value: " + value + " for file field option: " + optionKey);
                    }
                }
            }
            String format = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_DISPLAYFORMAT_KEY, null);
            definition.setDisplayFormat(format);
            this.builtDefinition = definition;
        }

        @Override
        public void visit(StringDataType datatype) {
            UIStringFieldDefinition definition = new UIStringFieldDefinition();
            this.buildDefinition(definition);
            String optionProvider = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONPROVIDER_KEY, null);
            String optionKeys = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEYS_KEY, null);
            if (optionProvider != null) {
                List<UIStringOption> options = this.loadOptions(optionProvider, UIStringOption.class);
                if (options != null) {
                    for (UIStringOption option : options) {
                        definition.getSuggestedValues().add(option);
                    }
                }
            } else if (optionKeys != null) {
                List<String> optionKeyList = this.getOptionKeys(optionKeys);
                for (String optionKey : optionKeyList) {
                    String name = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, "Name");
                    String displayName = UIAssetFileDefinitionBuilder.this.getLocalizedValue(name);
                    String value = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEY_VALUE);
                    UIStringOption option = new UIStringOption(displayName, value);
                    definition.getSuggestedValues().add(option);
                }
            }
            definition.setLongForm(false);
            this.builtDefinition = definition;
        }

        private void buildDefinition(UISimpleFieldDefinition definition) {
            String name = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, "Name");
            String displayName = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_DISPLAYNAME_KEY);
            String anyValueAllowed = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_ANYVALUEALLOWED_KEY, "true");
            definition.setName(name);
            definition.setDisplayName(UIAssetFileDefinitionBuilder.this.getLocalizedValue(displayName));
            definition.setXPath(name);
            definition.setAnyValueAllowed(Boolean.parseBoolean(anyValueAllowed));
            definition.setAttribute(false);
        }

        private <T extends UIValueOption> List<T> loadOptions(String providerClass, Class<T> optionType) {
            Object providerInstance = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = classLoader.loadClass(providerClass);
                providerInstance = clazz.newInstance();
            }
            catch (Exception e) {
                String msg = "Failed to load option provider class: " + providerClass;
                throw new RuntimeException(msg, e);
            }
            if (!(providerInstance instanceof IUIValueOptionProvider)) {
                String className = IUIValueOptionProvider.class.getName();
                String msg = "The option provider class: " + providerClass + " does not implement interface: " + className;
                throw new RuntimeException(msg);
            }
            IUIValueOptionProvider provider = providerInstance;
            return provider.getOptions();
        }

        private List<String> getOptionKeys(String keys) {
            String[] keyValues;
            ArrayList<String> optionKeys = new ArrayList<String>();
            String[] stringArray = keyValues = keys.split(UIAssetFileDefinitionBuilder.VALUE_SEPARATOR);
            int n = keyValues.length;
            int n2 = 0;
            while (n2 < n) {
                String keyValue = stringArray[n2];
                if (keyValue != null && keyValue.trim().length() > 0) {
                    String optionKey = String.valueOf(this.key) + UIAssetFileDefinitionBuilder.OPTION_KEY_PREFIX + keyValue.trim();
                    optionKeys.add(optionKey);
                }
                ++n2;
            }
            return optionKeys;
        }
    }
}

