/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;

public class GetTitleStatusMessageHandler
implements MessageHandler {
    private static final String TITLE_ID_PARAM = "titleId";
    private static final String TITLE_STATUS_PARAM = "status";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws MessageHandlerException {
        Long titleId = null;
        try {
            titleId = Util.getLongValue(message, TITLE_ID_PARAM);
        }
        catch (Exception e) {
            String value = message.getValue(TITLE_ID_PARAM);
            if (value == null) {
                value = "";
            }
            String msg = "The Title Id is not a valid number, received value: " + value;
            throw new MessageHandlerException("ERR-002", msg, e);
        }
        if (titleId == null) {
            String msg = "The Title Id is missing or blank.";
            throw new MessageHandlerException("ERR-002", msg);
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitlePersistenceService service = (ITitlePersistenceService)registry.lookup(ITitlePersistenceService.class);
        Title title = null;
        try {
            title = service.get((Serializable)titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, e);
        }
        if (title == null) {
            String msg = "Did not get a Title from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        TitleStatus status = title.getStatus();
        String statusValue = status != null ? status.toString() : "";
        response.putValue(TITLE_STATUS_PARAM, statusValue);
        return response;
    }
}

