/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.timers;

import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.ui.JobUIConstants;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class TimerHelper {
    private static String DEFAULT_TIME = "12:00 am";
    private static final Logger logger = Logger.getLogger(TimerHelper.class);

    public static String getParameter(List<RuleTypeParameter> ruleTypeParams, List<RuleParameter> params, RuleParameterDataType type) {
        for (RuleTypeParameter parameter : ruleTypeParams) {
            if (parameter.getType() != type) continue;
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i).getOrder() != parameter.getOrder()) continue;
                return params.get(i).getValue();
            }
        }
        return null;
    }

    public static Date getStartDateTime(Date date, String time) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (time == null || time.trim().length() < 0) {
            time = DEFAULT_TIME;
        }
        try {
            SimpleDateFormat sf = new SimpleDateFormat(JobUIConstants.JOB_RULE_TIME_FORMAT);
            sf.setLenient(false);
            Date dt = sf.parse(time);
            Calendar tc = Calendar.getInstance();
            tc.setTime(dt);
            c.set(11, tc.get(11));
            c.set(12, tc.get(12));
            c.set(13, 0);
            return c.getTime();
        }
        catch (ParseException e) {
            logger.error((Object)("Error while setting time in date: " + e.toString()));
            return date;
        }
    }
}

