/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.util;

public class ParameterReferenceHelper {
    public static String PROPERTY_REFERENCE_ESCAPED_PREFIX = "\\$";
    public static String GROUPNAME_DELIMETER = ".";
    public static String PROPERTY_REFERENCE_FORMAT_DELIMITER = ".";
    public static String PROPERTY_REFERENCE_PREFIX = "$";
    public static String NOTHING = "";

    public static String buildParameterReferenceProperty(String groupName, String propertyName) {
        return PROPERTY_REFERENCE_PREFIX + groupName + PROPERTY_REFERENCE_FORMAT_DELIMITER + propertyName;
    }

    public static String buildParameterReferenceProperty(String propertyName) {
        return PROPERTY_REFERENCE_PREFIX + propertyName;
    }

    public static String getPropertyName(String parameterReferenceProperty) {
        int index = parameterReferenceProperty.lastIndexOf(PROPERTY_REFERENCE_FORMAT_DELIMITER);
        if (index != -1) {
            return parameterReferenceProperty.substring(index + 1);
        }
        return "";
    }

    public static String getGroupName(String parameterReferenceProperty) {
        int index = parameterReferenceProperty.lastIndexOf(PROPERTY_REFERENCE_FORMAT_DELIMITER);
        if (index != -1) {
            String groupName = parameterReferenceProperty.substring(0, index);
            groupName = groupName.replaceAll(PROPERTY_REFERENCE_ESCAPED_PREFIX, NOTHING);
            return groupName;
        }
        return parameterReferenceProperty;
    }

    public static boolean isParameterReference(String name) {
        if (name != null) {
            return name.startsWith(PROPERTY_REFERENCE_PREFIX);
        }
        return false;
    }

    public static String getLeafGroup(String groupName) {
        int index = groupName.indexOf(GROUPNAME_DELIMETER);
        if (index != -1) {
            return groupName.substring(index + 1);
        }
        return groupName;
    }

    public static String getParentGroup(String groupName) {
        int index = groupName.indexOf(GROUPNAME_DELIMETER);
        if (index != -1) {
            return groupName.startsWith(PROPERTY_REFERENCE_PREFIX) ? groupName.substring(1, index) : groupName.substring(0, index);
        }
        return groupName;
    }

    public static String combineGroupNames(String parentGroupName, String childGroupName) {
        return parentGroupName + GROUPNAME_DELIMETER + childGroupName;
    }

    public static String removeParentGroup(String groupName) {
        int index = groupName.indexOf(GROUPNAME_DELIMETER);
        return index != -1 ? groupName.substring(index + 1) : groupName;
    }
}

