/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.marvin.udt.ValidationMessage;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.MetadataValueFieldInfo;
import com.tandbergtv.metadatamanager.search.NodeFieldInfo;
import com.tandbergtv.metadatamanager.search.SearchInfo;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.ITitleValidationService;
import com.tandbergtv.watchpoint.pmm.core.MultipleTitlesForAnAssetException;
import com.tandbergtv.watchpoint.pmm.core.NoTitleForAnAssetException;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.title.AssociatedToTitleListException;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleActions;
import com.tandbergtv.watchpoint.pmm.title.TitleServiceException;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.MenuOption;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.search.EntityName;
import com.tandbergtv.watchpoint.pmm.title.search.ITitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.search.ParamType;
import com.tandbergtv.watchpoint.pmm.title.search.SearchField;
import com.tandbergtv.watchpoint.pmm.title.search.SearchFieldNode;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchCriteriaBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.pmm.title.validation.TitleValidationCode;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RequiredFileFieldsConfig;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.classic.Session;
import org.w3c.dom.Document;

public class TitleService
implements ITitleService {
    private static final String SERVICE_NAME = "Title Service";
    private static final Logger logger = Logger.getLogger(TitleService.class);
    private static final String LOOKUP_KEY_XPATH = "/tns:Fields/tns:CustomFields/tns:CustomField[@name=LookupKey]/@value";
    private static TitleService _instance;
    private ITitlePersistenceService titlePersistenceService;
    private ITitleSearchService titleSearchService;
    private ITitleStatusService statusService;
    private static final String MISSING_REQUIRED_FILE_FIELDS = "MISSING_REQUIRED_FILE_FIELDS";
    private static String MULTIPLE_ORIGINAL_FILES;
    private static String RULES_VIOLATION;
    private static String LOOKUP_KEY_VIOLATION;

    public static synchronized TitleService getInstance() {
        if (_instance == null) {
            _instance = new TitleService();
        }
        return _instance;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titlePersistenceService = this.getService(ITitlePersistenceService.class);
        this.titleSearchService = this.getService(ITitleSearchService.class);
        this.statusService = new TitleStatusService();
    }

    public void stop() {
    }

    public Title approve(long titleID) throws PMMException {
        logger.debug((Object)("Approving title: [" + titleID + "]"));
        Title title = this.titlePersistenceService.getTitleForUpdate((Serializable)Long.valueOf(titleID));
        if (title.getStatus() != TitleStatus.READY) {
            throw new PMMException("Title status is " + title.getStatus() + " | Has to be " + TitleStatus.READY + " to be approved");
        }
        title.setStatus(TitleStatus.APPROVED);
        this.save(title);
        return title;
    }

    public Title disapprove(long titleID) throws PMMException {
        logger.debug((Object)("Disapproving title: [" + titleID + "]"));
        Title title = this.titlePersistenceService.getTitleForUpdate((Serializable)Long.valueOf(titleID));
        if (title.getStatus() != TitleStatus.APPROVED) {
            throw new PMMException("Title status is " + title.getStatus() + " | Has to be " + TitleStatus.APPROVED + " to be unapproved");
        }
        title.setStatus(TitleStatus.READY);
        this.save(title);
        return title;
    }

    public Collection<Asset> findAssetsWithFileName(String fileName, String filterXpath, String filterValue) {
        AssetSearchService service = ApplicationContextHelper.getInstance().getAssetSearchService();
        SearchInfo info = this.buildSearchInfo(fileName, filterXpath, filterValue);
        SearchCriteria criteria = service.getCriteria("asset", info, null, TitleSearchCriteriaBuilder.LATEST_REVISION);
        return service.search(criteria);
    }

    private SearchInfo buildSearchInfo(String filePath, String filterXpath, String filterValue) {
        SearchInfo info = new SearchInfo();
        info.setProperty(AssetSearchKey.FIELDS.toString());
        MetadataValueFieldInfo searchField = new MetadataValueFieldInfo(FieldName.URL.toString(), SearchOperator.EQUAL, filePath);
        ((NodeFieldInfo)info.getFields()).addNode((FieldInfo)searchField);
        if (filterValue != null && filterValue.trim().length() > 0 && filterXpath != null && filterXpath.trim().length() > 0) {
            MetadataValueFieldInfo filterField = new MetadataValueFieldInfo(filterXpath, SearchOperator.EQUAL, filterValue);
            ((NodeFieldInfo)info.getFields()).addNode((FieldInfo)filterField);
        }
        return info;
    }

    public List<Asset> findAssetsWithFileName(String fileName, Asset asset) {
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Asset descAsset : asset.getAllDescendantItems(false)) {
            Field field = descAsset.getFirstField(FieldName.URL.toString());
            if (field == null || field.getValue() == null || !field.getValue().equals(fileName)) continue;
            result.add(descAsset);
        }
        return result;
    }

    @Deprecated
    public Title getExternalTitle(String specification, String externalLocationId, Map<String, String> keys) {
        SearchCriteria criteria = this.buildSearchCriteria(specification, externalLocationId, keys);
        Collection titles = this.titleSearchService.search(criteria);
        if (titles == null || titles.size() == 0) {
            String msg = "Failed to find any Title from external source[" + externalLocationId + "] for specification: " + specification + " using keys: " + keys;
            com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage message = new com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage(TitleValidationCode.EXTERNAL_TITLE_MISSING.getCode());
            throw new TitleServiceException(message, msg);
        }
        if (titles.size() > 1) {
            String msg = "Failed to find a unique Title from external source[" + externalLocationId + "] for specification: " + specification + " using keys: " + keys + ", found " + titles.size() + " titles.";
            com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage message = new com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage(TitleValidationCode.EXTERNAL_TITLE_DUPLICATE.getCode());
            message.getProperties().add(Integer.toString(titles.size()));
            throw new TitleServiceException(message, msg);
        }
        return (Title)titles.iterator().next();
    }

    @Deprecated
    public Title importTitle(Title title) {
        this.save(title);
        this.updateProgressItems(title);
        return title;
    }

    @Deprecated
    public Title syncTitle(Title title) {
        return null;
    }

    @Deprecated
    private void syncTitle(Title source, Title target) {
    }

    @Deprecated
    private void updateProgressItems(Title title) {
        this.statusService.sendMetadataReceivedStatus(title, null, null, null);
        for (Asset sectionAsset : title.getAsset().getAllDescendantItems(false)) {
            Item sectionItem = (Item)sectionAsset;
            Field fileMetadataField = sectionItem.getFirstField(FieldName.URL.toString());
            if (fileMetadataField == null || fileMetadataField.getValue() == null || fileMetadataField.getValue().trim().length() <= 0) continue;
            this.statusService.sendAssetReceivedStatus(title, sectionItem.getType(), null, null, null);
        }
    }

    @Deprecated
    private String evaluate(Title rootTitle, MenuOption jpmo) {
        return null;
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    private SearchCriteria buildSearchCriteria(String specName, String externalSourceId, Map<String, String> metadataKeys) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.setRecordsCount(2);
        Entity entity = new Entity(EntityName.TITLE.toString(), Title.class, "t");
        criteria.addParameter((SearchParameterBase)entity);
        entity.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_SPEC.toString(), SearchType.STRING, (Object)specName));
        String titleProviderId = this.getTitleProviderId(externalSourceId);
        criteria.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_PROVIDER_ID.toString(), SearchType.STRING, (Object)titleProviderId));
        entity.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_EXTERNAL_LOCATION.toString(), SearchType.STRING, (Object)externalSourceId));
        if (metadataKeys != null) {
            for (String key : metadataKeys.keySet()) {
                String value = metadataKeys.get(key);
                Entity metadata = new Entity(key, TitleSearchKey.COMPLETE_METADATA.toString(), "m");
                metadata.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.METADATA_NAME.toString(), SearchType.STRING, (Object)key));
                metadata.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.METADATA_VALUE.toString(), SearchType.STRING, (Object)value));
                entity.addParameter((SearchParameterBase)metadata);
            }
        }
        return criteria;
    }

    private String getTitleProviderId(String externalSourceId) {
        String providerId = null;
        if (externalSourceId != null) {
            String[] values = externalSourceId.split("-");
            providerId = values.length > 0 ? values[0] : "";
        }
        return providerId;
    }

    public Title getTitle(Long titleId) {
        return this.titlePersistenceService.get((Serializable)titleId);
    }

    public Title getTitleForUpdate(Long titleId) {
        return this.titlePersistenceService.getTitleForUpdate((Serializable)titleId);
    }

    public Title getTitleByAssetId(Long rootAssetId) {
        SearchField field = new SearchField();
        field.setName("asset.id");
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(rootAssetId));
        field.setValues(values);
        field.setParamType(ParamType.VALUE);
        field.setSearchOperator(SearchOperator.EQUAL);
        field.setSearchType(SearchType.NUMERIC);
        SearchCriteria criteria = TitleSearchCriteriaBuilder.getCriteria((boolean)true, (String)"", (String)"", (SearchFieldNode)field, (int)0, (int)Integer.MAX_VALUE, null, null, null);
        Collection matchingTitles = this.titleSearchService.search(criteria);
        if (matchingTitles.size() == 0) {
            throw new NoTitleForAnAssetException("No title found with asset id: " + rootAssetId);
        }
        if (matchingTitles.size() > 1) {
            throw new MultipleTitlesForAnAssetException("Multiple titles found with asset id: " + rootAssetId);
        }
        return (Title)matchingTitles.iterator().next();
    }

    public Title getTitleForUpdateByAssetId(Long rootAssetId) {
        Title title = this.getTitleByAssetId(rootAssetId);
        title = this.titlePersistenceService.getTitleForUpdate((Serializable)title.getId());
        return title;
    }

    public Collection<Title> getTitle(Document metadata) {
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadata);
        ArrayList<Asset> matchingAssets = new ArrayList<Asset>();
        try {
            List identifiers = specHandler.getIdentifiers(metadata);
            if (identifiers != null) {
                for (IIdentifier identifier : identifiers) {
                    matchingAssets.add(identifier.getAsset());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get matching Asset for the metadata document.", e);
        }
        ArrayList<Title> titles = new ArrayList<Title>();
        for (Asset a : matchingAssets) {
            titles.add(this.getTitleByAssetId(a.getId()));
        }
        return titles;
    }

    @Transactional
    public Document getMetadata(Long titleId, String spec) throws MetadataException, SearchException, TranslationException {
        Long l = titleId;
        String string = spec;
        return (Document)TitleService.getMetadata_aroundBody1$advice(this, l, string, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("getMetadata", Long.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void saveAsDraft(Title title) {
        Title title2 = title;
        TitleService.saveAsDraft_aroundBody3$advice(this, title2, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("saveAsDraft", Title.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void save(Title title) {
        Title title2 = title;
        TitleService.save_aroundBody5$advice(this, title2, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("save", Title.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<TitleValidationMessage> validate(Title title, boolean isDraft) throws TitleValidationException {
        Title title2 = title;
        boolean bl = isDraft;
        return (List)TitleService.validate_aroundBody7$advice(this, title2, bl, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("validate", Title.class, Boolean.TYPE).getAnnotation(Transactional.class), null);
    }

    private Collection<? extends TitleValidationMessage> checkForRequiredFileFields(Title title) {
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        ArrayList<Asset> assets = new ArrayList<Asset>();
        assets.add(title.getAsset());
        List descendantAssets = title.getAsset().getAllDescendantItems(false);
        if (descendantAssets != null) {
            assets.addAll(descendantAssets);
        }
        try {
            List<String> requiredFieldXPaths = RequiredFileFieldsConfig.getInstance().getRequiredFields();
            for (Asset asset : assets) {
                logger.debug((Object)("Asset: " + asset));
                List descendantFiles = asset.getDirectDescendantFiles();
                if (descendantFiles == null) continue;
                for (File descendantFile : descendantFiles) {
                    logger.debug((Object)("File: " + descendantFile));
                    for (String requiredFieldXPath : requiredFieldXPaths) {
                        Field requiredField = descendantFile.getFirstField(requiredFieldXPath);
                        if (requiredField != null && requiredField.getValue() != null && requiredField.getValue().trim().length() != 0) continue;
                        String errorMessage = "XPath = " + requiredFieldXPath + ", Asset = " + asset.getAssetType() + ", File Id = " + descendantFile.getId() + ".";
                        validationMessages.add(new TitleValidationMessage(errorMessage, TitleValidationMessage.Type.Error, MISSING_REQUIRED_FILE_FIELDS));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return validationMessages;
    }

    private Collection<? extends TitleValidationMessage> checkForDuplicateOriginalFiles(Title title) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        assets.add(title.getAsset());
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        List descendantAssets = title.getAsset().getAllDescendantItems(false);
        if (descendantAssets != null) {
            assets.addAll(descendantAssets);
        }
        for (Asset asset : assets) {
            logger.debug((Object)("Asset: " + asset));
            boolean originalFileAlreadyExist = false;
            List descendantFiles = asset.getDirectDescendantFiles();
            if (descendantFiles == null) continue;
            for (File descendantFile : descendantFiles) {
                logger.debug((Object)("File: " + descendantFile + " | Is Original?: " + descendantFile.isOriginal()));
                if (!descendantFile.isOriginal()) continue;
                if (originalFileAlreadyExist) {
                    TitleValidationMessage validationMessage = new TitleValidationMessage("More than one file of type ORIGINAL found mapped to asset [" + asset.getAssetType() + "]", TitleValidationMessage.Type.Error, MULTIPLE_ORIGINAL_FILES);
                    validationMessages.add(validationMessage);
                    continue;
                }
                originalFileAlreadyExist = true;
            }
        }
        return validationMessages;
    }

    private boolean hasErrors(List<TitleValidationMessage> messages) {
        for (TitleValidationMessage message : messages) {
            if (message.getType() != TitleValidationMessage.Type.Error) continue;
            return true;
        }
        return false;
    }

    private List<TitleValidationMessage> validateWithServices(Title title, boolean isDraft) {
        ServiceLoader<ITitleValidationService> services = ServiceLoader.load(ITitleValidationService.class);
        ArrayList<TitleValidationMessage> messages = new ArrayList<TitleValidationMessage>();
        for (ITitleValidationService s : services) {
            messages.addAll(s.validate(title, isDraft));
        }
        return messages;
    }

    private List<TitleValidationMessage> checkForUniqueLookupKeys(Title title) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        assets.add(title.getAsset());
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        List descendantAssets = title.getAsset().getAllDescendantItems(false);
        if (descendantAssets != null) {
            assets.addAll(descendantAssets);
        }
        for (Asset asset : assets) {
            List descendantFiles = asset.getDirectDescendantFiles();
            if (descendantFiles == null) continue;
            HashSet<String> lookupKeySet = new HashSet<String>();
            for (File descendantFile : descendantFiles) {
                String lookupKey;
                Field lookupKeyField = descendantFile.getFirstField(LOOKUP_KEY_XPATH);
                if (lookupKeyField == null || (lookupKey = (String)lookupKeyField.getTypedValue()) == null || lookupKey.trim().isEmpty()) continue;
                if (lookupKeySet.contains(lookupKey)) {
                    TitleValidationMessage validationMessage = new TitleValidationMessage("File lookup keys are not unique for asset [" + asset.getAssetType() + "]", TitleValidationMessage.Type.Error, LOOKUP_KEY_VIOLATION);
                    validationMessages.add(validationMessage);
                    continue;
                }
                lookupKeySet.add(lookupKey);
            }
        }
        return validationMessages;
    }

    private List<TitleValidationMessage> validateAndSave(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        List<TitleValidationMessage> validationMessages = this.validate(title, false);
        this.save(title);
        this.statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, sourceComponentName, sourceEntityName, sourceId);
        return validationMessages;
    }

    private List<TitleValidationMessage> convertToLocalMessages(Collection<ValidationMessage> messages) {
        ArrayList<TitleValidationMessage> localValidationMessages = new ArrayList<TitleValidationMessage>();
        if (messages != null) {
            for (ValidationMessage message : messages) {
                localValidationMessages.add(new TitleValidationMessage(message.getMessage(), TitleValidationMessage.Type.valueOf((String)message.getMessageType().name()), RULES_VIOLATION));
            }
        }
        return localValidationMessages;
    }

    @Transactional
    public SaveResult create(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (SaveResult)TitleService.create_aroundBody9$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("create", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public SaveResult update(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (SaveResult)TitleService.update_aroundBody11$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("update", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public boolean delete(Long titleId, boolean disassociateFromTitleLists) throws AssociatedToTitleListException {
        Long l = titleId;
        boolean bl = disassociateFromTitleLists;
        return Conversions.booleanValue((Object)TitleService.delete_aroundBody13$advice(this, l, bl, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("delete", Long.class, Boolean.TYPE).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public Title rollback(Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) throws MetadataException, SearchException, TranslationException, InvalidRevisionException, TitleValidationException {
        Long l = titleId;
        String string = version;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (Title)TitleService.rollback_aroundBody15$advice(this, l, string, string2, string3, string4, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("rollback", Long.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private Title doRollback(Title title, String version) throws MetadataException, SearchException, TranslationException, InvalidRevisionException {
        TTVId ttvId = title.getAsset().getTTVId();
        Session session = ApplicationContextHelper.getInstance().getSessionFactory().getCurrentSession();
        session.evict((Object)ttvId);
        session.evict((Object)title.getAsset());
        ISpecHandler ttvHandler = SpecHandlerFactory.getInstance((String)"TTV");
        ttvHandler.rollBackToRevision(ttvId, version);
        ITTVDataModelHandler ttvDataModelHandler = (ITTVDataModelHandler)ttvHandler;
        Asset rolledbackAsset = ttvDataModelHandler.getAsset(ttvId);
        title.setAsset(rolledbackAsset);
        return title;
    }

    public Document previewTitle(Title title, String spec) throws TranslationException {
        ISpecHandler handler = SpecHandlerFactory.getInstance((String)spec);
        Document doc = handler.convertAssetToXMLDocument(title.getAsset());
        return doc;
    }

    @Transactional
    public Title rollbackAndSaveAsDraft(Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) throws MetadataException, SearchException, TranslationException, InvalidRevisionException, TitleValidationException {
        Long l = titleId;
        String string = version;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (Title)TitleService.rollbackAndSaveAsDraft_aroundBody17$advice(this, l, string, string2, string3, string4, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("rollbackAndSaveAsDraft", Long.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Collection<Title> getCompleteTitles(List<Long> titleIds) {
        List<Long> list = titleIds;
        return (Collection)TitleService.getCompleteTitles_aroundBody19$advice(this, list, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("getCompleteTitles", List.class).getAnnotation(Transactional.class), null);
    }

    private void initTitleAsset(Title t) {
        logger.debug((Object)("Title[ " + t.getId() + "] = " + t));
        t.getAsset().loadCompleteTree();
        for (Field f : t.getAsset().getAllDescendantAssetFields()) {
            f.setParentAsset(new AssetUtil().unWrap(f.getParentAsset()));
        }
    }

    public SaveResult updateAndNotify(Title title, List<TitleActions> actions, boolean saveAsDraftIfValidationFails, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        SaveResult saveResult = null;
        try {
            saveResult = this.update(title, sourceComponentName, sourceEntityName, sourceId);
        }
        catch (TitleValidationException e) {
            if (saveAsDraftIfValidationFails) {
                List<TitleValidationMessage> validationMessages = this.validate(title, true);
                this.saveAsDraft(title);
                this.statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, sourceComponentName, sourceEntityName, sourceId);
                saveResult = new SaveResult(title, validationMessages);
            }
            throw e;
        }
        if (actions.contains(TitleActions.TITLE_NATIONALIZED_ACTION)) {
            this.statusService.sendStatus(title, ProgressStatusHelper.NATIONALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
            RulesEngineFacade.sendNationalizedEvent(title.getId());
        }
        return saveResult;
    }

    static {
        MULTIPLE_ORIGINAL_FILES = "MULTIPLE_ORIGINAL_FILES";
        RULES_VIOLATION = "RULES_VIOLATION";
        LOOKUP_KEY_VIOLATION = "LOOKUP_KEY_VIOLATION";
    }

    private static final /* synthetic */ Document getMetadata_aroundBody0(TitleService this_, Long titleId, String spec) {
        ServiceRegistry registry;
        ISpecificationManager specManager;
        Specification specification;
        ISpecHandler specHandler;
        Document result = null;
        ITitlePersistenceService service = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
        Title t = service.get((Serializable)titleId);
        Asset groupAsset = t.getAsset();
        if (groupAsset != null && (specHandler = (specification = (specManager = (ISpecificationManager)(registry = ServiceRegistry.getDefault()).lookup(ISpecificationManager.class)).getSpecificationByName(spec)).getSpecHandler()) != null) {
            IIdentifier id = specHandler.extractId(groupAsset);
            result = specHandler.get(id);
        }
        return result;
    }

    private static final /* synthetic */ Object getMetadata_aroundBody1$advice(TitleService this_, Long titleId, String spec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.getMetadata_aroundBody0(this_, titleId, spec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Document object = TitleService.getMetadata_aroundBody0(this_, titleId, spec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void saveAsDraft_aroundBody2(TitleService this_, Title title) {
        title.setStatus(TitleStatus.DRAFT);
        this_.titlePersistenceService.save(title);
    }

    private static final /* synthetic */ Object saveAsDraft_aroundBody3$advice(TitleService this_, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            TitleService.saveAsDraft_aroundBody2(this_, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            TitleService.saveAsDraft_aroundBody2(this_, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void save_aroundBody4(TitleService this_, Title title) {
        TitleStatus oldStatus = title.getStatus();
        this_.statusService.updateTitleStatus(title);
        this_.titlePersistenceService.save(title);
        TitleStatus newStatus = title.getStatus();
        if (newStatus != oldStatus) {
            TitleStatusUpdatedEvent event = new TitleStatusUpdatedEvent((Object)this_, title, oldStatus, newStatus);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
        }
        TitleUpdatedEvent titleUpdatedEvent = new TitleUpdatedEvent((Object)this_, title);
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)titleUpdatedEvent);
    }

    private static final /* synthetic */ Object save_aroundBody5$advice(TitleService this_, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            TitleService.save_aroundBody4(this_, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            TitleService.save_aroundBody4(this_, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List validate_aroundBody6(TitleService this_, Title title, boolean isDraft) {
        List<TitleValidationMessage> messages = this_.validateWithServices(title, false);
        messages.addAll(this_.checkForRequiredFileFields(title));
        messages.addAll(this_.checkForDuplicateOriginalFiles(title));
        messages.addAll(this_.checkForUniqueLookupKeys(title));
        if (isDraft) {
            if (this_.hasErrors(messages)) {
                throw new TitleValidationException(messages);
            }
            return messages;
        }
        List<ValidationMessage> validationMessages = RulesEngineFacade.validate(title);
        messages.addAll(this_.convertToLocalMessages(validationMessages));
        if (this_.hasErrors(messages)) {
            throw new TitleValidationException(messages);
        }
        return messages;
    }

    private static final /* synthetic */ Object validate_aroundBody7$advice(TitleService this_, Title title, boolean isDraft, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.validate_aroundBody6(this_, title, isDraft);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleService.validate_aroundBody6(this_, title, isDraft);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ SaveResult create_aroundBody8(TitleService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        List<TitleValidationMessage> validationMessages = this_.validateAndSave(title, sourceComponentName, sourceEntityName, sourceId);
        this_.statusService.sendStatus(title, ProgressStatusHelper.CREATED, null, true, sourceComponentName, sourceEntityName, sourceId);
        return new SaveResult(title, validationMessages);
    }

    private static final /* synthetic */ Object create_aroundBody9$advice(TitleService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.create_aroundBody8(this_, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            SaveResult object = TitleService.create_aroundBody8(this_, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ SaveResult update_aroundBody10(TitleService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        List<TitleValidationMessage> validationMessages = this_.validateAndSave(title, sourceComponentName, sourceEntityName, sourceId);
        this_.statusService.sendStatus(title, ProgressStatusHelper.UPDATED, null, true, sourceComponentName, sourceEntityName, sourceId);
        return new SaveResult(title, validationMessages);
    }

    private static final /* synthetic */ Object update_aroundBody11$advice(TitleService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.update_aroundBody10(this_, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            SaveResult object = TitleService.update_aroundBody10(this_, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ boolean delete_aroundBody12(TitleService this_, Long titleId, boolean disassociateFromTitleLists) {
        Title t = this_.titlePersistenceService.getTitleForUpdate((Serializable)titleId);
        if (!disassociateFromTitleLists && t.getTitlelists() != null && !t.getTitlelists().isEmpty()) {
            AssociatedToTitleListException exception = new AssociatedToTitleListException();
            for (IAssetList assetList : t.getTitlelists()) {
                exception.addTitleListId(assetList.getId());
            }
            throw exception;
        }
        return this_.titlePersistenceService.delete((Serializable)titleId);
    }

    private static final /* synthetic */ Object delete_aroundBody13$advice(TitleService this_, Long titleId, boolean disassociateFromTitleLists, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleService.delete_aroundBody12(this_, titleId, disassociateFromTitleLists));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleService.delete_aroundBody12(this_, titleId, disassociateFromTitleLists));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Title rollback_aroundBody14(TitleService this_, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = this_.titlePersistenceService.getTitleForUpdate((Serializable)titleId);
        if (title.getStatus(version) == TitleStatus.DRAFT) {
            throw new RuntimeException("Cannot rollback to a DRAFT version.");
        }
        Title oldTitle = this_.titlePersistenceService.get((Serializable)titleId, version);
        List<TitleValidationMessage> titleValidationMessages = this_.validate(oldTitle, false);
        if (this_.hasErrors(titleValidationMessages)) {
            throw new TitleValidationException(titleValidationMessages);
        }
        title = this_.doRollback(title, version);
        this_.save(title);
        this_.statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, sourceComponentName, sourceEntityName, sourceId);
        this_.statusService.sendStatus(title, ProgressStatusHelper.ROLLED_BACK, null, true, sourceComponentName, sourceEntityName, sourceId);
        return title;
    }

    private static final /* synthetic */ Object rollback_aroundBody15$advice(TitleService this_, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.rollback_aroundBody14(this_, titleId, version, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Title object = TitleService.rollback_aroundBody14(this_, titleId, version, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Title rollbackAndSaveAsDraft_aroundBody16(TitleService this_, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = this_.titlePersistenceService.getTitleForUpdate((Serializable)titleId);
        List<TitleValidationMessage> titleValidationMessages = this_.validate(title, true);
        if (this_.hasErrors(titleValidationMessages)) {
            throw new TitleValidationException(titleValidationMessages);
        }
        title = this_.doRollback(title, version);
        this_.saveAsDraft(title);
        this_.statusService.sendStatus(title, ProgressStatusHelper.ROLLED_BACK, null, true, sourceComponentName, sourceEntityName, sourceId);
        return title;
    }

    private static final /* synthetic */ Object rollbackAndSaveAsDraft_aroundBody17$advice(TitleService this_, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.rollbackAndSaveAsDraft_aroundBody16(this_, titleId, version, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Title object = TitleService.rollbackAndSaveAsDraft_aroundBody16(this_, titleId, version, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Collection getCompleteTitles_aroundBody18(TitleService this_, List titleIds) {
        ArrayList<String> ids = new ArrayList<String>();
        Iterator i$ = titleIds.iterator();
        while (i$.hasNext()) {
            long id = (Long)i$.next();
            ids.add(String.valueOf(id));
        }
        SearchField titleIdsField = new SearchField();
        titleIdsField.setName("id");
        titleIdsField.setParamType(ParamType.LIST);
        titleIdsField.setValues(ids);
        titleIdsField.setSearchType(SearchType.NUMERIC);
        titleIdsField.setSearchOperator(SearchOperator.IN);
        SearchCriteria criteria = TitleSearchCriteriaBuilder.getCriteria((boolean)true, (String)"", (String)"", (SearchFieldNode)titleIdsField, (int)0, (int)Integer.MAX_VALUE, null, null, null);
        ITitleSearchService titleSearchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        Collection titles = titleSearchService.search(criteria);
        for (Title t : titles) {
            this_.initTitleAsset(t);
        }
        return titles;
    }

    private static final /* synthetic */ Object getCompleteTitles_aroundBody19$advice(TitleService this_, List titleIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.getCompleteTitles_aroundBody18(this_, titleIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = TitleService.getCompleteTitles_aroundBody18(this_, titleIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

