/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.jaxb;

import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.jaxb.model.AssetType;
import com.tandbergtv.content.contentclass.jaxb.model.FieldType;
import com.tandbergtv.content.contentclass.jaxb.model.Metadata;
import com.tandbergtv.content.contentclass.jaxb.model.OptionsType;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class ContentClassJaxbService {
    private final String JAXB_CONTEXT_PATH = "com.tandbergtv.content.contentclass.jaxb.model";
    private static Logger logger = Logger.getLogger(ContentClassJaxbService.class);

    public void marshalContentClassMetadata(ContentClassMetadata metadata, Writer writer) throws ContentClassPersistenceException {
        this.marshalContentClassMetadata(metadata, writer, false);
    }

    public void marshalContentClassMetadata(ContentClassMetadata ccMetadata, Writer writer, boolean formatOutput) throws ContentClassPersistenceException {
        try {
            Metadata metadata = this.createMetadata(ccMetadata);
            JAXBContext jc = JAXBContext.newInstance((String)"com.tandbergtv.content.contentclass.jaxb.model");
            Marshaller mar = jc.createMarshaller();
            if (formatOutput) {
                mar.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            mar.marshal((Object)metadata, writer);
        }
        catch (Exception ex) {
            String msg = "Unable to marshal content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    public String marshalContentClassMetadata(ContentClassMetadata ccMetadata, boolean formatOutput) throws ContentClassPersistenceException {
        if (ccMetadata == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        this.marshalContentClassMetadata(ccMetadata, writer, formatOutput);
        return writer.toString();
    }

    public String marshalContentClassMetadata(ContentClassMetadata ccMetadata) throws ContentClassPersistenceException {
        return this.marshalContentClassMetadata(ccMetadata, false);
    }

    public ContentClassMetadata unmarshalContentClassMetadata(Reader reader) throws ContentClassPersistenceException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.tandbergtv.content.contentclass.jaxb.model");
            Unmarshaller umar = jc.createUnmarshaller();
            Metadata metadata = (Metadata)umar.unmarshal(reader);
            return this.createContentClassMetadata(metadata);
        }
        catch (Exception ex) {
            String msg = "Unable to unmarshal content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    public ContentClassMetadata unmarshalContentClassMetadata(String xml) throws ContentClassPersistenceException {
        if (xml == null) {
            return null;
        }
        StringReader reader = new StringReader(xml);
        return this.unmarshalContentClassMetadata(reader);
    }

    private Metadata createMetadata(ContentClassMetadata ccMetadata) {
        if (ccMetadata == null || ccMetadata.isEmpty()) {
            return null;
        }
        Metadata metadata = new Metadata();
        List<AssetType> assetTypes = metadata.getAsset();
        for (ContentClassAsset asset : ccMetadata.getAssetList()) {
            AssetType assetType;
            if (asset.isEmpty() || (assetType = this.createAssetType(asset)) == null) continue;
            assetTypes.add(assetType);
        }
        return metadata;
    }

    private AssetType createAssetType(ContentClassAsset asset) {
        AssetType at = new AssetType();
        at.setPath(asset.getPath());
        List<FieldType> fieldTypes = at.getField();
        Collection fields = asset.getFieldList();
        if (fields != null) {
            for (ContentClassField field : fields) {
                FieldType fieldType = this.createFieldType(field);
                if (fieldType == null) continue;
                fieldTypes.add(fieldType);
            }
        }
        return at;
    }

    private FieldType createFieldType(ContentClassField field) {
        FieldType ft = new FieldType();
        ft.setValue(field.getDefaultValue());
        ft.setIsLocked(field.isLocked() ? Boolean.valueOf(true) : null);
        ft.setIsAttribute(field.isAttribute() ? Boolean.valueOf(true) : null);
        ft.setPath(field.getPath());
        if (field.getOptionKeys() != null) {
            OptionsType ot = new OptionsType();
            ot.getKey().addAll(field.getOptionKeys());
            ft.setOptions(ot);
        }
        return ft;
    }

    private ContentClassMetadata createContentClassMetadata(Metadata metadata) {
        ContentClassMetadata assets = new ContentClassMetadata();
        List<AssetType> assetTypes = metadata.getAsset();
        if (assetTypes != null) {
            for (AssetType assetType : assetTypes) {
                ContentClassAsset asset = this.createContentClassAsset(assetType);
                if (asset == null) continue;
                assets.addAsset(asset);
            }
        }
        return assets;
    }

    private ContentClassAsset createContentClassAsset(AssetType assetType) {
        if (assetType == null) {
            return null;
        }
        ContentClassAsset asset = new ContentClassAsset(assetType.getPath());
        List<FieldType> fieldTypes = assetType.getField();
        if (fieldTypes != null) {
            for (FieldType fieldType : fieldTypes) {
                ContentClassField field = this.createContentClassField(fieldType);
                if (field == null) continue;
                asset.addField(field);
            }
        }
        return asset;
    }

    private ContentClassField createContentClassField(FieldType fieldType) {
        if (fieldType == null) {
            return null;
        }
        ContentClassField field = new ContentClassField(fieldType.getPath());
        field.setDefaultValue(fieldType.getValue());
        field.setLocked(fieldType.isIsLocked() == null ? false : fieldType.isIsLocked());
        field.setAttribute(fieldType.isIsAttribute() == null ? false : fieldType.isIsAttribute());
        if (fieldType.getOptions() != null) {
            field.addOptionKeys(fieldType.getOptions().getKey());
        }
        return field;
    }
}

