/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.util;

import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import java.util.Collection;

public class ContentClassMerger {
    public ContentClassMetadata mergeMetadata(ContentClassMetadata contentClassMetadata, ContentClassMetadata partnerMetadata) {
        Collection ccAssets;
        Collection pAssets;
        ContentClassMetadata newMetadata = new ContentClassMetadata();
        if (partnerMetadata != null && (pAssets = partnerMetadata.getAssetList()) != null) {
            for (ContentClassAsset pAsset : pAssets) {
                ContentClassAsset ccAsset;
                ContentClassAsset contentClassAsset = ccAsset = contentClassMetadata == null ? null : contentClassMetadata.getAsset(pAsset.getPath());
                if (ccAsset != null) {
                    ContentClassAsset mergedAsset = this.mergeAssets(ccAsset, pAsset);
                    newMetadata.addAsset(mergedAsset);
                    continue;
                }
                newMetadata.addAsset(pAsset);
            }
        }
        if (contentClassMetadata != null && (ccAssets = contentClassMetadata.getAssetList()) != null) {
            for (ContentClassAsset ccAsset : ccAssets) {
                ContentClassAsset pAsset = partnerMetadata == null ? null : partnerMetadata.getAsset(ccAsset.getPath());
                if (pAsset != null) continue;
                newMetadata.addAsset(ccAsset);
            }
        }
        return newMetadata;
    }

    private ContentClassAsset mergeAssets(ContentClassAsset contentClassAsset, ContentClassAsset partnerAsset) {
        Collection ccFields;
        if (contentClassAsset == null && partnerAsset == null) {
            return null;
        }
        if (contentClassAsset == null && partnerAsset != null) {
            return partnerAsset;
        }
        if (contentClassAsset != null && partnerAsset == null) {
            return contentClassAsset;
        }
        ContentClassAsset newAsset = new ContentClassAsset(contentClassAsset.getPath());
        Collection pFields = partnerAsset.getFieldList();
        if (pFields != null) {
            for (ContentClassField pField : pFields) {
                ContentClassField ccField = contentClassAsset.getField(pField.getPath());
                if (ccField != null) {
                    ContentClassField mergedField = this.mergeFields(ccField, pField);
                    newAsset.addField(mergedField);
                    continue;
                }
                newAsset.addField(pField);
            }
        }
        if ((ccFields = contentClassAsset.getFieldList()) != null) {
            for (ContentClassField ccField : ccFields) {
                ContentClassField pField = partnerAsset.getField(ccField.getPath());
                if (pField != null) continue;
                newAsset.addField(ccField);
            }
        }
        return newAsset;
    }

    private ContentClassField mergeFields(ContentClassField contentClassField, ContentClassField partnerField) {
        if (contentClassField == null && partnerField == null) {
            return null;
        }
        if (contentClassField == null && partnerField != null) {
            return partnerField;
        }
        if (contentClassField != null && partnerField == null) {
            return contentClassField;
        }
        ContentClassField newField = new ContentClassField(contentClassField.getPath());
        String defaultValue = partnerField.getDefaultValue() == null ? contentClassField.getDefaultValue() : partnerField.getDefaultValue();
        newField.setDefaultValue(defaultValue);
        boolean isLocked = contentClassField.isLocked() ? true : partnerField.isLocked();
        newField.setLocked(isLocked);
        newField.addOptionKeys((Collection)contentClassField.getOptionKeys());
        newField.addOptionKeys((Collection)partnerField.getOptionKeys());
        return newField;
    }
}

