/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.util;

import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContentClassTitleBuilder {
    public static final String PATH_PROVIDER_NAME = "/ProviderInfo/Name";
    public static final String PATH_PROVIDER_ID = "/ProviderInfo/Identifier/Id";
    private ContentClassMetadata metadata;
    private List<ContentClassField> commonFields;

    public void applyMetadata(Title title, ContentClassPartner ccp) {
        if (title == null || ccp == null) {
            return;
        }
        this.metadata = ccp.getMetadata();
        this.commonFields = new ArrayList<ContentClassField>(2);
        ContentClassField ccField = new ContentClassField(PATH_PROVIDER_ID);
        ccField.setDefaultValue(ccp.getProviderId());
        ccField.setLocked(true);
        this.commonFields.add(ccField);
        ccField = new ContentClassField(PATH_PROVIDER_NAME);
        ccField.setDefaultValue(ccp.getPartnerName());
        ccField.setLocked(true);
        this.commonFields.add(ccField);
        Asset rootAsset = title.getAsset();
        if (rootAsset == null) {
            return;
        }
        this.walkAssetTree(rootAsset, null);
        this.metadata = null;
    }

    private void walkAssetTree(Asset asset, String parentPath) {
        String path = parentPath == null ? asset.getAssetType() : parentPath + "/" + asset.getAssetType();
        ContentClassAsset ccAsset = this.metadata.getAsset(path);
        this.processAsset(asset, ccAsset);
        for (Relation r : asset.getRelations()) {
            this.walkAssetTree(r.getTargetAsset(), path);
        }
    }

    private void processAsset(Asset asset, ContentClassAsset ccAsset) {
        Collection col;
        if (asset == null) {
            return;
        }
        ArrayList<ContentClassField> ccFields = new ArrayList<ContentClassField>();
        ccFields.addAll(this.commonFields);
        if (ccAsset != null && (col = ccAsset.getFieldList()) != null) {
            ccFields.addAll(col);
        }
        if (!ccFields.isEmpty()) {
            FieldTree fieldTree = asset.getFieldTree();
            for (ContentClassField ccField : ccFields) {
                this.processField(fieldTree, ccField);
            }
            asset.setFieldTree(fieldTree);
        }
    }

    private void processField(FieldTree fieldTree, ContentClassField ccField) {
        String[] pathParts = ccField.getPath().split("/");
        List<FieldTreeNode> nodes = this.getTreeNodes(fieldTree, pathParts);
        this.setValue(nodes, ccField);
    }

    private List<FieldTreeNode> getTreeNodes(FieldTree tree, String[] paths) {
        ArrayList<FieldTreeNode> nodes = new ArrayList<FieldTreeNode>(1);
        nodes.add(tree.getRootElement());
        for (int i = 1; i < paths.length; ++i) {
            String path = paths[i];
            ArrayList<FieldTreeNode> newNodes = new ArrayList<FieldTreeNode>(1);
            for (FieldTreeNode node : nodes) {
                List allChildNodes = node.getChildren();
                List<FieldTreeNode> childNodes = this.getNodesByName(allChildNodes, path);
                if (childNodes == null || childNodes.isEmpty()) {
                    FieldTreeNode childNode = new FieldTreeNode();
                    childNode.setName(path);
                    node.addChild(childNode);
                    newNodes.add(childNode);
                    continue;
                }
                newNodes.addAll(childNodes);
            }
            nodes = newNodes;
        }
        return nodes;
    }

    private List<FieldTreeNode> getNodesByName(List<FieldTreeNode> nodes, String name) {
        if (nodes == null) {
            return null;
        }
        ArrayList<FieldTreeNode> newNodes = new ArrayList<FieldTreeNode>(1);
        for (FieldTreeNode node : nodes) {
            if (!node.getName().equals(name)) continue;
            newNodes.add(node);
        }
        return newNodes;
    }

    private void setValue(List<FieldTreeNode> nodes, ContentClassField ccField) {
        for (FieldTreeNode node : nodes) {
            this.setValue(node, ccField);
        }
    }

    private void setValue(FieldTreeNode node, ContentClassField ccField) {
        Field field = node.getField();
        if (field == null) {
            field = new Field();
            node.setField(field);
        }
        if (field.getValue() == null) {
            field.setValue(ccField.getDefaultValue());
            node.setAttribute(ccField.isAttribute());
        } else if (ccField.isLocked()) {
            field.setValue(ccField.getDefaultValue());
        }
        if (field.getValue() == null || field.getValue().length() < 1) {
            node.setField(null);
        }
    }
}

