/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.contentmgmt.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class GenerateMetadataMessageHandler
implements MessageHandler {
    private static final String RESULT = "result";
    private static final String SUCCESS = "SUCCESS";
    private static final String OUTPUT_METADATA_FILE_PATH = "outputMetadataFilePath";
    private static final String SPEC = "spec";
    private static final String TITLE_ID = "titleId";

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)GenerateMetadataMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), GenerateMetadataMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private ISpecHandler getSpecificationByAlias(String alias) {
        return SpecHandlerFactory.getInstance((String)alias);
    }

    private void saveXMLDocument(Document document, File xmlFile) throws MessageHandlerException {
        OutputStream outputStream = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            String xmlEncoding = document.getXmlEncoding();
            if (xmlEncoding != null) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            outputStream = new FileOutputStream(xmlFile);
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (Exception e) {
            String message = "Failed to write XML document to file: " + xmlFile;
            throw new MessageHandlerException("ERR-001", message, e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception ex) {
                    String message = "Failed to close the output stream for the file: " + xmlFile;
                    throw new MessageHandlerException("ERR-001", message, ex);
                }
            }
        }
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(GenerateMetadataMessageHandler this_, WorkflowMessage message) {
        Util.validateRequired(message, TITLE_ID, SPEC, OUTPUT_METADATA_FILE_PATH);
        Long titleId = Util.getLongValue(message, TITLE_ID);
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitleManager service = (ITitleManager)registry.lookup(ITitleManager.class);
        Title title = null;
        try {
            title = service.get(titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, e);
        }
        if (title == null) {
            String msg = "Did not get a Title from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        String spec = Util.getStringValueTrimmed(message, SPEC);
        ISpecHandler specHandler = this_.getSpecificationByAlias(spec);
        if (specHandler == null) {
            String msg = "Could not find specification with matching alias: " + spec;
            throw new MessageHandlerException("ERR-003", msg);
        }
        if (title.getStatus().equals((Object)TitleStatus.DRAFT)) {
            try {
                int revision = title.getAsset().getLatestRevisionNumber() - 1;
                if (revision <= 0) {
                    String msg = "Title metadata has yet to be committed.";
                    throw new MessageHandlerException("ERR-003", msg);
                }
                title = service.get(titleId, Integer.toString(revision));
            }
            catch (TitlePersistenceException tpe) {
                String msg = "Title metadata has yet to be committed.";
                throw new MessageHandlerException("ERR-003", msg);
            }
        }
        Document doc = specHandler.convertAssetToXMLDocument(title.getAsset());
        String outputMetadataFilePath = Util.getStringValueTrimmed(message, OUTPUT_METADATA_FILE_PATH);
        File outputFile = new File(outputMetadataFilePath);
        this_.saveXMLDocument(doc, outputFile);
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(RESULT, SUCCESS);
        return response;
    }

    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(GenerateMetadataMessageHandler this_, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return GenerateMetadataMessageHandler.handleMessage_aroundBody0(this_, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = GenerateMetadataMessageHandler.handleMessage_aroundBody0(this_, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

