/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.contentmgmt.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.NationalizeTitleInfo;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class NationalizeTitleMessageHandler
implements MessageHandler {
    private static final String TITLE_ID = "titleId";
    private static final String SOURCE_COMPONENT_NAME = "sourceComponentName";
    private static final String SOURCE_ENTITY_NAME = "sourceEntityName";
    private static final String SOURCEID = "sourceId";
    private static final int MAX_LENGTH = 1021;

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws PMMException, TitleValidationException {
        Util.validateRequired(message, TITLE_ID);
        IPMMService pmmService = (IPMMService)ServiceRegistry.getDefault().lookup(IPMMService.class);
        NationalizeTitleInfo info = pmmService.nationalizeAndSave(Util.getLongValue(message, TITLE_ID), "INGESTED", Util.getStringValueTrimmed(message, SOURCE_COMPONENT_NAME), Util.getStringValueTrimmed(message, SOURCE_ENTITY_NAME), Util.getStringValueTrimmed(message, SOURCEID));
        WorkflowMessage resultMessage = new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
        if (!info.isSuccessfulNationalization()) {
            resultMessage.putValue("result", "false");
            resultMessage.putValue("errorMessage", this.trim(info.getErrorMessage()));
        } else {
            resultMessage.putValue("result", "true");
        }
        return resultMessage;
    }

    private String trim(String errorMessage) {
        if (errorMessage != null && errorMessage.length() > 1021) {
            errorMessage = errorMessage.substring(0, 1020) + "...";
        }
        return errorMessage;
    }
}

