/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.contentmgmt.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.AssetSearchField;
import com.tandbergtv.cms.title.search.entities.ParamType;
import com.tandbergtv.cms.title.search.entities.SearchFieldNode;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class SearchTitleMessageHandler
implements MessageHandler {
    private static String FIELD_1_XPATH = "field1Xpath";
    private static String FIELD_1_ASSET_TYPE = "field1AssetType";
    private static String FIELD_1_VALUE = "field1Value";
    private static String FIELD_2_XPATH = "field2Xpath";
    private static String FIELD_2_ASSET_TYPE = "field2AssetType";
    private static String FIELD_2_VALUE = "field2Value";
    private static String FIELD_3_XPATH = "field3Xpath";
    private static String FIELD_3_ASSET_TYPE = "field3AssetType";
    private static String FIELD_3_VALUE = "field3Value";
    private static String FIELD_4_XPATH = "field4Xpath";
    private static String FIELD_4_ASSET_TYPE = "field4AssetType";
    private static String FIELD_4_VALUE = "field4Value";
    private static String FIELD_5_XPATH = "field5Xpath";
    private static String FIELD_5_ASSET_TYPE = "field5AssetType";
    private static String FIELD_5_VALUE = "field5Value";
    private static String MATCHING_TITLE_IDS = "titleIds";
    private static String MATCHING_TITLE_IDS_COUNT = "matchingTitleCount";

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)SearchTitleMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), SearchTitleMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private WorkflowMessage buildResponse(WorkflowMessage message, List<Long> titleIds) {
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        StringBuffer sb = new StringBuffer();
        int matchingTitleCount = 0;
        for (long id : titleIds) {
            ++matchingTitleCount;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id);
        }
        response.putValue(MATCHING_TITLE_IDS, sb.toString());
        response.putValue(MATCHING_TITLE_IDS_COUNT, String.valueOf(matchingTitleCount));
        return response;
    }

    private List<SearchFieldNode> buildSearchFields(WorkflowMessage message) {
        String field5Value;
        String field5AssetType;
        String field5Xpath;
        AssetSearchField field5;
        String field4Value;
        String field4AssetType;
        String field4Xpath;
        AssetSearchField field4;
        String field3Value;
        String field3AssetType;
        String field3Xpath;
        AssetSearchField field3;
        ArrayList<SearchFieldNode> searchFields = new ArrayList<SearchFieldNode>();
        String field1Xpath = message.getValue(FIELD_1_XPATH);
        String field1AssetType = message.getValue(FIELD_1_ASSET_TYPE);
        String field1Value = message.getValue(FIELD_1_VALUE);
        AssetSearchField field1 = this.getSearchField(field1Xpath, field1AssetType, field1Value);
        searchFields.add((SearchFieldNode)field1);
        String field2Xpath = message.getValue(FIELD_2_XPATH);
        String field2AssetType = message.getValue(FIELD_2_ASSET_TYPE);
        String field2Value = message.getValue(FIELD_2_VALUE);
        AssetSearchField field2 = this.getSearchField(field2Xpath, field2AssetType, field2Value);
        if (field2 != null) {
            searchFields.add((SearchFieldNode)field2);
        }
        if ((field3 = this.getSearchField(field3Xpath = message.getValue(FIELD_3_XPATH), field3AssetType = message.getValue(FIELD_3_ASSET_TYPE), field3Value = message.getValue(FIELD_3_VALUE))) != null) {
            searchFields.add((SearchFieldNode)field3);
        }
        if ((field4 = this.getSearchField(field4Xpath = message.getValue(FIELD_4_XPATH), field4AssetType = message.getValue(FIELD_4_ASSET_TYPE), field4Value = message.getValue(FIELD_4_VALUE))) != null) {
            searchFields.add((SearchFieldNode)field4);
        }
        if ((field5 = this.getSearchField(field5Xpath = message.getValue(FIELD_5_XPATH), field5AssetType = message.getValue(FIELD_5_ASSET_TYPE), field5Value = message.getValue(FIELD_5_VALUE))) != null) {
            searchFields.add((SearchFieldNode)field5);
        }
        return searchFields;
    }

    private AssetSearchField getSearchField(String fieldXpath, String fieldAssetType, String value) {
        if (fieldXpath == null || fieldXpath.trim().isEmpty()) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        return new AssetSearchField(fieldXpath, values, this.getSearchType(fieldXpath), LogicalOperator.EQUAL, ParamType.VALUE, true, fieldAssetType, true);
    }

    private SearchType getSearchType(String ttvXpath) {
        String dataType = DataTypeMappingReader.getInstance().determineDataType(ttvXpath);
        if ("boolean".equals(dataType) || "float".equals(dataType) || "integer".equals(dataType)) {
            return SearchType.NUMERIC;
        }
        if ("date".equals(dataType) || "time".equals(dataType)) {
            return SearchType.DATE;
        }
        if ("string".equals(dataType)) {
            return SearchType.STRING;
        }
        return SearchType.STRING;
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(SearchTitleMessageHandler this_, WorkflowMessage message) {
        try {
            Util.validateRequired(message, FIELD_1_XPATH, FIELD_1_ASSET_TYPE, FIELD_1_VALUE);
        }
        catch (Exception e) {
            throw new RuntimeException("At least 1 search field must be provided.");
        }
        List<SearchFieldNode> searchFields = this_.buildSearchFields(message);
        ITitleSearchService service = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        ArrayList<Long> titleIds = new ArrayList();
        try {
            titleIds = service.getTitleIds(searchFields);
        }
        catch (Exception e) {
            String msg = "Failed to search for titles: " + e.getMessage();
            throw new MessageHandlerException("ERR-001", msg, e);
        }
        return this_.buildResponse(message, titleIds);
    }

    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(SearchTitleMessageHandler this_, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SearchTitleMessageHandler.handleMessage_aroundBody0(this_, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = SearchTitleMessageHandler.handleMessage_aroundBody0(this_, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

