/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.contentmgmt.communication.handlers;

import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.spec.IValidator;
import com.tandbergtv.metadatamanager.validation.ValidationError;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class ValidateMetadataMessageHandler
implements MessageHandler {
    private static String METADATA_FILE_PATH = "filepath";
    private static String VALIDATION_FAILED = "Failed to validate the given metadata: ";
    private static String NO_VALIDATOR_FOR_SPEC = "No validator for spec defined.";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, METADATA_FILE_PATH);
        String metadataFilePath = Util.getStringValueTrimmed(message, METADATA_FILE_PATH);
        Document metadataDOM = this.createDocument(metadataFilePath);
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadataDOM);
        IValidator validator = (IValidator)specHandler.getRuleValidators().values().iterator().next();
        if (validator == null) {
            throw new MessageHandlerException("ERR-001", NO_VALIDATOR_FOR_SPEC);
        }
        List errors = validator.validate(metadataDOM);
        if (!errors.isEmpty()) {
            throw new MessageHandlerException("ERR-001", VALIDATION_FAILED + this.getErrorMsg(errors));
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        return response;
    }

    private String getErrorMsg(List<ValidationError> errors) {
        StringBuilder sb = new StringBuilder();
        for (ValidationError error : errors) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(error.toString());
        }
        return sb.toString();
    }

    private Document createDocument(String filePath) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            document = docBuilder.parse(new File(filePath));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse the metadata file: " + filePath, e);
        }
        return document;
    }
}

