/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.contentmgmt.communication.handlers;

import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.spec.IValidator;
import com.tandbergtv.metadatamanager.validation.ValidationError;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;

public class ValidateTitleMessageHandler
implements MessageHandler {
    private static String SPEC_NAME = "spec";
    private static String TITLE_ID = "titleId";
    private static String NO_VALIDATOR_FOR_SPEC = "No validator for spec defined.";
    private static String NO_TITLE_FOUND = "No title found with given id.";
    private static String SPEC_HANDLER_NOT_FOUND = "No handler found for the given spec.";
    private static String VALIDATION_FAILED = "Failed to validate the given metadata: ";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, TITLE_ID, SPEC_NAME);
        String spec = Util.getStringValueTrimmed(message, SPEC_NAME);
        long titleId = Util.getLongValue(message, TITLE_ID);
        ITitleManager titleService = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
        Title t = titleService.get(Long.valueOf(titleId));
        if (t == null) {
            throw new MessageHandlerException("ERR-001", NO_TITLE_FOUND);
        }
        ApplicationContext springContext = ApplicationContextHelper.getInstance().getContext();
        ITTVDataModelHandler ttvSpecHandler = (ITTVDataModelHandler)springContext.getBean("TTVSpecHandler");
        long assetId = t.getAsset().getId();
        Asset asset = ttvSpecHandler.getAsset(Long.valueOf(assetId));
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)spec);
        if (specHandler == null) {
            throw new MessageHandlerException("ERR-001", SPEC_HANDLER_NOT_FOUND);
        }
        Document metadataDocument = specHandler.convertAssetToXMLDocument(asset);
        IValidator validator = (IValidator)specHandler.getRuleValidators().values().iterator().next();
        if (validator == null) {
            throw new MessageHandlerException("ERR-001", NO_VALIDATOR_FOR_SPEC);
        }
        List errors = validator.validate(metadataDocument);
        if (!errors.isEmpty()) {
            throw new MessageHandlerException("ERR-001", VALIDATION_FAILED + this.getErrorMsg(errors));
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        return new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
    }

    private String getErrorMsg(List<ValidationError> errors) {
        StringBuilder sb = new StringBuilder();
        for (ValidationError error : errors) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(error.toString());
        }
        return sb.toString();
    }
}

