/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.AssetSearchField;
import com.tandbergtv.cms.title.search.entities.ParamType;
import com.tandbergtv.cms.title.search.entities.TitleSearchField;
import com.tandbergtv.cms.title.search.entities.TitleSearchKey;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.FatalTitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.IPMMUIService;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.PMMUtil;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.core.WorkflowNotifier;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.NormalizationContextEvent;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class PMMUIService
implements IPMMUIService {
    private static final String UNMAPPED_ASSETS = "unmappedAssets";
    private static final Logger logger = Logger.getLogger(PMMUIService.class);
    private ITitleManager titleManager;
    private ITitleStatusService statusService;
    private ITitleSearchService titleSearchService;
    private static final String ACTION_MAP_ASSET = "MAP_ASSET";

    public String getServiceName() {
        return "PMM UI Service";
    }

    public void start() {
        this.titleManager = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
        this.titleSearchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        this.statusService = new TitleStatusService();
    }

    public void stop() {
    }

    @Transactional
    public SaveResult createTitle(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (SaveResult)PMMUIService.createTitle_aroundBody1$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), PMMUIService.class.getDeclaredMethod("createTitle", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private SaveResult updateTitle(Title title, boolean draft, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Asset assetForSave = title.getAsset();
        title = this.titleManager.get(title.getId());
        Asset existingAsset = title.getAsset();
        title.setAsset(assetForSave);
        if (!draft) {
            title = this.nationalizeTitle(title, NormalizationContextEvent.UIUPDATED);
        }
        List validationMessages = null;
        try {
            validationMessages = this.titleManager.validate(title, draft);
        }
        catch (TitleValidationException e) {
            if (!draft) {
                String code = "PMMUI-001";
                String message = "Title made invalid after applying nationalization rules.";
                throw new FatalTitleValidationException(code, message, e.getMessages());
            }
            throw e;
        }
        Map<String, List<com.tandbergtv.metadatamanager.model.File>> filePathMap = this.getFilePathMap(title);
        this.validateFilePaths(title, filePathMap);
        this.unmapFiles(title, existingAsset, filePathMap);
        Map<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap = this.getNewlyAddedFiles(title.getAsset(), existingAsset);
        this.moveFilesToMappedFilesDir(title);
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = this.titleManager.update(title, draft, (ITitleActionSource)source);
        title = savedTitle.getTitle();
        if (!draft) {
            this.statusService.sendStatus(title, ProgressStatusHelper.NORMALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
        }
        this.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, title, sourceComponentName, sourceEntityName, sourceId);
        if (!draft) {
            RulesEngineFacade.sendUIUpdatedEvent(title.getId());
        }
        return new SaveResult(title, validationMessages);
    }

    @Transactional
    public SaveResult updateTitleMetadata(Title title, Long requestKey, String action, String listOfAssetIds, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        Long l = requestKey;
        String string = action;
        String string2 = listOfAssetIds;
        String string3 = sourceComponentName;
        String string4 = sourceEntityName;
        String string5 = sourceId;
        return (SaveResult)PMMUIService.updateTitleMetadata_aroundBody3$advice(this, title2, l, string, string2, string3, string4, string5, TransactionEnforcer.aspectOf(), PMMUIService.class.getDeclaredMethod("updateTitleMetadata", Title.class, Long.class, String.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private Title nationalizeTitle(Title title, NormalizationContextEvent eventType) throws TitleValidationException {
        this.titleManager.validate(title, false);
        return this.titleManager.normalize(title, eventType.getName());
    }

    private void validateFilePaths(Title title, Map<String, List<com.tandbergtv.metadatamanager.model.File>> filePathMap) throws TitleValidationException {
        if (title.isCopy()) {
            int fileCount = 0;
            for (String filePath : filePathMap.keySet()) {
                if (!AssetsManager.getThreadLocalInstance().isUnmappedFile(filePath)) continue;
                ++fileCount;
            }
            if (fileCount > 0) {
                ArrayList<TitleValidationMessage> messages = new ArrayList<TitleValidationMessage>();
                String msg = "The copied title contains " + fileCount + " file(s) with URLs that refers to the unmapped folder location." + " Copied title files cannot refer to the unmapped folder location.";
                String code = "TITLE_COPY_BAD_FILE_URL";
                TitleValidationMessage message = TitleValidationMessage.createMessage((TitleValidationMessage.Type)TitleValidationMessage.Type.Error, (String)code, (String)msg);
                messages.add(message);
                throw new TitleValidationException(messages);
            }
        }
    }

    private void unmapFiles(Title title, Asset existingAsset, Map<String, List<com.tandbergtv.metadatamanager.model.File>> filePathMap) {
        if (title.isCopy()) {
            return;
        }
        ArrayList<String> unmappedFileURLs = new ArrayList<String>();
        List<com.tandbergtv.metadatamanager.model.File> filesToUnmap = this.getDifferenceInFiles(existingAsset, title.getAsset());
        Iterator<com.tandbergtv.metadatamanager.model.File> filesToUnmapIterator = filesToUnmap.iterator();
        while (filesToUnmapIterator.hasNext()) {
            com.tandbergtv.metadatamanager.model.File fileToUnmap = filesToUnmapIterator.next();
            String fileURL = fileToUnmap.getURL();
            boolean unmapFile = true;
            List<com.tandbergtv.metadatamanager.model.File> matchingURLFiles = filePathMap.get(fileURL);
            if (matchingURLFiles != null && matchingURLFiles.size() > 0) {
                unmapFile = false;
            } else if (!AssetsManager.getThreadLocalInstance().isMappedFile(fileURL)) {
                unmapFile = false;
            } else if (unmappedFileURLs.contains(fileURL)) {
                unmapFile = false;
            } else if (this.isSharedFilePath(title, fileURL)) {
                unmapFile = false;
            }
            if (!unmapFile) {
                filesToUnmapIterator.remove();
                continue;
            }
            unmappedFileURLs.add(fileURL);
        }
        String dirName = PMMUtil.getPathFilterFieldValue(title.getAsset());
        this.moveToUnmappedFilesDir(filesToUnmap, dirName);
    }

    private Map<String, List<com.tandbergtv.metadatamanager.model.File>> getFilePathMap(Title title) {
        HashMap<String, List<com.tandbergtv.metadatamanager.model.File>> filePathMap = new HashMap<String, List<com.tandbergtv.metadatamanager.model.File>>();
        List files = title.getAsset().getAllDescendantFiles();
        for (com.tandbergtv.metadatamanager.model.File file : files) {
            String url = file.getURL();
            ArrayList<com.tandbergtv.metadatamanager.model.File> filesForURL = (ArrayList<com.tandbergtv.metadatamanager.model.File>)filePathMap.get(url);
            if (filesForURL == null) {
                filesForURL = new ArrayList<com.tandbergtv.metadatamanager.model.File>();
                filePathMap.put(url, filesForURL);
            }
            filesForURL.add(file);
        }
        return filePathMap;
    }

    private boolean isSharedFilePath(Title title, String fileURL) {
        AssetSearchField field1 = new AssetSearchField();
        field1.setName(FieldName.FILE_URL.toString());
        field1.setParamType(ParamType.VALUE);
        field1.setOperator(LogicalOperator.EQUAL);
        field1.setSearchType(SearchType.STRING);
        field1.setSectionName(Item.ItemType.FILE.toString());
        field1.setValues(new ArrayList());
        field1.getValues().add(fileURL);
        field1.setConjunction(true);
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(title.getId()));
        TitleSearchField field2 = new TitleSearchField(TitleSearchKey.TITLE_ID.toString(), values, SearchType.NUMERIC, LogicalOperator.NOTEQUAL, ParamType.VALUE, true, true);
        field2.setConjunction(true);
        ArrayList<Object> searchFields = new ArrayList<Object>();
        searchFields.add(field1);
        searchFields.add(field2);
        int count = this.titleSearchService.countIncludeAllcopies(searchFields);
        return count > 0;
    }

    private Asset getAssetWithId(Title title, long id) {
        return this.findMatchingAsset(id, title.getAllAssets(false));
    }

    private boolean hasOriginalFile(Asset asset) {
        for (com.tandbergtv.metadatamanager.model.File file : asset.getDirectDescendantFiles()) {
            if (!file.isOriginal()) continue;
            return true;
        }
        return false;
    }

    @Transactional
    public Title createTitleAsDraft(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (Title)PMMUIService.createTitleAsDraft_aroundBody5$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), PMMUIService.class.getDeclaredMethod("createTitleAsDraft", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void batchUpdateTitleMetadata(Title updates, List<Long> titleIds, boolean currentState, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title = updates;
        List<Long> list = titleIds;
        boolean bl = currentState;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        PMMUIService.batchUpdateTitleMetadata_aroundBody7$advice(this, title, list, bl, string, string2, string3, TransactionEnforcer.aspectOf(), PMMUIService.class.getDeclaredMethod("batchUpdateTitleMetadata", Title.class, List.class, Boolean.TYPE, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private void batchMerge(Asset updates, Asset asset) {
        Relation relation;
        Asset target;
        for (Field fieldUpdate : updates.getFields()) {
            boolean highCardinality = false;
            boolean nullify = fieldUpdate.isNullify();
            String xpath = fieldUpdate.getTtvXPath();
            if (nullify) {
                Iterator fieldIterator = asset.getFields().iterator();
                while (fieldIterator.hasNext()) {
                    Field assetField = (Field)fieldIterator.next();
                    if (!assetField.getTtvXPath().equals(xpath)) continue;
                    fieldIterator.remove();
                }
                continue;
            }
            Field assetField = asset.getFirstField(xpath);
            if (assetField == null || highCardinality) {
                int indexCount = xpath.replaceAll("[^/]", "").length();
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < indexCount; ++i) {
                    indices.add(1);
                }
                Field f = new Field(xpath, fieldUpdate.getValue());
                f.setIndices(indices);
                asset.addField(f);
                continue;
            }
            assetField.setTypedValue(fieldUpdate.getTypedValue());
        }
        if (updates.getAssetType().equals("PACKAGE") && (target = (relation = (Relation)updates.getRelations().get(0)).getTargetAsset()).getAssetType().equals("TITLE")) {
            Asset title = null;
            for (Relation assetRelation : asset.getRelations()) {
                Asset targetAsset = assetRelation.getTargetAsset();
                if (!targetAsset.getAssetType().equals("TITLE")) continue;
                title = targetAsset;
                break;
            }
            this.batchMerge(target, title);
        }
    }

    @Transactional
    public Title updateTitleMetadataAsDraft(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (Title)PMMUIService.updateTitleMetadataAsDraft_aroundBody9$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), PMMUIService.class.getDeclaredMethod("updateTitleMetadataAsDraft", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private List<com.tandbergtv.metadatamanager.model.File> getDifferenceInFiles(Asset firstAsset, Asset secondAsset) {
        ArrayList<com.tandbergtv.metadatamanager.model.File> resultFiles = new ArrayList<com.tandbergtv.metadatamanager.model.File>();
        List<Asset> firstTree = this.getAssets(firstAsset);
        List<Asset> secondTree = this.getAssets(secondAsset);
        for (Asset firstTreeAsset : firstTree) {
            Asset secondTreeAsset = this.findMatchingAsset(firstTreeAsset.getId(), secondTree);
            if (secondTreeAsset == null) continue;
            resultFiles.addAll(this.getDifferenceInChildFiles(firstTreeAsset, secondTreeAsset));
        }
        return resultFiles;
    }

    private List<Asset> getAssets(Asset root) {
        return root != null ? root.getAllAssets(false) : new ArrayList();
    }

    private List<com.tandbergtv.metadatamanager.model.File> getDifferenceInChildFiles(Asset firstAsset, Asset secondAsset) {
        ArrayList<com.tandbergtv.metadatamanager.model.File> resultFiles = new ArrayList<com.tandbergtv.metadatamanager.model.File>();
        List firstAssetFiles = firstAsset.getDirectDescendantFiles();
        List secondAssetFiles = secondAsset == null ? null : secondAsset.getDirectDescendantFiles();
        for (com.tandbergtv.metadatamanager.model.File firstAssetFile : firstAssetFiles) {
            com.tandbergtv.metadatamanager.model.File secondAssetFile = (com.tandbergtv.metadatamanager.model.File)this.findMatchingAsset(firstAssetFile.getId(), secondAssetFiles);
            boolean match = false;
            if (secondAssetFile != null) {
                String secondURL;
                String firstURL = firstAssetFile.getURL();
                boolean bl = match = firstURL == (secondURL = secondAssetFile.getURL()) || firstURL != null && firstURL.equals(secondURL);
            }
            if (match) continue;
            resultFiles.add(firstAssetFile);
        }
        return resultFiles;
    }

    private <T extends Asset> T findMatchingAsset(long assetID, Collection<T> assets) {
        if (assets != null) {
            for (Asset asset : assets) {
                if (asset.getId() != assetID) continue;
                return (T)asset;
            }
        }
        return null;
    }

    private void moveToUnmappedFilesDir(List<com.tandbergtv.metadatamanager.model.File> files, String dirName) {
        for (com.tandbergtv.metadatamanager.model.File file : files) {
            AssetsManager assetsManager;
            File javaFile;
            String url;
            Field urlField = file.getFirstField(FieldName.FILE_URL.toString());
            if (urlField == null || (url = urlField.getValue()) == null || !(javaFile = new File(url)).exists() || !url.startsWith((assetsManager = AssetsManager.getThreadLocalInstance()).getMappedFilesDirectory().getAbsolutePath())) continue;
            logger.debug((Object)("Attempting to move file [" + url + "] to unmapped files dircetory."));
            File movedFile = null;
            try {
                movedFile = AssetsManager.getThreadLocalInstance().moveToUnmappedFilesDirectory(javaFile, dirName);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to move file [" + url + "] from mapped files directory to unmapped files directory [" + assetsManager.getUnmappedFilesDirectory() + "]. ", e);
            }
            logger.debug((Object)("Moved file [" + url + "] to [" + movedFile.getAbsolutePath() + "]"));
        }
    }

    private void moveFilesToMappedFilesDir(Title title) throws RuntimeException {
        AssetsManager assetsManager = AssetsManager.getThreadLocalInstance();
        Asset asset = title.getAsset();
        List files = asset.getAllDescendantFiles();
        if (files != null) {
            for (com.tandbergtv.metadatamanager.model.File file : files) {
                String url;
                logger.debug((Object)("File: " + file));
                Field urlField = file.getFirstField(FieldName.FILE_URL.toString());
                if (urlField == null || (url = urlField.getValue()) == null || !url.startsWith(assetsManager.getUnmappedFilesDirectory().getAbsolutePath())) continue;
                File movedFile = null;
                try {
                    logger.debug((Object)("Attempting to move file [" + url + "] to mapped files dircetory."));
                    movedFile = AssetsManager.getThreadLocalInstance().moveToMappedFilesDirectory(new File(url));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to move file [" + url + "] from unmapped files directory to mapped files directory [" + assetsManager.getMappedFilesDirectory() + "]. ", e);
                }
                if (movedFile == null) continue;
                logger.debug((Object)("Moved file [" + url + "] to [" + movedFile.getAbsolutePath() + "]"));
                urlField.setValue(movedFile.getAbsolutePath());
            }
        }
    }

    private void sendProgressStatusForManuallyMappedFiles(Map<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        for (com.tandbergtv.metadatamanager.model.File file : fileToAssetMap.keySet()) {
            Asset asset = fileToAssetMap.get(file);
            if (asset.getRoot() == null) {
                this.statusService.sendMetadataReceivedStatus(title, sourceComponentName, sourceEntityName, sourceId);
                continue;
            }
            String titleName = asset.getAssetType();
            this.statusService.sendAssetReceivedStatus(title, titleName, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private Map<com.tandbergtv.metadatamanager.model.File, Asset> getNewlyAddedFiles(Asset incomingAsset, Asset existingAsset) {
        HashMap<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap = new HashMap<com.tandbergtv.metadatamanager.model.File, Asset>();
        List<Asset> incomingTree = this.getAssets(incomingAsset);
        List<Asset> existingTree = this.getAssets(existingAsset);
        for (Asset incomingTreeAsset : incomingTree) {
            Asset existingTreeAsset = this.findMatchingAsset(incomingTreeAsset.getId(), existingTree);
            List<com.tandbergtv.metadatamanager.model.File> files = this.getDifferenceInChildFiles(incomingTreeAsset, existingTreeAsset);
            for (com.tandbergtv.metadatamanager.model.File file : files) {
                fileToAssetMap.put(file, incomingTreeAsset);
            }
        }
        return fileToAssetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ SaveResult createTitle_aroundBody0(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        boolean success = false;
        try {
            title = this_.nationalizeTitle(title, NormalizationContextEvent.UICREATED);
            this_.moveFilesToMappedFilesDir(title);
            Map<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap = this_.getNewlyAddedFiles(title.getAsset(), null);
            TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
            ISavedTitle savedTitle = null;
            try {
                savedTitle = this_.titleManager.create(title, false, (ITitleActionSource)source);
                title = savedTitle.getTitle();
            }
            catch (TitleValidationException e) {
                String code = "PMMUI-001";
                String message = "Title made invalid after applying nationalization rules.";
                throw new FatalTitleValidationException(code, message, e.getMessages());
            }
            this_.statusService.sendStatus(title, ProgressStatusHelper.NORMALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
            this_.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, title, sourceComponentName, sourceEntityName, sourceId);
            RulesEngineFacade.sendUICreatedEvent(title.getId());
            success = true;
            SaveResult saveResult = new SaveResult(title, savedTitle.getValidationMessages());
            return saveResult;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
    }

    private static final /* synthetic */ Object createTitle_aroundBody1$advice(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMUIService.createTitle_aroundBody0(this_, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SaveResult object = PMMUIService.createTitle_aroundBody0(this_, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ SaveResult updateTitleMetadata_aroundBody2(PMMUIService this_, Title title, Long requestKey, String action, String listOfAssetIds, String sourceComponentName, String sourceEntityName, String sourceId) {
        SaveResult result = null;
        boolean success = false;
        try {
            result = this_.updateTitle(title, false, sourceComponentName, sourceEntityName, sourceId);
            if (requestKey != null && action.equals(ACTION_MAP_ASSET)) {
                ArrayList<Long> requestedAssetIds = new ArrayList<Long>();
                for (String assetIdStr : listOfAssetIds.split(",")) {
                    requestedAssetIds.add(Long.valueOf(assetIdStr.trim()));
                }
                ArrayList<Asset> requestedAssetsWithOriginalFile = new ArrayList<Asset>();
                ArrayList<Asset> requestedAssetsWithoutOriginalFile = new ArrayList<Asset>();
                for (Long requestedAssetId : requestedAssetIds) {
                    Asset requestedAsset = this_.getAssetWithId(title, requestedAssetId);
                    if (this_.hasOriginalFile(requestedAsset)) {
                        requestedAssetsWithOriginalFile.add(requestedAsset);
                        continue;
                    }
                    requestedAssetsWithoutOriginalFile.add(requestedAsset);
                }
                if (requestedAssetsWithOriginalFile.size() == requestedAssetIds.size()) {
                    WorkflowNotifier wnThread = new WorkflowNotifier(requestKey);
                    wnThread.start();
                } else {
                    StringBuffer assetTypesSB = new StringBuffer();
                    boolean firstTime = true;
                    for (Asset asset : requestedAssetsWithoutOriginalFile) {
                        if (firstTime) {
                            firstTime = false;
                        } else {
                            assetTypesSB.append(", ");
                        }
                        assetTypesSB.append(asset.getAssetType());
                    }
                    HashMap<String, String> actionResponseMap = new HashMap<String, String>();
                    actionResponseMap.put(UNMAPPED_ASSETS, assetTypesSB.toString());
                    result.setActionResponseMap(actionResponseMap);
                }
            }
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        return result;
    }

    private static final /* synthetic */ Object updateTitleMetadata_aroundBody3$advice(PMMUIService this_, Title title, Long requestKey, String action, String listOfAssetIds, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMUIService.updateTitleMetadata_aroundBody2(this_, title, requestKey, action, listOfAssetIds, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SaveResult object = PMMUIService.updateTitleMetadata_aroundBody2(this_, title, requestKey, action, listOfAssetIds, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Title createTitleAsDraft_aroundBody4(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        boolean success = false;
        try {
            this_.moveFilesToMappedFilesDir(title);
            Map<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap = this_.getNewlyAddedFiles(title.getAsset(), null);
            TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
            this_.titleManager.create(title, true, (ITitleActionSource)source);
            this_.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, title, sourceComponentName, sourceEntityName, sourceId);
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        return title;
    }

    private static final /* synthetic */ Object createTitleAsDraft_aroundBody5$advice(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMUIService.createTitleAsDraft_aroundBody4(this_, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = PMMUIService.createTitleAsDraft_aroundBody4(this_, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void batchUpdateTitleMetadata_aroundBody6(PMMUIService this_, Title updates, List titleIds, boolean currentState, String sourceComponentName, String sourceEntityName, String sourceId) {
        for (Long titleId : titleIds) {
            Title title = this_.titleManager.getForUpdate(titleId);
            Asset gotAsset = title.getAsset();
            this_.batchMerge(updates.getAsset(), gotAsset);
            boolean draft = false;
            draft = currentState ? TitleStatus.DRAFT.equals((Object)title.getStatus()) : TitleStatus.DRAFT.equals((Object)updates.getStatus());
            if (draft) {
                this_.updateTitleMetadataAsDraft(title, sourceComponentName, sourceEntityName, sourceId);
                continue;
            }
            this_.updateTitleMetadata(title, null, null, null, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private static final /* synthetic */ Object batchUpdateTitleMetadata_aroundBody7$advice(PMMUIService this_, Title updates, List titleIds, boolean currentState, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            PMMUIService.batchUpdateTitleMetadata_aroundBody6(this_, updates, titleIds, currentState, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PMMUIService.batchUpdateTitleMetadata_aroundBody6(this_, updates, titleIds, currentState, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Title updateTitleMetadataAsDraft_aroundBody8(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        SaveResult result = null;
        boolean success = false;
        try {
            result = this_.updateTitle(title, true, sourceComponentName, sourceEntityName, sourceId);
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        return result.getTitle();
    }

    private static final /* synthetic */ Object updateTitleMetadataAsDraft_aroundBody9$advice(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMUIService.updateTitleMetadataAsDraft_aroundBody8(this_, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = PMMUIService.updateTitleMetadataAsDraft_aroundBody8(this_, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

