/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.callback;

import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.job.callback.AbstractJobCallback;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class RuleSetInvoker
extends AbstractJobCallback {
    private static final String QUEUE_NAME = "queue/EventQueue";
    private static final Logger logger = Logger.getLogger(RuleSetInvoker.class);

    public RuleSetInvoker(IJobCallback next) {
        super(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeJob(Map<String, Object> data, Date date) {
        String id = this.getRuleSetId(data);
        List<Long> titles = this.getTitles(data);
        boolean isAssociatedWithTitles = (Boolean)data.get(JobScheduleInfoConstants.JOB_IS_ASSOCIATED_WITH_TITLES);
        if (titles.isEmpty() && isAssociatedWithTitles) {
            super.executeJob(data, date);
            return;
        }
        if (id != null && !id.isEmpty()) {
            QueueSession session = null;
            QueueSender sender = null;
            QueueConnection connection = null;
            try {
                logger.debug((Object)"Calling rule engine");
                InitialContext context = new InitialContext();
                QueueConnectionFactory queueFactory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
                connection = queueFactory.createQueueConnection();
                session = connection.createQueueSession(false, 1);
                Queue queue = (Queue)context.lookup(QUEUE_NAME);
                sender = session.createSender(queue);
                ObjectMessage message = session.createObjectMessage();
                message.setStringProperty("ruleSetId", id);
                if (!titles.isEmpty()) {
                    message.setObjectProperty("titleIds", (Object)titles.toString());
                }
                sender.send(queue, (Message)message);
            }
            catch (Exception e) {
                logger.warn((Object)("Problem during job " + data.get(JobScheduleInfoConstants.JOB_NAME) + " execution"), (Throwable)e);
            }
            finally {
                try {
                    connection.close();
                }
                catch (JMSException e1) {
                    logger.warn((Object)"Problems cleaning up after sending message", (Throwable)e1);
                }
            }
        }
        super.executeJob(data, date);
    }

    private String getRuleSetId(Map<String, Object> data) {
        Collection parameters = (Collection)data.get(JobScheduleInfoConstants.JOB_PARAMETERS);
        for (JobParameter parameter : parameters) {
            if (!parameter.getName().equals("ruleset")) continue;
            logger.debug((Object)("Found ruleset " + parameter.getValue()));
            return parameter.getValue();
        }
        return null;
    }

    private List<Long> getTitles(Map<String, Object> data) {
        ArrayList<Long> titles = new ArrayList<Long>();
        if (data.containsKey("titles")) {
            for (Title title : (Collection)data.get("titles")) {
                titles.add(title.getId());
            }
        }
        return titles;
    }
}

