/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.callback;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.AssetSearchField;
import com.tandbergtv.cms.title.search.entities.ParamType;
import com.tandbergtv.cms.title.search.entities.SearchField;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.handler.AbstractTitleAssociatedHandler;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluatorChain;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class SiteTitleHandler
extends AbstractTitleAssociatedHandler {
    private static final Logger logger = Logger.getLogger(SiteTitleHandler.class);
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";
    private static String DATE_FORMAT = "yyyy-MM-dd";

    public SiteTitleHandler(IJobCallback next) {
        super(next);
    }

    @Override
    @Transactional
    public void executeJob(Map<String, Object> callbackInfo, Date jobExecutionDate) {
        Map<String, Object> map = callbackInfo;
        Date date = jobExecutionDate;
        SiteTitleHandler.executeJob_aroundBody1$advice(this, map, date, TransactionEnforcer.aspectOf(), SiteTitleHandler.class.getDeclaredMethod("executeJob", Map.class, Date.class).getAnnotation(Transactional.class), null);
    }

    private void processRequest(Map<String, Object> callbackInfo, Date jobExecutionDate) {
        IContainer container = this.getContainer(callbackInfo);
        if (!container.getContainerType().equals((Object)ContainerType.SITE)) {
            return;
        }
        int siteId = Long.valueOf(container.getContainerId()).intValue();
        logger.debug((Object)("SiteId : " + siteId));
        ISiteManager siteManager = this.getSiteManager();
        boolean scheduleOnly = (Boolean)callbackInfo.get("scheduleOnly");
        boolean associatedWithTitles = (Boolean)callbackInfo.get(JobScheduleInfoConstants.JOB_IS_ASSOCIATED_WITH_TITLES);
        if (scheduleOnly) {
            if (associatedWithTitles) {
                String ruleName = (String)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_NAME);
                List ruleParameters = (List)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_PARAMETERS);
                int index = this.getParameterReferenceFieldIndex(ruleName);
                RuleParameter parameterReference = (RuleParameter)ruleParameters.get(index);
                ReferenceEvaluatorChain evaluatorChain = ReferenceEvaluatorChain.getInstance();
                ParameterReferencePath path = evaluatorChain.getPath(parameterReference.getValue());
                String sectionName = path.getName();
                String fieldXPath = path.getPropertyField();
                Date date = this.getSearchDate(ruleName, ruleParameters, jobExecutionDate);
                this.setTimeToBeginningOfTheDay(date);
                List readyDSTs = siteManager.getDistributionSiteTitlesBySiteAndStatus(siteId, DistributionStatus.READY_FOR_DISTRIBUTION);
                ArrayList<Long> idOfTitlesToDistribute = new ArrayList<Long>();
                if (readyDSTs != null) {
                    for (DistributionSiteTitle dst : readyDSTs) {
                        if (!this.matches(dst.getTitle(), sectionName, fieldXPath, date)) continue;
                        idOfTitlesToDistribute.add(dst.getTitle().getId());
                    }
                }
                if (idOfTitlesToDistribute != null && !idOfTitlesToDistribute.isEmpty()) {
                    siteManager.distributeImmediately(siteId, idOfTitlesToDistribute);
                }
            } else {
                siteManager.distributeReadyTitlesImmediately(siteId);
            }
            return;
        }
        if (associatedWithTitles) {
            this.doExecute(callbackInfo, jobExecutionDate);
            return;
        }
    }

    private boolean matches(Title t, String sectionName, String fieldXPath, Date date) {
        List fields = t.getAsset().getAllFieldsForXpath(sectionName, fieldXPath);
        if (fields != null) {
            for (Field field : fields) {
                Date fieldDate = (Date)field.getTypedValue();
                this.setTimeToBeginningOfTheDay(fieldDate);
                if (!date.equals(fieldDate)) continue;
                return true;
            }
        }
        return false;
    }

    private void setTimeToBeginningOfTheDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date.setTime(cal.getTimeInMillis());
    }

    private IContainer getContainer(Map<String, Object> callbackInfo) {
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        long contextId = (Long)callbackInfo.get(JobScheduleInfoConstants.CONTEXTID);
        return (IContainer)containerCache.get((Serializable)Long.valueOf(contextId));
    }

    private ISiteManager getSiteManager() {
        ISiteManager siteManager;
        try {
            siteManager = (ISiteManager)new InitialContext().lookup("cms/SiteManager/local");
        }
        catch (NamingException e) {
            throw new RuntimeException("Exception while finding SiteManager: ", e);
        }
        return siteManager;
    }

    private ITitleSearchService getSearchService() {
        return (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
    }

    @Override
    protected void processItems(Collection<?> items, Map<String, Object> callbackInfo) {
        callbackInfo.put("titles", items);
    }

    @Override
    protected Collection<?> search(ParameterReferencePath path, Map<String, Object> callbackInfo, Date jobExecutionDate) {
        String ruleName = (String)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_NAME);
        List ruleParameters = (List)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_PARAMETERS);
        Date date = this.getSearchDate(ruleName, ruleParameters, jobExecutionDate);
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        fields.add(this.getSearchFields(path, date));
        IContainer container = this.getContainer(callbackInfo);
        ArrayList<Integer> siteIds = new ArrayList<Integer>();
        siteIds.add(Long.valueOf(container.getContainerId()).intValue());
        ITitleSearchService searchService = this.getSearchService();
        return searchService.getSiteTitle(fields, siteIds, SiteType.DISTRIBUTION_SITE);
    }

    private SearchField getSearchFields(ParameterReferencePath path, final Date date) {
        AssetSearchField field = new AssetSearchField();
        field.setName(path.getPropertyField());
        field.setParamType(ParamType.VALUE);
        field.setOperator(LogicalOperator.EQUAL);
        field.setSearchType(SearchType.STRING);
        field.setSectionName(path.getName());
        field.setValues((List)new ArrayList<String>(){
            {
                this.add(SiteTitleHandler.this.formatSearchDate(date));
            }
        });
        return field;
    }

    private String formatSearchDate(Date searchDate) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        df.setLenient(false);
        return df.format(searchDate);
    }

    private static final /* synthetic */ void executeJob_aroundBody0(SiteTitleHandler this_, Map callbackInfo, Date jobExecutionDate) {
        try {
            this_.processRequest(callbackInfo, jobExecutionDate);
            this_.next.executeJob(callbackInfo, jobExecutionDate);
        }
        catch (RuntimeException e) {
            IContainer container = CallbackHelper.getContainer(callbackInfo);
            String errorMsg = "Job execution failed for job: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    private static final /* synthetic */ Object executeJob_aroundBody1$advice(SiteTitleHandler this_, Map callbackInfo, Date jobExecutionDate, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            SiteTitleHandler.executeJob_aroundBody0(this_, callbackInfo, jobExecutionDate);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SiteTitleHandler.executeJob_aroundBody0(this_, callbackInfo, jobExecutionDate);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

