/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.execution;

import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.job.callback.AbstractJobCallback;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WorkOrderCreator
extends AbstractJobCallback {
    private static String WORK_ORDER_MESSAGE_UID = "PM0111";

    public WorkOrderCreator(IJobCallback next) {
        super(next);
    }

    @Override
    public void executeJob(Map<String, Object> info, Date jobExecutionDate) {
        String templateName = (String)info.get(JobScheduleInfoConstants.JOB_SELECTED_TEMPLATE_NAME);
        if (templateName == null || templateName.length() == 0) {
            super.executeJob(info, jobExecutionDate);
            return;
        }
        Collection<Title> titles = this.getTitles(info);
        boolean isAssociatedWithTitles = (Boolean)info.get(JobScheduleInfoConstants.JOB_IS_ASSOCIATED_WITH_TITLES);
        if (titles.size() == 0 && isAssociatedWithTitles) {
            super.executeJob(info, jobExecutionDate);
            return;
        }
        String priority = ((String)info.get(JobScheduleInfoConstants.JOB_PRIORITY)).toUpperCase();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Collection parameters = (Collection)info.get(JobScheduleInfoConstants.JOB_PARAMETERS);
        for (JobParameter parameter : parameters) {
            variables.put(parameter.getName(), parameter.getValue());
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        WorkflowTemplate definition = ((ITemplateLoaderService)registry.lookup(ITemplateLoaderService.class)).getTemplateByName(templateName);
        Map<String, Object> vars = this.prepareTemplateVariables(definition, variables);
        WorkflowMessage message = this.createWorkFlowMessage(templateName, priority, vars);
        IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
        try {
            IMessage msg = WorkOrderCreator.convert(message);
            router.send(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            super.executeJob(info, jobExecutionDate);
        }
    }

    private Map<String, Object> prepareTemplateVariables(WorkflowTemplate definition, Map<String, Object> variables) {
        HashMap<String, Object> templateVariables = new HashMap<String, Object>();
        for (TaskVariable variable : definition.getStartTaskVariables()) {
            String varValue = (String)variables.get(variable.getMappedName());
            if (varValue == null || varValue.trim().length() <= 0) continue;
            templateVariables.put(variable.getVariableName(), varValue);
        }
        return templateVariables;
    }

    private WorkflowMessage createWorkFlowMessage(String templateName, String priority, Map<String, Object> variables) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)WORK_ORDER_MESSAGE_UID);
        WPCLCommand command = new WPCLCommand("create");
        command.addParameter("priority", priority);
        command.addParameter("_template", templateName);
        message.setCommand(command);
        WorkflowPayload payload = message.getPayload();
        for (String name : variables.keySet()) {
            String value = variables.get(name).toString();
            payload.putValue(name, value);
        }
        return message;
    }

    private static IMessage convert(WorkflowMessage message) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(message);
        StringPayload payload = new StringPayload(XMLDocumentUtility.convertToString((Node)document));
        return new MessageImpl((IPayload)payload, message.getAttachment());
    }

    private Collection<Title> getTitles(Map<String, Object> data) {
        if (data.containsKey("titles")) {
            return (Collection)data.get("titles");
        }
        return new ArrayList<Title>();
    }
}

