/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.handler;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.handler.AbstractTitleAssociatedHandler;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluatorChain;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScheduleAssociatedHandler
extends AbstractTitleAssociatedHandler {
    private Logger logger = Logger.getLogger(ScheduleAssociatedHandler.class);
    private static String SCHEDULE_PITCHDATE_FIELD = "pitchDate";
    private static String PLANNER_DATE_FIELD = "plannerDate";
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    public ScheduleAssociatedHandler(IJobCallback next) {
        super(next);
    }

    @Override
    public Collection<?> search(ParameterReferencePath path, Map<String, Object> searchInfo, Date jobExecutionDate) {
        Collection schedules = null;
        String ruleName = (String)searchInfo.get(JobScheduleInfoConstants.JOB_RULE_NAME);
        List ruleParameters = (List)searchInfo.get(JobScheduleInfoConstants.JOB_RULE_PARAMETERS);
        long contextId = (Long)searchInfo.get(JobScheduleInfoConstants.CONTEXTID);
        Date searchDate = this.getSearchDate(ruleName, ruleParameters, jobExecutionDate);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        if (path.getPropertyField().equalsIgnoreCase(SCHEDULE_PITCHDATE_FIELD)) {
            schedules = searchService.getPitchSchedulesByPitchDate(Long.valueOf(contextId), searchDate, new ScheduleStatus[]{ScheduleStatus.APPROVED});
            this.logger.info((Object)("Search resulted in " + schedules.size() + " pitch schedules."));
        } else if (path.getPropertyField().equalsIgnoreCase(PLANNER_DATE_FIELD)) {
            ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
            IContainer container = (IContainer)containerCache.get((Serializable)Long.valueOf(contextId));
            if (container == null) {
                throw new RuntimeException("No container found with contextId: " + contextId);
            }
            if (container.getContainerType() == ContainerType.SERVICE) {
                String errorMessage = "Job execution failed for job: " + searchInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]" + " Planners cannot be associated with services.";
                throw new RuntimeException(errorMessage);
            }
            schedules = searchService.getPlannersByDate(Long.valueOf(container.getContainerId()), searchDate);
            this.logger.info((Object)("Search resulted in " + schedules.size() + " planners."));
        }
        return schedules;
    }

    @Override
    protected void processItems(Collection<?> items, Map<String, Object> callbackInfo) {
        ReferenceEvaluatorChain evaluatorChain = ReferenceEvaluatorChain.getInstance();
        for (Schedule schedule : items) {
            this.logger.debug((Object)("Found schedule " + schedule));
            try {
                Map<String, Object> clone = CallbackHelper.clone(callbackInfo);
                evaluatorChain.evaluate(schedule, clone);
                clone.put("titles", schedule.getTitles());
                this.next.executeJob(clone, null);
            }
            catch (RuntimeException e) {
                IContainer container = CallbackHelper.getContainer(callbackInfo);
                this.logger.error((Object)("Job execution failed for: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]" + " Error while evaluating parameters or executing job for schedule " + schedule.getDate()), (Throwable)e);
            }
        }
    }
}

