/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.handler;

import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.AssetSearchField;
import com.tandbergtv.cms.title.search.entities.ParamType;
import com.tandbergtv.cms.title.search.entities.SearchField;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.handler.AbstractTitleAssociatedHandler;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TitleAssociatedHandler
extends AbstractTitleAssociatedHandler {
    private static String DATE_FORMAT = "yyyy-MM-dd";
    private Logger logger = Logger.getLogger(TitleAssociatedHandler.class);

    public TitleAssociatedHandler(IJobCallback next) {
        super(next);
    }

    private SearchField buildSearchField(ParameterReferencePath path, Map<String, Object> searchInfo, Date jobExecutionDate) {
        String ruleName = (String)searchInfo.get(JobScheduleInfoConstants.JOB_RULE_NAME);
        List ruleParameters = (List)searchInfo.get(JobScheduleInfoConstants.JOB_RULE_PARAMETERS);
        Date date = this.getSearchDate(ruleName, ruleParameters, jobExecutionDate);
        return this.getSearchFields(path, date);
    }

    private SearchField getSearchFields(ParameterReferencePath path, final Date date) {
        AssetSearchField field = new AssetSearchField();
        field.setName(path.getPropertyField());
        field.setParamType(ParamType.VALUE);
        field.setOperator(LogicalOperator.EQUAL);
        field.setSearchType(SearchType.STRING);
        field.setSectionName(path.getName());
        field.setValues((List)new ArrayList<String>(){
            {
                this.add(TitleAssociatedHandler.this.formatSearchDate(date));
            }
        });
        return field;
    }

    @Override
    protected Collection<?> search(ParameterReferencePath path, Map<String, Object> searchInfo, Date date) {
        SearchField searchField = this.buildSearchField(path, searchInfo, date);
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        fields.add(searchField);
        ITitleSearchService searchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        List titles = searchService.search(fields);
        this.logger.info((Object)("Search resulted in " + titles.size() + " titles."));
        return titles;
    }

    @Override
    protected void processItems(Collection<?> items, Map<String, Object> callbackInfo) {
        callbackInfo.put("titles", items);
        this.next.executeJob(callbackInfo, null);
    }

    private String formatSearchDate(Date searchDate) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        df.setLenient(false);
        return df.format(searchDate);
    }
}

