/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.referenceEvaluator;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.watchpoint.pmm.job.util.ParameterReferenceHelper;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderRegistry;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TitleReferenceEvaluator
extends ReferenceEvaluator {
    private static String TITLE_PARAMETER_REFERENCE_GROUP = "Title";
    private static String TITLE_ID = "Id";
    private static String TITLE_SOURCE_PATH = "External Source Path";
    private static final String FIELD_XPATH_PREFIX = "/";
    private static final String TTV_FIELD_NS = "/tns:";
    private static final String FILE_ASSET_SUFFIX = "-FILE";
    private static final Logger logger = Logger.getLogger(TitleReferenceEvaluator.class);

    @Override
    public void evaluate(Object entity, Map<String, Object> info) {
        logger.debug((Object)"Evaluating Title parameter references");
        if (entity == null || !(entity instanceof Title)) {
            if (this.successor != null) {
                this.successor.evaluate(entity, info);
            }
            return;
        }
        Title title = (Title)entity;
        List parameters = (List)info.get(JobScheduleInfoConstants.JOB_PARAMETERS);
        for (JobParameter parameter : parameters) {
            String groupName;
            if (parameter.getValue().trim().length() == 0) continue;
            if (!ParameterReferenceHelper.isParameterReference(parameter.getValue()) && !parameter.getValue().contains(TTV_FIELD_NS)) {
                logger.debug((Object)(parameter.getValue() + " is not a parameter reference, so not resolving it."));
                continue;
            }
            if (ParameterReferenceHelper.isParameterReference(parameter.getValue()) && !(groupName = ParameterReferenceHelper.getGroupName(parameter.getValue())).startsWith(TITLE_PARAMETER_REFERENCE_GROUP)) continue;
            try {
                this.evaluateParameter(title, parameter);
            }
            catch (RuntimeException e) {
                logger.warn((Object)("Job " + info.get(JobScheduleInfoConstants.JOB_NAME) + ", error while trying to evaluate title reference"), (Throwable)e);
            }
        }
        if (this.successor != null) {
            this.successor.evaluate(entity, info);
        }
    }

    private void evaluateParameter(Title title, JobParameter parameter) {
        ParameterReferencePath path = this.getParameterReferencePath(parameter.getValue());
        if (path == null) {
            return;
        }
        String newvalue = null;
        newvalue = path.getIsMetadata() ? this.getMetadataFieldValue(title, path.getName(), path.getPropertyField()) : this.getPropertyValue(title, path.getName(), path.getPropertyField());
        logger.debug((Object)("Setting value for " + path.getPropertyField() + " to " + newvalue));
        parameter.setValue(newvalue);
    }

    private String getMetadataFieldValue(Title title, String assetType, String xpath) {
        Asset root = title.getAsset();
        if (assetType.endsWith(FILE_ASSET_SUFFIX)) {
            File file = this.getFileAsset(root, assetType.replace(FILE_ASSET_SUFFIX, ""));
            if (file == null) {
                return null;
            }
            Field field = file.getFirstField(xpath);
            if (field == null) {
                return null;
            }
            return field.getValue();
        }
        List fields = root.getAllFieldsForXpath(assetType, xpath);
        if (fields.size() > 0) {
            return ((Field)fields.iterator().next()).getValue();
        }
        return null;
    }

    private File getFileAsset(Asset root, String assetType) {
        for (File file : root.getAllDescendantFiles()) {
            Asset parent = root.getAssetsParent((Asset)file);
            if (!file.isOriginal() || !assetType.equals(parent.getAssetType())) continue;
            return file;
        }
        return null;
    }

    private String getPropertyValue(Title title, String assetType, String property) {
        if (property.equalsIgnoreCase(TITLE_ID)) {
            if (assetType == null) {
                return Long.valueOf(title.getId()).toString();
            }
            Asset root = title.getAsset();
            if (assetType.equals(root.getAssetType())) {
                return Long.valueOf(root.getId()).toString();
            }
            List assets = title.getAsset().getTargetAssets(assetType);
            if (assets.size() > 0) {
                return Long.valueOf(((Asset)assets.iterator().next()).getId()).toString();
            }
        }
        if (property.equalsIgnoreCase(TITLE_SOURCE_PATH)) {
            String titleExternalLocation = title.getExternalLocation();
            ServiceRegistry registry = ServiceRegistry.getDefault();
            ITitleProviderRegistry titleProviderRegistry = (ITitleProviderRegistry)registry.lookup(ITitleProviderRegistry.class);
            ITitleProvider provider = titleProviderRegistry.getProviderForTitle(titleExternalLocation);
            if (provider == null) {
                logger.warn((Object)("Provider for title: " + title.getId() + " is null."));
                return null;
            }
            return provider.getProviderInstanceURL(titleExternalLocation);
        }
        throw new IllegalArgumentException("Property is not supported :" + property);
    }

    @Override
    public ParameterReferencePath getPath(String property) {
        if (ParameterReferenceHelper.isParameterReference(property)) {
            String groupName = ParameterReferenceHelper.getGroupName(property);
            logger.debug((Object)("Group name " + groupName));
            if (!groupName.startsWith(TITLE_PARAMETER_REFERENCE_GROUP)) {
                return this.forward(property);
            }
        }
        ParameterReferencePath path = null;
        try {
            path = this.getParameterReferencePath(property);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting path for: " + property, e);
        }
        return path;
    }

    private ParameterReferencePath getParameterReferencePath(String name) {
        String field;
        String type = null;
        if (!ParameterReferenceHelper.isParameterReference(name)) {
            type = ParameterReferenceHelper.getGroupName(name);
        }
        if ((field = ParameterReferenceHelper.getPropertyName(name)).length() == 0) {
            return null;
        }
        logger.debug((Object)("Asset type " + type));
        logger.debug((Object)("Field " + field));
        boolean isMetadata = field.startsWith(FIELD_XPATH_PREFIX);
        ParameterReferencePath path = new ParameterReferencePath();
        path.setName(type);
        path.setPropertyField(field);
        path.setMetadata(isMetadata);
        path.setParameterReference(name);
        return path;
    }

    private ParameterReferencePath forward(String property) {
        if (this.successor != null) {
            return this.successor.getPath(property);
        }
        return null;
    }
}

