/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.scheduling;

import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.conf.JobProperties;
import com.tandbergtv.watchpoint.pmm.job.scheduling.IJobScheduleManager;
import com.tandbergtv.watchpoint.pmm.job.scheduling.QuartzScheduleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class MissedTriggerListener
implements TriggerListener {
    public static String NAME = "MissedTriggerListener";
    private static final Logger logger = Logger.getLogger(MissedTriggerListener.class);

    public String getName() {
        return NAME;
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, int triggerInstructionCode) {
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
    }

    public void triggerMisfired(Trigger trigger) {
        String recoverJobs = JobProperties.getProperty(JobProperties.RECOVER_ALL_JOBS);
        if (recoverJobs != null && !Boolean.parseBoolean(recoverJobs)) {
            logger.info((Object)("Configuration is set to ignore job recovery. So not handling misfire notification for trigger: " + trigger.getName()));
            return;
        }
        logger.debug((Object)("Got misfire notification for trigger: " + trigger.getName()));
        logger.debug((Object)("Misfired trigger's job name: " + trigger.getJobName()));
        if (!(trigger instanceof SimpleTrigger)) {
            logger.debug((Object)"No support for handling misfired triggers for types other than SimpleTrigger as of now.");
            return;
        }
        try {
            IJobCallback cb;
            QuartzScheduleManager scheduleManager = (QuartzScheduleManager)ServiceRegistry.getDefault().lookup(IJobScheduleManager.class);
            JobDetail detail = scheduleManager.getScheduler().getJobDetail(trigger.getJobName(), QuartzScheduleManager.JOB_GROUP_NAME);
            if (detail == null) {
                throw new RuntimeException("No job detail found for Job name: " + trigger.getJobName());
            }
            logger.debug((Object)("Job class name: " + detail.getJobClass()));
            JobDataMap callbackInfo = detail.getJobDataMap();
            try {
                Class callbackClass = detail.getJobClass();
                cb = (IJobCallback)callbackClass.newInstance();
            }
            catch (InstantiationException e) {
                String errorMsg = "Error while instantiating callback class for job: " + trigger.getJobName() + " : " + e.getMessage() + e.getStackTrace();
                logger.error((Object)errorMsg);
                throw new RuntimeException(errorMsg);
            }
            catch (IllegalAccessException e) {
                String errorMsg = "Error while instantiating callback class for job: " + trigger.getJobName() + " : " + e.getMessage() + e.getStackTrace();
                logger.error((Object)errorMsg);
                throw new RuntimeException(errorMsg);
            }
            int misfireCount = this.getMisFireCount(trigger);
            Date misFireStartDate = trigger.getNextFireTime();
            logger.debug((Object)("Start date for missed triggers: " + misFireStartDate.toString()));
            for (int i = 0; i < misfireCount && misFireStartDate != null; ++i) {
                logger.info((Object)("Calling callback for job[" + trigger.getJobName() + "] misfire at: " + misFireStartDate.toString()));
                try {
                    Map<String, Object> clonedMap = CallbackHelper.clone((Map<String, Object>)callbackInfo);
                    cb.executeJob(clonedMap, misFireStartDate);
                }
                catch (RuntimeException e) {
                    logger.error((Object)("Error while executing misfire: " + misFireStartDate.toString() + " : " + e.getMessage() + e.getStackTrace()));
                }
                misFireStartDate = trigger.getFireTimeAfter(misFireStartDate);
            }
        }
        catch (SchedulerException e) {
            String errorMsg = "Error while getting job detail from scheduler: " + e.getMessage();
            logger.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
    }

    private Calendar resetDate(Calendar cal) {
        cal.set(2, 1);
        cal.set(5, 1);
        cal.set(1, 1970);
        return cal;
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        return false;
    }

    private int getMisFireCount(Trigger trigger) {
        int misfireCount = 0;
        if (trigger.getPreviousFireTime() != null) {
            int fireCountUntilToday = ((SimpleTrigger)trigger).computeNumTimesFiredBetween(trigger.getStartTime(), new Date());
            Calendar startCal = Calendar.getInstance();
            startCal.setTime(trigger.getStartTime());
            startCal = this.resetDate(startCal);
            Calendar nowCal = Calendar.getInstance();
            nowCal.setTime(new Date());
            nowCal = this.resetDate(nowCal);
            if (startCal.before(nowCal)) {
                ++fireCountUntilToday;
            }
            int timesTriggered = ((SimpleTrigger)trigger).getTimesTriggered();
            misfireCount = fireCountUntilToday - timesTriggered;
        } else if (((SimpleTrigger)trigger).getTimesTriggered() == 0) {
            misfireCount = ((SimpleTrigger)trigger).computeNumTimesFiredBetween(trigger.getStartTime(), new Date()) + 1;
        } else {
            Date startTime;
            int timesTriggered = ((SimpleTrigger)trigger).getTimesTriggered();
            Date previousExecutionTime = startTime = trigger.getStartTime();
            for (int i = 0; i < timesTriggered - 1; ++i) {
                startTime = previousExecutionTime = ((SimpleTrigger)trigger).getFireTimeAfter(startTime);
            }
            misfireCount = ((SimpleTrigger)trigger).computeNumTimesFiredBetween(previousExecutionTime, new Date());
        }
        logger.debug((Object)("Job[" + trigger.getJobName() + "] was missed " + misfireCount + " time(s)."));
        return misfireCount;
    }
}

