/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.ui;

import com.tandbergtv.watchpoint.pmm.job.conf.ParameterReferenceGroup;
import com.tandbergtv.watchpoint.pmm.job.conf.ParameterReferenceItem;
import com.tandbergtv.watchpoint.pmm.job.ui.IMenuOptionProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;

public class TitleMetadataOptionProvider
implements IMenuOptionProvider {
    @Override
    public List<ParameterReferenceItem> getJobRuleMenuOptions(String spec) {
        ISpecificationManager specMgr = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        Specification s = specMgr.getSpecificationByName(spec);
        return this.getJobRules(s);
    }

    @Override
    public List<ParameterReferenceItem> getJobParameterMenuOptions(String spec) {
        ISpecificationManager specMgr = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        Specification s = specMgr.getSpecificationByName(spec);
        return this.getJobParameters(s);
    }

    public List<ParameterReferenceItem> getJobRules(Specification s) {
        ArrayList<ParameterReferenceItem> items = new ArrayList<ParameterReferenceItem>();
        for (TitleConf tc : s.getRootTitleConfs()) {
            for (ParameterReferenceGroup g : this.filterTitleSections(tc, null, false)) {
                items.add(g);
            }
        }
        return items;
    }

    public List<ParameterReferenceItem> getJobParameters(Specification s) {
        ArrayList<ParameterReferenceItem> items = new ArrayList<ParameterReferenceItem>();
        for (TitleConf tc : s.getRootTitleConfs()) {
            for (ParameterReferenceGroup g : this.filterTitleSections(tc, null, true)) {
                items.add(g);
            }
        }
        return items;
    }

    private List<ParameterReferenceGroup> filterTitleSections(TitleConf tc, ParameterReferenceGroup parent, boolean isJobParameter) {
        ArrayList<ParameterReferenceGroup> groups = new ArrayList<ParameterReferenceGroup>();
        ParameterReferenceGroup group = this.createGroup(tc, parent, isJobParameter);
        if (!group.getItems().isEmpty()) {
            groups.add(group);
        }
        for (TitleConf childTc : tc.getChildren()) {
            List<ParameterReferenceGroup> childGroups = this.filterTitleSections(childTc, group, isJobParameter);
            for (ParameterReferenceGroup g : childGroups) {
                if (g.getItems().isEmpty()) continue;
                groups.add(g);
            }
        }
        return groups;
    }

    private ParameterReferenceGroup createGroup(TitleConf tc, ParameterReferenceGroup parent, boolean isJobParameter) {
        ParameterReferenceGroup group = new ParameterReferenceGroup();
        group.setName(tc.getAlias());
        group.setParent(parent);
        List<ParameterReferenceItem> items = this.filterJobVariable(tc.getMetadata(), group, isJobParameter);
        if (!items.isEmpty()) {
            for (ParameterReferenceItem item : items) {
                group.addItem(item);
            }
        }
        return group;
    }

    private List<ParameterReferenceItem> filterJobVariable(List<Variable> vars, ParameterReferenceGroup group, boolean isJobParameter) {
        ArrayList<ParameterReferenceItem> items = new ArrayList<ParameterReferenceItem>();
        for (Variable v : vars) {
            if (v instanceof SimpleVariable) {
                if (isJobParameter) {
                    if (!((SimpleVariable)v).isJobParameter()) continue;
                    items.add(this.createItem(v, group));
                    continue;
                }
                if (!((SimpleVariable)v).isJobRuleParameter()) continue;
                items.add(this.createItem(v, group));
                continue;
            }
            if (!(v instanceof ComplexVariable)) continue;
            ParameterReferenceGroup variableGroup = new ParameterReferenceGroup();
            variableGroup.setName(v.getDisplayName());
            variableGroup.setParent(group);
            List<ParameterReferenceItem> variableChildItems = this.filterJobVariable(((ComplexVariable)v).getChildren(), variableGroup, isJobParameter);
            if (variableChildItems.isEmpty()) continue;
            variableGroup.setItems(variableChildItems);
            items.add(variableGroup);
        }
        return items;
    }

    private ParameterReferenceItem createItem(Variable v, ParameterReferenceGroup parent) {
        ParameterReferenceItem item = new ParameterReferenceItem();
        item.setName(v.getDisplayName());
        item.setValue(v.getTitleConf().getName() + "." + v.getXPath());
        item.setParent(parent);
        return item;
    }
}

