/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractNotificationGenerator
implements INotificationGenerator {
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String PMM_CONFIG_DIR = "pmm";
    private String metadataFieldName;
    private String metadataFieldType;
    protected ITTVDataModelHandler ttvSpecHandler;
    private static final Logger logger = Logger.getLogger(AbstractNotificationGenerator.class);

    AbstractNotificationGenerator() {
        this.setTitleMetadataInfo();
        ApplicationContext springContext = ApplicationContextHelper.getInstance().getContext();
        this.ttvSpecHandler = (ITTVDataModelHandler)springContext.getBean("TTVSpecHandler");
    }

    @Transactional
    public Notification getNotification(Schedule schedule) {
        Schedule schedule2 = schedule;
        return (Notification)AbstractNotificationGenerator.getNotification_aroundBody1$advice(this, schedule2, TransactionEnforcer.aspectOf(), AbstractNotificationGenerator.class.getDeclaredMethod("getNotification", Schedule.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    protected String constructMessage(String status, Collection<Title> titles) {
        String string = status;
        Collection<Title> collection = titles;
        return (String)AbstractNotificationGenerator.constructMessage_aroundBody3$advice(this, string, collection, TransactionEnforcer.aspectOf(), AbstractNotificationGenerator.class.getDeclaredMethod("constructMessage", String.class, Collection.class).getAnnotation(Transactional.class), null);
    }

    protected abstract void addMessage(Notification var1, String var2, Collection<Title> var3);

    protected abstract String getType();

    protected Date getToday() {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected Date diff(Date date, int days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, days);
        return calendar.getTime();
    }

    protected Collection<NotificationSetting> getSettings() {
        ArrayList<NotificationSetting> settings = new ArrayList<NotificationSetting>();
        try {
            Document document = this.getConfiguration();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String path = "//schedule[@type='" + this.getType() + "']/status";
            logger.debug((Object)("Path " + path));
            NodeList nodes = (NodeList)xpath.evaluate(path, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String status = (String)xpath.evaluate("name", node, XPathConstants.STRING);
                String s = (String)xpath.evaluate("offset", node, XPathConstants.STRING);
                Integer offset = Integer.parseInt(s);
                logger.debug((Object)("Progress name " + status + " offset " + offset));
                settings.add(new NotificationSetting(status, offset));
            }
        }
        catch (Exception e) {
            throw new ScheduleRuntimeException("Unable to read progress item name", (Throwable)e);
        }
        return settings;
    }

    protected void setTitleMetadataInfo() {
        String fieldNamePath = "//variable/name";
        String fieldTypePath = "//variable/type";
        try {
            Document document = this.getConfiguration();
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node fieldNameNode = (Node)xpath.evaluate(fieldNamePath, document, XPathConstants.NODE);
            Node fieldTypeNode = (Node)xpath.evaluate(fieldTypePath, document, XPathConstants.NODE);
            if (fieldNameNode == null || fieldTypeNode == null) {
                throw new ScheduleRuntimeException("Variable name and type must be specified.");
            }
            this.metadataFieldName = fieldNameNode.getTextContent();
            logger.debug((Object)("metadataFieldName " + this.metadataFieldName));
            this.metadataFieldType = fieldTypeNode.getTextContent();
            logger.debug((Object)("metadataFieldType " + this.metadataFieldType));
        }
        catch (Exception e) {
            throw new ScheduleRuntimeException("Unable to read metadata field name", (Throwable)e);
        }
    }

    protected Document getConfiguration() throws Exception {
        String dir = System.getProperty(PRODUCT_DIR) + File.separator + "conf";
        String path = dir + File.separator + PMM_CONFIG_DIR + File.separator + "progress.xml";
        File file = new File(path);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        return document;
    }

    protected abstract boolean isTitleDelayed(Title var1, Schedule var2, String var3);

    private static final /* synthetic */ Notification getNotification_aroundBody0(AbstractNotificationGenerator this_, Schedule schedule) {
        if (schedule.getTitles().isEmpty()) {
            return null;
        }
        Notification notification = null;
        for (NotificationSetting setting : this_.getSettings()) {
            int delta = setting.offset;
            String status = setting.status;
            Date deadline = this_.diff(schedule.getDate(), delta);
            logger.debug((Object)("Deadline " + deadline));
            if (deadline.after(this_.getToday())) {
                logger.debug((Object)(schedule + ", is after cutoff date for status " + status));
                continue;
            }
            boolean warn = false;
            HashSet<Title> titles = new HashSet<Title>();
            for (Title title : schedule.getTitles()) {
                if (!this_.isTitleDelayed(title, schedule, status)) continue;
                logger.debug((Object)("Adding notification for " + schedule + ", title " + title));
                if (notification == null) {
                    notification = new Notification(schedule);
                }
                notification.addTitle(title);
                titles.add(title);
                warn = true;
            }
            if (!warn) continue;
            this_.addMessage(notification, status, titles);
        }
        return notification;
    }

    private static final /* synthetic */ Object getNotification_aroundBody1$advice(AbstractNotificationGenerator this_, Schedule schedule, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return AbstractNotificationGenerator.getNotification_aroundBody0(this_, schedule);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Notification object = AbstractNotificationGenerator.getNotification_aroundBody0(this_, schedule);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ String constructMessage_aroundBody2(AbstractNotificationGenerator this_, String status, Collection titles) {
        String message = "";
        if (this_.metadataFieldName == null || this_.metadataFieldType == null) {
            return null;
        }
        for (Title title : titles) {
            Asset asset = title.getAsset();
            List fields = asset.getAllFieldsForXpath(this_.metadataFieldType, this_.metadataFieldName);
            if (fields.isEmpty()) continue;
            String value = ((Field)fields.get(0)).getValue();
            if (value == null || value.length() == 0) {
                value = title.getId().toString();
            }
            if (message.length() > 0) {
                message = message + ", ";
            }
            message = message + value;
        }
        return message;
    }

    private static final /* synthetic */ Object constructMessage_aroundBody3$advice(AbstractNotificationGenerator this_, String status, Collection titles, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return AbstractNotificationGenerator.constructMessage_aroundBody2(this_, status, titles);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            String object = AbstractNotificationGenerator.constructMessage_aroundBody2(this_, status, titles);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

