/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.search;

import com.tandbergtv.watchpoint.pmm.assetlist.AssetListSearchService;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;

public class ScheduleSearchService
extends AssetListSearchService<Schedule>
implements IScheduleSearchService {
    public ScheduleSearchService() {
        super("Schedule Search");
    }

    private <T extends Schedule> Collection<T> searchSchedules(SearchCriteria criteria) {
        Collection schedules = super.search(criteria);
        return schedules;
    }

    public Collection<Planner> getPlannersByDateRange(Long partnerId, Date start, Date end) {
        if (start == null && end == null) {
            throw new ScheduleRuntimeException("At least one bound of the interval must be specified");
        }
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("planner", Planner.class, "p");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.PARTNER_ID.toString(), SearchType.NUMERIC, (Object)partnerId));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE);
        if (start != null) {
            range.setTo(formatter.format(start));
        }
        if (end != null) {
            range.setTo(formatter.format(end));
        }
        e.addParameter((SearchParameterBase)range);
        criteria.addParameter((SearchParameterBase)e);
        return this.searchSchedules(criteria);
    }

    public Collection<Planner> getPlannersByDate(Long partnerId, Date date) {
        if (date == null) {
            throw new ScheduleRuntimeException("Planner arrival date must be specified");
        }
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("planner", Planner.class, "p");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.PARTNER_ID.toString(), SearchType.NUMERIC, (Object)partnerId));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, (Object)formatter.format(date)));
        criteria.addParameter((SearchParameterBase)e);
        return this.searchSchedules(criteria);
    }

    public Collection<DistributionSchedule> getPitchSchedulesByDateRange(Long contextId, Date start, Date end) {
        if (start == null && end == null) {
            throw new ScheduleRuntimeException("At least one bound of the interval must be specified");
        }
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        this.addDateCriterion(e, start, end);
        criteria.addParameter((SearchParameterBase)e);
        return this.searchSchedules(criteria);
    }

    public Collection<DistributionSchedule> getPitchSchedulesByPitchDate(Long contextId, Date date) {
        if (date == null) {
            throw new ScheduleRuntimeException("Pitch date must be specified");
        }
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        this.addDateCriterion(e, date, null);
        criteria.addParameter((SearchParameterBase)e);
        return this.searchSchedules(criteria);
    }

    public Collection<DistributionSchedule> getPitchSchedulesByPitchDate(Long contextId, Date date, ScheduleStatus ... status) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        this.addDateCriterion(e, date, null);
        ListParameter scheduleList = new ListParameter(ScheduleSearchKey.STATUS.toString(), SearchType.NUMERIC);
        Object[] statusOrdinals = new Object[status.length];
        for (int i = 0; i < status.length; ++i) {
            statusOrdinals[i] = status[i].ordinal();
        }
        scheduleList.addValues(statusOrdinals);
        e.addParameter((SearchParameterBase)scheduleList);
        criteria.addParameter((SearchParameterBase)e);
        return this.searchSchedules(criteria);
    }

    public <T extends Schedule> T getPreviousSchedule(T schedule) {
        Collection<T> schedules = this.getPreviousSchedules(schedule, 1);
        if (schedules == null || schedules.isEmpty()) {
            return null;
        }
        return schedules.iterator().next();
    }

    public <T extends Schedule> Collection<T> getPreviousSchedules(T schedule, int count) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", schedule.getClass(), "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        if (schedule instanceof Planner) {
            Planner planner = (Planner)Planner.class.cast(schedule);
            e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.PARTNER_ID.toString(), SearchType.NUMERIC, (Object)planner.getSourcePartnerID()));
        } else if (schedule instanceof DistributionSchedule) {
            DistributionSchedule pitch = (DistributionSchedule)DistributionSchedule.class.cast(schedule);
            e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)pitch.getContextID()));
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE);
        Date to = this.decrementDay(schedule.getDate());
        range.setTo(formatter.format(to));
        e.addParameter((SearchParameterBase)range);
        e.addParameter((SearchParameterBase)new SortParameter(ScheduleSearchKey.PITCH_DATE.toString(), SortingOrder.DESCENDING));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setRecordsCount(count);
        Collection<T> schedules = this.searchSchedules(criteria);
        return schedules;
    }

    private void addDateCriterion(Entity e, Date start, Date end) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (end != null) {
            RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, formatter.format(start));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(end);
            calendar.add(5, -1);
            range.setTo(formatter.format(calendar.getTime()));
            e.addParameter((SearchParameterBase)range);
        } else {
            ValueParameter parameter = new ValueParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, (Object)new SimpleDateFormat("yyyy-MM-dd").format(start));
            e.addParameter((SearchParameterBase)parameter);
        }
    }

    private Date decrementDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, -1);
        return calendar.getTime();
    }

    public Long findEarliestUpcomingPlannerId(Title title) {
        ArrayList<Schedule> upcomingPlanners = new ArrayList<Schedule>();
        Date now = this.getToday();
        Collection associatedAssetLists = title.getTitlelists();
        if (associatedAssetLists != null) {
            for (IAssetList associatedAssetList : associatedAssetLists) {
                Schedule associatedPlanner;
                if (associatedAssetList.getType() != TitleListType.PLANNER || (associatedPlanner = (Schedule)associatedAssetList).getDate().compareTo(now) < 0) continue;
                upcomingPlanners.add(associatedPlanner);
            }
        }
        if (upcomingPlanners.isEmpty()) {
            return null;
        }
        Collections.sort(upcomingPlanners, new Comparator<Schedule>(){

            @Override
            public int compare(Schedule o1, Schedule o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        return ((Schedule)upcomingPlanners.get(0)).getId();
    }

    public Long findPastPlannerId(Title title) {
        ArrayList<Schedule> pastPlanners = new ArrayList<Schedule>();
        Date now = this.getToday();
        Collection associatedAssetLists = title.getTitlelists();
        if (associatedAssetLists != null) {
            for (IAssetList associatedAssetList : associatedAssetLists) {
                Schedule associatedPlanner;
                if (associatedAssetList.getType() != TitleListType.PLANNER || (associatedPlanner = (Schedule)associatedAssetList).getDate().compareTo(now) > 0) continue;
                pastPlanners.add(associatedPlanner);
            }
        }
        if (pastPlanners.isEmpty()) {
            return null;
        }
        Collections.sort(pastPlanners, new Comparator<Schedule>(){

            @Override
            public int compare(Schedule o1, Schedule o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        return ((Schedule)pastPlanners.get(pastPlanners.size() - 1)).getId();
    }

    private Date getToday() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }
}

