/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.ProgressManager;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleStatusService
implements ITitleStatusService {
    private ProgressManager progressManager = ProgressManager.newInstance();
    private SpecificationManager specManager = (SpecificationManager)ServiceRegistry.getDefault().lookup(SpecificationManager.class);
    private String defaultSpec;
    private String SPECIFICATION = "specification";
    private static final Logger logger = Logger.getLogger(TitleStatusService.class);

    public TitleStatusService() {
        try {
            this.defaultSpec = PMMProperties.getInstance().getProperty(this.SPECIFICATION);
            logger.debug((Object)("defaultSpec = " + this.defaultSpec));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Transactional
    public void sendAssetReceivedStatus(Title rootTitle, String titleName, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        String string = titleName;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TitleStatusService.sendAssetReceivedStatus_aroundBody1$advice(this, title, string, string2, string3, string4, TransactionEnforcer.aspectOf(), TitleStatusService.class.getDeclaredMethod("sendAssetReceivedStatus", Title.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void sendAssetReceivedStatus(Title rootTitle, String titleName, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        String string = titleName;
        Long l = plannerId;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TitleStatusService.sendAssetReceivedStatus_aroundBody3$advice(this, title, string, l, string2, string3, string4, TransactionEnforcer.aspectOf(), TitleStatusService.class.getDeclaredMethod("sendAssetReceivedStatus", Title.class, String.class, Long.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void sendMetadataReceivedStatus(Title rootTitle, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        TitleStatusService.sendMetadataReceivedStatus_aroundBody5$advice(this, title, string, string2, string3, TransactionEnforcer.aspectOf(), TitleStatusService.class.getDeclaredMethod("sendMetadataReceivedStatus", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void sendMetadataReceivedStatus(Title rootTitle, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        Long l = plannerId;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        TitleStatusService.sendMetadataReceivedStatus_aroundBody7$advice(this, title, l, string, string2, string3, TransactionEnforcer.aspectOf(), TitleStatusService.class.getDeclaredMethod("sendMetadataReceivedStatus", Title.class, Long.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void sendStatus(Title title, String statusName, String statusValue, boolean success, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title2 = title;
        String string = statusName;
        String string2 = statusValue;
        boolean bl = success;
        String string3 = sourceComponentName;
        String string4 = sourceEntityName;
        String string5 = sourceId;
        TitleStatusService.sendStatus_aroundBody9$advice(this, title2, string, string2, bl, string3, string4, string5, TransactionEnforcer.aspectOf(), TitleStatusService.class.getDeclaredMethod("sendStatus", Title.class, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void updateTitleStatus(Title rootTitle) {
        Title title = rootTitle;
        TitleStatusService.updateTitleStatus_aroundBody11$advice(this, title, TransactionEnforcer.aspectOf(), TitleStatusService.class.getDeclaredMethod("updateTitleStatus", Title.class).getAnnotation(Transactional.class), null);
    }

    private boolean hasAsset(Asset sectionAsset) {
        Specification spec = this.specManager.getSpecificationByName(this.defaultSpec);
        TitleConf section = spec.getTitleConfByName(sectionAsset.getAssetType());
        if (section != null) {
            return section.isHasAsset();
        }
        return false;
    }

    private boolean containsValue(String s) {
        return s != null && s.trim().length() > 0;
    }

    private boolean hasOriginalFile(Asset asset) {
        List files = asset.getChildrenOfType(File.class);
        if (files != null) {
            for (File file : files) {
                if (!file.isOriginal()) continue;
                return true;
            }
        }
        return false;
    }

    private static final /* synthetic */ void sendAssetReceivedStatus_aroundBody0(TitleStatusService this_, Title rootTitle, String titleName, String sourceComponentName, String sourceEntityName, String sourceId) {
        IScheduleSearchService scheduleSearchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Long plannerId = scheduleSearchService.findEarliestUpcomingPlannerId(rootTitle);
        if (plannerId == null) {
            plannerId = scheduleSearchService.findPastPlannerId(rootTitle);
        }
        this_.sendAssetReceivedStatus(rootTitle, titleName, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private static final /* synthetic */ Object sendAssetReceivedStatus_aroundBody1$advice(TitleStatusService this_, Title rootTitle, String titleName, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendAssetReceivedStatus_aroundBody0(this_, rootTitle, titleName, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendAssetReceivedStatus_aroundBody0(this_, rootTitle, titleName, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void sendAssetReceivedStatus_aroundBody2(TitleStatusService this_, Title rootTitle, String titleName, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String statusName = ProgressStatusHelper.getAssetReceivedStatusName(titleName);
        String statusValue = ProgressStatusHelper.getAssetReceivedStatusValue(titleName);
        if (statusName != null) {
            this_.progressManager.updateStatus(rootTitle, plannerId, statusName, statusValue, true, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private static final /* synthetic */ Object sendAssetReceivedStatus_aroundBody3$advice(TitleStatusService this_, Title rootTitle, String titleName, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendAssetReceivedStatus_aroundBody2(this_, rootTitle, titleName, plannerId, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendAssetReceivedStatus_aroundBody2(this_, rootTitle, titleName, plannerId, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void sendMetadataReceivedStatus_aroundBody4(TitleStatusService this_, Title rootTitle, String sourceComponentName, String sourceEntityName, String sourceId) {
        IScheduleSearchService scheduleSearchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Long plannerId = scheduleSearchService.findEarliestUpcomingPlannerId(rootTitle);
        if (plannerId == null) {
            plannerId = scheduleSearchService.findPastPlannerId(rootTitle);
        }
        this_.sendMetadataReceivedStatus(rootTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private static final /* synthetic */ Object sendMetadataReceivedStatus_aroundBody5$advice(TitleStatusService this_, Title rootTitle, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendMetadataReceivedStatus_aroundBody4(this_, rootTitle, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendMetadataReceivedStatus_aroundBody4(this_, rootTitle, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void sendMetadataReceivedStatus_aroundBody6(TitleStatusService this_, Title rootTitle, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String statusName = ProgressStatusHelper.getMetadataReceivedStatusName();
        String statusValue = ProgressStatusHelper.getMetadataReceivedValue();
        if (statusName != null) {
            this_.progressManager.updateStatus(rootTitle, plannerId, statusName, statusValue, true, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private static final /* synthetic */ Object sendMetadataReceivedStatus_aroundBody7$advice(TitleStatusService this_, Title rootTitle, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendMetadataReceivedStatus_aroundBody6(this_, rootTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendMetadataReceivedStatus_aroundBody6(this_, rootTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void sendStatus_aroundBody8(TitleStatusService this_, Title title, String statusName, String statusValue, boolean success, String sourceComponentName, String sourceEntityName, String sourceId) {
        IScheduleSearchService scheduleSearchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Long plannerId = scheduleSearchService.findEarliestUpcomingPlannerId(title);
        if (plannerId == null) {
            plannerId = scheduleSearchService.findPastPlannerId(title);
        }
        this_.progressManager.updateStatus(title, plannerId, statusName, statusValue, success, sourceComponentName, sourceEntityName, sourceId);
    }

    private static final /* synthetic */ Object sendStatus_aroundBody9$advice(TitleStatusService this_, Title title, String statusName, String statusValue, boolean success, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendStatus_aroundBody8(this_, title, statusName, statusValue, success, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendStatus_aroundBody8(this_, title, statusName, statusValue, success, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void updateTitleStatus_aroundBody10(TitleStatusService this_, Title rootTitle) {
        Asset rootAsset = rootTitle.getAsset();
        if (rootTitle.getStatus() == TitleStatus.APPROVED) {
            return;
        }
        if (this_.containsValue(rootTitle.getExternalLocation())) {
            rootTitle.setStatus(TitleStatus.READY);
            return;
        }
        rootTitle.setStatus(TitleStatus.COMMITTED);
        for (Asset sectionAsset : rootAsset.getAllAssets(false)) {
            if (!this_.hasAsset(sectionAsset)) continue;
            if (TitleUtil.getFileName(sectionAsset) != null) {
                if (this_.hasOriginalFile(sectionAsset)) continue;
                return;
            }
            return;
        }
        rootTitle.setStatus(TitleStatus.READY);
    }

    private static final /* synthetic */ Object updateTitleStatus_aroundBody11$advice(TitleStatusService this_, Title rootTitle, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.updateTitleStatus_aroundBody10(this_, rootTitle);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.updateTitleStatus_aroundBody10(this_, rootTitle);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

