/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.activity;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.entities.activity.ITitleActivity;
import com.tandbergtv.watchpoint.pmm.entities.activity.ITitleActivitySearchCriteria;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivity;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivitySearchCriteria;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivitySortField;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivityType;
import com.tandbergtv.watchpoint.pmm.title.ITitleActivityService;
import com.tandbergtv.watchpoint.pmm.title.activity.TitleKeysParameter;
import com.tandbergtv.watchpoint.pmm.title.template.TitleVariableProvider;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleActivityService
implements ITitleActivityService {
    private static final String PROVIDER_ID = "providerId";
    private static final String SERVICE_NAME = "Title Activity Service";
    private static final String PROCESS_ID_FIELD = "id";
    private static final String WO_END_DATE_FIELD = "end";

    @Transactional
    public List<ITitleActivity> getActivity(long titleId) {
        long l = titleId;
        return (List)TitleActivityService.getActivity_aroundBody1$advice(this, l, TransactionEnforcer.aspectOf(), TitleActivityService.class.getDeclaredMethod("getActivity", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<ITitleActivity> getActivity(long titleId, TitleActivityType activityType) {
        long l = titleId;
        TitleActivityType titleActivityType = activityType;
        return (List)TitleActivityService.getActivity_aroundBody3$advice(this, l, titleActivityType, TransactionEnforcer.aspectOf(), TitleActivityService.class.getDeclaredMethod("getActivity", Long.TYPE, TitleActivityType.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<ITitleActivity> getActivity(ITitleActivitySearchCriteria criteria) {
        ITitleActivitySearchCriteria iTitleActivitySearchCriteria = criteria;
        return (List)TitleActivityService.getActivity_aroundBody5$advice(this, iTitleActivitySearchCriteria, TransactionEnforcer.aspectOf(), TitleActivityService.class.getDeclaredMethod("getActivity", ITitleActivitySearchCriteria.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long countActivity(long titleId) {
        long l = titleId;
        return (Long)TitleActivityService.countActivity_aroundBody7$advice(this, l, TransactionEnforcer.aspectOf(), TitleActivityService.class.getDeclaredMethod("countActivity", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long countActivity(long titleId, TitleActivityType activityType) {
        long l = titleId;
        TitleActivityType titleActivityType = activityType;
        return (Long)TitleActivityService.countActivity_aroundBody9$advice(this, l, titleActivityType, TransactionEnforcer.aspectOf(), TitleActivityService.class.getDeclaredMethod("countActivity", Long.TYPE, TitleActivityType.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long countActivity(ITitleActivitySearchCriteria criteria) {
        ITitleActivitySearchCriteria iTitleActivitySearchCriteria = criteria;
        return (Long)TitleActivityService.countActivity_aroundBody11$advice(this, iTitleActivitySearchCriteria, TransactionEnforcer.aspectOf(), TitleActivityService.class.getDeclaredMethod("countActivity", ITitleActivitySearchCriteria.class).getAnnotation(Transactional.class), null);
    }

    private SearchCriteria buildSearchCriteria(ITitleActivitySearchCriteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("The criteria cannot be null.");
        }
        SearchCriteria processCriteria = new SearchCriteria();
        if (!criteria.getProviderIds().isEmpty()) {
            processCriteria.addParameter(this.getParameter(criteria.getProviderIds()));
        }
        if (!this.addTitleKeyCriteria(processCriteria, criteria)) {
            return null;
        }
        this.addProcessStatusCriteria(processCriteria, criteria);
        this.addSortCriteria(processCriteria, criteria);
        if (criteria.getStartRecord() != null) {
            processCriteria.setStartingRecordNumber(criteria.getStartRecord().intValue());
        }
        if (criteria.getRecordCount() != null) {
            processCriteria.setRecordsCount(criteria.getRecordCount().intValue());
        }
        return processCriteria;
    }

    private SearchParameterBase getParameter(Collection<String> providerIds) {
        ListParameter parameter = new ListParameter(PROVIDER_ID, SearchType.STRING, SearchOperator.IN, true);
        for (String providerId : providerIds) {
            parameter.addValue((Object)providerId);
        }
        return parameter;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    private IProcessSearchService getProcessSearchService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }

    private boolean addTitleKeyCriteria(SearchCriteria processCriteria, ITitleActivitySearchCriteria criteria) {
        Set<String> variables = this.getTitleKeyVariableNames();
        if (variables == null || variables.size() == 0) {
            return false;
        }
        TitleKeysParameter parameter = new TitleKeysParameter(variables, criteria.getTitleIDs());
        processCriteria.addParameter((SearchParameterBase)parameter);
        return true;
    }

    private Set<String> getTitleKeyVariableNames() {
        Collection<String> names = TitleVariableProvider.getInstance().getVariableNames();
        return names != null ? new HashSet<String>(names) : new HashSet();
    }

    private void addProcessStatusCriteria(SearchCriteria processCriteria, ITitleActivitySearchCriteria criteria) {
        Set activityTypes = criteria.getActivityTypes();
        if (this.hasAllActivityTypes(activityTypes)) {
            return;
        }
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        for (TitleActivityType activityType : activityTypes) {
            Set<ProcessStatus> values = this.getProcessStatusValues(activityType);
            for (ProcessStatus processStatus : values) {
                parameter.addValue((Object)processStatus);
            }
        }
        processCriteria.addParameter((SearchParameterBase)parameter);
    }

    private boolean hasAllActivityTypes(Set<TitleActivityType> activityTypes) {
        if (activityTypes == null || activityTypes.size() == 0) {
            return true;
        }
        for (TitleActivityType activityType : TitleActivityType.values()) {
            if (activityTypes.contains(activityType)) continue;
            return false;
        }
        return true;
    }

    private Set<ProcessStatus> getProcessStatusValues(TitleActivityType activityType) {
        HashSet<ProcessStatus> values = new HashSet<ProcessStatus>();
        switch (activityType) {
            case CURRENT: {
                values.add(ProcessStatus.BRANCHED);
                values.add(ProcessStatus.BUSY);
                values.add(ProcessStatus.CREATED);
                values.add(ProcessStatus.ERROR);
                values.add(ProcessStatus.PAUSED);
                values.add(ProcessStatus.QUEUED);
                values.add(ProcessStatus.RUNNING);
                break;
            }
            case HISTORICAL: {
                values.add(ProcessStatus.CANCELLED);
                values.add(ProcessStatus.COMPLETED);
            }
        }
        return values;
    }

    private void addSortCriteria(SearchCriteria processCriteria, ITitleActivitySearchCriteria criteria) {
        TitleActivitySortField sortField = criteria.getSortField();
        if (sortField == null) {
            sortField = TitleActivitySortField.ACTIVITY_START_TIME;
        }
        String fieldName = null;
        switch (sortField) {
            case ACTIVITY_START_TIME: {
                fieldName = "start";
                break;
            }
            case ACTIVITY_END_TIME: {
                fieldName = WO_END_DATE_FIELD;
            }
        }
        processCriteria.addParameter((SearchParameterBase)new SortParameter(fieldName, SortingOrder.DESCENDING));
        processCriteria.addParameter((SearchParameterBase)new SortParameter(PROCESS_ID_FIELD, SortingOrder.DESCENDING));
    }

    private List<ITitleActivity> convertToTitleActivity(List<WorkflowProcess> result) {
        ArrayList<ITitleActivity> activity = new ArrayList<ITitleActivity>();
        if (result != null) {
            for (WorkflowProcess process : result) {
                Long titleKey = this.getTitleKey(process);
                TitleActivityType activityType = this.determineActivityType(process);
                activity.add((ITitleActivity)new TitleActivity(titleKey, process, activityType));
            }
        }
        return activity;
    }

    private Long getTitleKey(WorkflowProcess process) {
        Long titleKey = null;
        Set<String> variables = this.getTitleKeyVariableNames();
        for (String variableName : variables) {
            Object value = process.getContextInstance().getVariable(variableName);
            if (value == null || value.toString().length() <= 0) continue;
            try {
                titleKey = Long.parseLong(value.toString());
            }
            catch (NumberFormatException nfe) {}
            break;
        }
        return titleKey;
    }

    private TitleActivityType determineActivityType(WorkflowProcess process) {
        TitleActivityType activityType = null;
        ProcessStatus status = process.getRootToken().getStatus();
        switch (status) {
            case CANCELLED: 
            case COMPLETED: {
                activityType = TitleActivityType.HISTORICAL;
                break;
            }
            default: {
                activityType = TitleActivityType.CURRENT;
            }
        }
        return activityType;
    }

    private static final /* synthetic */ List getActivity_aroundBody0(TitleActivityService this_, long titleId) {
        TitleActivitySearchCriteria criteria = new TitleActivitySearchCriteria();
        criteria.addTitleID(titleId);
        return this_.getActivity((ITitleActivitySearchCriteria)criteria);
    }

    private static final /* synthetic */ Object getActivity_aroundBody1$advice(TitleActivityService this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleActivityService.getActivity_aroundBody0(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleActivityService.getActivity_aroundBody0(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List getActivity_aroundBody2(TitleActivityService this_, long titleId, TitleActivityType activityType) {
        if (activityType == null) {
            throw new IllegalArgumentException("The activityType cannot be null.");
        }
        TitleActivitySearchCriteria criteria = new TitleActivitySearchCriteria();
        criteria.addTitleID(titleId);
        criteria.addActivityType(activityType);
        return this_.getActivity((ITitleActivitySearchCriteria)criteria);
    }

    private static final /* synthetic */ Object getActivity_aroundBody3$advice(TitleActivityService this_, long titleId, TitleActivityType activityType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleActivityService.getActivity_aroundBody2(this_, titleId, activityType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleActivityService.getActivity_aroundBody2(this_, titleId, activityType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List getActivity_aroundBody4(TitleActivityService this_, ITitleActivitySearchCriteria criteria) {
        IProcessSearchService searchService = this_.getProcessSearchService();
        if (searchService == null) {
            return new ArrayList();
        }
        SearchCriteria processCriteria = this_.buildSearchCriteria(criteria);
        if (processCriteria == null) {
            return new ArrayList();
        }
        List result = searchService.search(processCriteria);
        return this_.convertToTitleActivity(result);
    }

    private static final /* synthetic */ Object getActivity_aroundBody5$advice(TitleActivityService this_, ITitleActivitySearchCriteria criteria, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleActivityService.getActivity_aroundBody4(this_, criteria);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleActivityService.getActivity_aroundBody4(this_, criteria);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Long countActivity_aroundBody6(TitleActivityService this_, long titleId) {
        TitleActivitySearchCriteria criteria = new TitleActivitySearchCriteria();
        criteria.addTitleID(titleId);
        return this_.countActivity((ITitleActivitySearchCriteria)criteria);
    }

    private static final /* synthetic */ Object countActivity_aroundBody7$advice(TitleActivityService this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleActivityService.countActivity_aroundBody6(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = TitleActivityService.countActivity_aroundBody6(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Long countActivity_aroundBody8(TitleActivityService this_, long titleId, TitleActivityType activityType) {
        if (activityType == null) {
            throw new IllegalArgumentException("The activityType cannot be null.");
        }
        TitleActivitySearchCriteria criteria = new TitleActivitySearchCriteria();
        criteria.addTitleID(titleId);
        criteria.addActivityType(activityType);
        return this_.countActivity((ITitleActivitySearchCriteria)criteria);
    }

    private static final /* synthetic */ Object countActivity_aroundBody9$advice(TitleActivityService this_, long titleId, TitleActivityType activityType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleActivityService.countActivity_aroundBody8(this_, titleId, activityType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = TitleActivityService.countActivity_aroundBody8(this_, titleId, activityType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Long countActivity_aroundBody10(TitleActivityService this_, ITitleActivitySearchCriteria criteria) {
        IProcessSearchService searchService = this_.getProcessSearchService();
        if (searchService == null) {
            return 0L;
        }
        SearchCriteria processCriteria = this_.buildSearchCriteria(criteria);
        if (processCriteria == null) {
            return 0L;
        }
        return new Long(searchService.count(processCriteria));
    }

    private static final /* synthetic */ Object countActivity_aroundBody11$advice(TitleActivityService this_, ITitleActivitySearchCriteria criteria, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleActivityService.countActivity_aroundBody10(this_, criteria);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = TitleActivityService.countActivity_aroundBody10(this_, criteria);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

