/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.compare;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.compare.ITitleCompareReport;
import com.tandbergtv.watchpoint.pmm.title.ITitleCompareService;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.compare.TitleComparator;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;

public class TitleCompareService
implements ITitleCompareService {
    private static final String SERVICE_NAME = "Title Compare Service";
    private ITitleManager titleManager;
    private ITitleCopyService titleCopyService;

    public ITitleCompareReport compareTitles(Title title1, Title title2) {
        TitleComparator comparator = new TitleComparator();
        return comparator.compare(title1, title2);
    }

    @Transactional
    public ITitleCompareReport compareTitleWithVersion(long titleId, String version) {
        long l = titleId;
        String string = version;
        return (ITitleCompareReport)TitleCompareService.compareTitleWithVersion_aroundBody1$advice(this, l, string, TransactionEnforcer.aspectOf(), TitleCompareService.class.getDeclaredMethod("compareTitleWithVersion", Long.TYPE, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public ITitleCompareReport compareTitleVersions(long titleId, String version1, String version2) {
        long l = titleId;
        String string = version1;
        String string2 = version2;
        return (ITitleCompareReport)TitleCompareService.compareTitleVersions_aroundBody3$advice(this, l, string, string2, TransactionEnforcer.aspectOf(), TitleCompareService.class.getDeclaredMethod("compareTitleVersions", Long.TYPE, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public ITitleCompareReport compareTitleWithCopy(long copiedTitleId) {
        long l = copiedTitleId;
        return (ITitleCompareReport)TitleCompareService.compareTitleWithCopy_aroundBody5$advice(this, l, TransactionEnforcer.aspectOf(), TitleCompareService.class.getDeclaredMethod("compareTitleWithCopy", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    public boolean areTitlesDifferent(Title title1, Title title2) {
        TitleComparator comparator = new TitleComparator();
        return comparator.isDifferent(title1, title2);
    }

    @Transactional
    public boolean isTitleDifferentFromVersion(long titleId, String version) {
        long l = titleId;
        String string = version;
        return Conversions.booleanValue((Object)TitleCompareService.isTitleDifferentFromVersion_aroundBody7$advice(this, l, string, TransactionEnforcer.aspectOf(), TitleCompareService.class.getDeclaredMethod("isTitleDifferentFromVersion", Long.TYPE, String.class).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public boolean areTitleVersionsDifferent(long titleId, String version1, String version2) {
        long l = titleId;
        String string = version1;
        String string2 = version2;
        return Conversions.booleanValue((Object)TitleCompareService.areTitleVersionsDifferent_aroundBody9$advice(this, l, string, string2, TransactionEnforcer.aspectOf(), TitleCompareService.class.getDeclaredMethod("areTitleVersionsDifferent", Long.TYPE, String.class, String.class).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public boolean isTitleDifferentFromCopy(long copiedTitleId) {
        long l = copiedTitleId;
        return Conversions.booleanValue((Object)TitleCompareService.isTitleDifferentFromCopy_aroundBody11$advice(this, l, TransactionEnforcer.aspectOf(), TitleCompareService.class.getDeclaredMethod("isTitleDifferentFromCopy", Long.TYPE).getAnnotation(Transactional.class), null));
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titleManager = this.getService(ITitleManager.class);
        this.titleCopyService = this.getService(ITitleCopyService.class);
    }

    public void stop() {
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (T)((Service)registry.lookup(serviceClass));
    }

    private static final /* synthetic */ ITitleCompareReport compareTitleWithVersion_aroundBody0(TitleCompareService this_, long titleId, String version) {
        Title originalTitle = this_.titleManager.get(Long.valueOf(titleId));
        Title versionedTitle = this_.titleManager.get(Long.valueOf(titleId), version);
        return this_.compareTitles(originalTitle, versionedTitle);
    }

    private static final /* synthetic */ Object compareTitleWithVersion_aroundBody1$advice(TitleCompareService this_, long titleId, String version, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleCompareService.compareTitleWithVersion_aroundBody0(this_, titleId, version);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ITitleCompareReport object = TitleCompareService.compareTitleWithVersion_aroundBody0(this_, titleId, version);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ ITitleCompareReport compareTitleVersions_aroundBody2(TitleCompareService this_, long titleId, String version1, String version2) {
        Title versionedTitle1 = this_.titleManager.get(Long.valueOf(titleId), version1);
        Title versionedTitle2 = this_.titleManager.get(Long.valueOf(titleId), version2);
        return this_.compareTitles(versionedTitle1, versionedTitle2);
    }

    private static final /* synthetic */ Object compareTitleVersions_aroundBody3$advice(TitleCompareService this_, long titleId, String version1, String version2, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleCompareService.compareTitleVersions_aroundBody2(this_, titleId, version1, version2);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ITitleCompareReport object = TitleCompareService.compareTitleVersions_aroundBody2(this_, titleId, version1, version2);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ ITitleCompareReport compareTitleWithCopy_aroundBody4(TitleCompareService this_, long copiedTitleId) {
        Title copy = this_.titleManager.get(Long.valueOf(copiedTitleId));
        Title original = this_.titleCopyService.getOriginalTitle(copiedTitleId);
        return this_.compareTitles(original, copy);
    }

    private static final /* synthetic */ Object compareTitleWithCopy_aroundBody5$advice(TitleCompareService this_, long copiedTitleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleCompareService.compareTitleWithCopy_aroundBody4(this_, copiedTitleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ITitleCompareReport object = TitleCompareService.compareTitleWithCopy_aroundBody4(this_, copiedTitleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ boolean isTitleDifferentFromVersion_aroundBody6(TitleCompareService this_, long titleId, String version) {
        Title originalTitle = this_.titleManager.get(Long.valueOf(titleId));
        Title versionedTitle = this_.titleManager.get(Long.valueOf(titleId), version);
        return this_.areTitlesDifferent(originalTitle, versionedTitle);
    }

    private static final /* synthetic */ Object isTitleDifferentFromVersion_aroundBody7$advice(TitleCompareService this_, long titleId, String version, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleCompareService.isTitleDifferentFromVersion_aroundBody6(this_, titleId, version));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleCompareService.isTitleDifferentFromVersion_aroundBody6(this_, titleId, version));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ boolean areTitleVersionsDifferent_aroundBody8(TitleCompareService this_, long titleId, String version1, String version2) {
        Title versionedTitle1 = this_.titleManager.get(Long.valueOf(titleId), version1);
        Title versionedTitle2 = this_.titleManager.get(Long.valueOf(titleId), version2);
        return this_.areTitlesDifferent(versionedTitle1, versionedTitle2);
    }

    private static final /* synthetic */ Object areTitleVersionsDifferent_aroundBody9$advice(TitleCompareService this_, long titleId, String version1, String version2, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleCompareService.areTitleVersionsDifferent_aroundBody8(this_, titleId, version1, version2));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleCompareService.areTitleVersionsDifferent_aroundBody8(this_, titleId, version1, version2));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ boolean isTitleDifferentFromCopy_aroundBody10(TitleCompareService this_, long copiedTitleId) {
        Title copy = this_.titleManager.get(Long.valueOf(copiedTitleId));
        Title original = this_.titleCopyService.getOriginalTitle(copiedTitleId);
        return this_.areTitlesDifferent(original, copy);
    }

    private static final /* synthetic */ Object isTitleDifferentFromCopy_aroundBody11$advice(TitleCompareService this_, long copiedTitleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleCompareService.isTitleDifferentFromCopy_aroundBody10(this_, copiedTitleId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleCompareService.isTitleDifferentFromCopy_aroundBody10(this_, copiedTitleId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

