/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.AssetTypes;
import com.tandbergtv.watchpoint.pmm.title.conf.IAssetTypesConfigurationService;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AssetTypesConfigurationService
implements IAssetTypesConfigurationService {
    private static final Logger logger = Logger.getLogger(AssetTypesConfigurationService.class);
    private static final String SERVICE_NAME = "Asset Types Configuration Service";
    private static final String PROPERTY_KEY_IMAGE_ASSET_TYPES = "imageAssetTypes";
    private static final String PROPERTY_KEY_VIDEO_ASSET_TYPES = "videoAssetTypes";
    private static final String PROPERTY_KEY_THUMBNAIL_ASSET_TYPES = "thumbnailAssetTypes";
    private boolean started = false;

    private AssetTypesConfigurationService() {
    }

    public static AssetTypesConfigurationService newInstance() {
        return new AssetTypesConfigurationService();
    }

    public List<String> getImageAssetTypes() {
        return this.splitValues(this.getImageAssetTypesValue());
    }

    public List<String> getVideoAssetTypes() {
        return this.splitValues(this.getVideoAssetTypesValue());
    }

    public List<String> getThumbnailAssetTypes() {
        return this.splitValues(this.getThumbnailAssetTypesValue());
    }

    public String getImageAssetTypesValue() {
        return AssetTypes.getProperty(PROPERTY_KEY_IMAGE_ASSET_TYPES);
    }

    public String getVideoAssetTypesValue() {
        return AssetTypes.getProperty(PROPERTY_KEY_VIDEO_ASSET_TYPES);
    }

    public String getThumbnailAssetTypesValue() {
        return AssetTypes.getProperty(PROPERTY_KEY_THUMBNAIL_ASSET_TYPES);
    }

    private List<String> splitValues(String value) {
        ArrayList<String> values = new ArrayList<String>();
        if (value == null) {
            return values;
        }
        String[] valueArray = value.split(",");
        if (valueArray != null) {
            for (String splitValue : valueArray) {
                if (splitValue == null || (splitValue = splitValue.trim()).length() <= 0) continue;
                values.add(splitValue);
            }
        }
        return values;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        logger.info((Object)"Successfully started the AssetTypesConfigurationService.");
    }

    public void stop() {
        this.started = false;
    }
}

