/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SpecificationManager
implements ISpecificationManager {
    private static final Logger logger = Logger.getLogger(SpecificationManager.class);
    private static final String SERVICE_NAME = "Specification Manager";
    private static String SPECIFICATION_PROPERTY = "specification";
    private boolean started = false;
    private Collection<Specification> specs = new ArrayList<Specification>();

    private SpecificationManager() {
    }

    public static SpecificationManager newInstance() {
        return new SpecificationManager();
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        logger.info((Object)"Successfully started the Specification Manager.");
    }

    public synchronized void stop() {
        this.specs = new HashSet<Specification>();
        this.started = false;
    }

    public Collection<Specification> getAllSpecifications() {
        return this.specs;
    }

    public Specification getSpecificationByName(String name) {
        for (Specification s : this.specs) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public Specification getUISpecification() {
        Specification specification = null;
        if (this.specs.size() == 0) {
            throw new RuntimeException("No specifications exist.");
        }
        String spec = null;
        String configFilePath = "";
        try {
            spec = PMMProperties.getInstance().getProperty(SPECIFICATION_PROPERTY);
            configFilePath = PMMProperties.getPropertyFile().getAbsolutePath();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find configured specification: ", e);
        }
        if (spec == null || spec.trim().length() == 0) {
            logger.error((Object)("[Configuration Error] " + SPECIFICATION_PROPERTY + configFilePath + " value not defined"));
        }
        for (Specification s : this.specs) {
            if (!s.getName().equalsIgnoreCase(spec)) continue;
            specification = s;
            break;
        }
        if (specification == null && spec.trim().length() > 0) {
            String msg = "The default specification with name: " + spec + " does not exist.";
            logger.error((Object)("[Configuration Error] " + SPECIFICATION_PROPERTY + " " + configFilePath + " " + spec + " does not exist"));
            throw new RuntimeException(msg);
        }
        return specification;
    }

    public void addSpecification(Specification specification) {
        this.specs.add(specification);
    }
}

