/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IVariableOptionProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationValidationException;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.BooleanVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.ComplexVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.DateVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.FloatVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.IntegerVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.ParamType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.StringVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TimeVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;

class SpecificationReader {
    private static final String NAMESPACE_PREFIX = "tns:";
    private static final String PATH_SEPARATOR = "/";
    private static final String ATTRIBUTE = "@";
    private static final String ROOT_FIELD = "Fields";

    SpecificationReader() {
    }

    public com.tandbergtv.watchpoint.pmm.title.conf.Specification unmarshal(String filePath, ClassLoader classloader, ResourceBundle bundle) throws SpecificationValidationException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)(SpecificationReader.class.getPackage().getName() + ".jaxb"));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Specification jaxbSpec = (Specification)unmarshaller.unmarshal(new File(filePath));
            return this.convertToSpecification(jaxbSpec, classloader, bundle);
        }
        catch (JAXBException e) {
            throw new SpecificationValidationException((Throwable)e);
        }
    }

    public com.tandbergtv.watchpoint.pmm.title.conf.Specification unmarshal(InputStream stream, ClassLoader classloader, ResourceBundle bundle) throws SpecificationValidationException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)(SpecificationReader.class.getPackage().getName() + ".jaxb"));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Specification jaxbSpec = (Specification)unmarshaller.unmarshal(stream);
            return this.convertToSpecification(jaxbSpec, classloader, bundle);
        }
        catch (JAXBException e) {
            throw new SpecificationValidationException((Throwable)e);
        }
    }

    private com.tandbergtv.watchpoint.pmm.title.conf.Specification convertToSpecification(Specification jaxbSpec, ClassLoader classloader, ResourceBundle bundle) throws SpecificationValidationException {
        com.tandbergtv.watchpoint.pmm.title.conf.Specification s = new com.tandbergtv.watchpoint.pmm.title.conf.Specification();
        s.setClassLoader(classloader);
        s.setBundle(bundle);
        s.setName(jaxbSpec.getName());
        s.setConverterClass(jaxbSpec.getConverterClass());
        List<TitleType> titleList = jaxbSpec.getTitle();
        if (titleList != null) {
            for (TitleType title : titleList) {
                s.addRootTitleConf(this.convertToTitleConf(s, title));
            }
        }
        return s;
    }

    private TitleConf convertToTitleConf(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleType t) throws SpecificationValidationException {
        List<VariableType> variables;
        TitleConf tc = new TitleConf(specification);
        tc.setName(this.trim(t.getName()));
        tc.setAlias(t.getAlias());
        tc.setHasAsset(t.isHasAsset());
        if (t.isHideFileView() == null) {
            tc.setHideFileView(false);
        } else {
            tc.setHideFileView(t.isHideFileView().booleanValue());
        }
        tc.setMin(t.getMin());
        tc.setMax(t.getMax());
        Integer batchMin = t.getBatchMin();
        Integer batchMax = t.getBatchMax();
        tc.setBatchMin(batchMin != null ? batchMin : 0);
        tc.setBatchMax(batchMax != null ? batchMax : 0);
        TitleType.Metadata m = t.getMetadata();
        if (m != null && (variables = m.getVariable()) != null) {
            for (VariableType var : variables) {
                ArrayList<VariableType> path;
                Variable variable = this.convertToVariable(specification, tc, var, path = new ArrayList<VariableType>());
                if (variable == null) continue;
                tc.addMetadata(variable);
            }
        }
        if (t.getChildTitles() != null && t.getChildTitles().getTitle() != null) {
            for (TitleType childTitle : t.getChildTitles().getTitle()) {
                TitleConf child = this.convertToTitleConf(specification, childTitle);
                tc.addChild(child);
            }
        }
        return tc;
    }

    private Variable convertToVariable(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleConf tc, VariableType vt, List<VariableType> path) throws SpecificationValidationException {
        Variable v = null;
        if (BooleanVariableType.class.equals(vt.getClass())) {
            BooleanVariableType typedVT = (BooleanVariableType)vt;
            v = this.convertToBooleanVariable(specification, tc, typedVT, path);
        } else if (IntegerVariableType.class.equals(vt.getClass())) {
            IntegerVariableType typedVT = (IntegerVariableType)vt;
            v = this.convertToIntegerVariable(specification, tc, typedVT, path);
        } else if (FloatVariableType.class.equals(vt.getClass())) {
            FloatVariableType typedVT = (FloatVariableType)vt;
            v = this.convertToFloatVariable(specification, tc, typedVT, path);
        } else if (DateVariableType.class.equals(vt.getClass())) {
            DateVariableType typedVT = (DateVariableType)vt;
            v = this.convertToDateVariable(specification, tc, typedVT, path);
        } else if (TimeVariableType.class.equals(vt.getClass())) {
            TimeVariableType typedVT = (TimeVariableType)vt;
            v = this.convertToTimeVariable(specification, tc, typedVT, path);
        } else if (StringVariableType.class.equals(vt.getClass())) {
            StringVariableType typedVT = (StringVariableType)vt;
            v = this.convertToStringVariable(specification, tc, typedVT, path);
        } else if (ComplexVariableType.class.equals(vt.getClass())) {
            ComplexVariableType typedVT = (ComplexVariableType)vt;
            v = this.convertToComplexVariable(specification, tc, typedVT, path);
        } else {
            String msg = "Failed to convert variable type of class: " + vt.getClass();
            throw new SpecificationValidationException(msg);
        }
        return v;
    }

    private Variable convertToBooleanVariable(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleConf tc, BooleanVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        BooleanVariable v = new BooleanVariable(tc);
        this.buildSimpleVariable(vt, (SimpleVariable<?>)v, path);
        BooleanVariableType.Options options = vt.getOptions();
        if (options != null) {
            v.setAnyValueAllowed(options.isAnyValueAllowed());
            String optionProvider = options.getOptionProvider();
            int optionCount = options.getOption().size();
            if (optionCount > 0) {
                for (BooleanVariableType.Options.Option typeOption : options.getOption()) {
                    String name = this.getDisplayName(typeOption.getName(), specification.getBundle());
                    Boolean value = typeOption.isValue();
                    v.getOptions().add(new VariableOption(name, (Object)value));
                }
            } else if (optionProvider != null && optionProvider.trim().length() > 0) {
                this.loadDynamicOptions(specification, v.getOptions(), optionProvider, Boolean.class);
            }
        }
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToIntegerVariable(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleConf tc, IntegerVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        IntegerVariable v = new IntegerVariable(tc);
        this.buildSimpleVariable(vt, (SimpleVariable<?>)v, path);
        IntegerVariableType.Options options = vt.getOptions();
        if (options != null) {
            v.setAnyValueAllowed(options.isAnyValueAllowed());
            String optionProvider = options.getOptionProvider();
            int optionCount = options.getOption().size();
            if (optionCount > 0) {
                for (IntegerVariableType.Options.Option typeOption : options.getOption()) {
                    String name = this.getDisplayName(typeOption.getName(), specification.getBundle());
                    Long value = typeOption.getValue();
                    v.getOptions().add(new VariableOption(name, (Object)value));
                }
            } else if (optionProvider != null && optionProvider.trim().length() > 0) {
                this.loadDynamicOptions(specification, v.getOptions(), optionProvider, Long.class);
            }
        }
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToFloatVariable(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleConf tc, FloatVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        FloatVariable v = new FloatVariable(tc);
        this.buildSimpleVariable(vt, (SimpleVariable<?>)v, path);
        FloatVariableType.Options options = vt.getOptions();
        if (options != null) {
            v.setAnyValueAllowed(options.isAnyValueAllowed());
            String optionProvider = options.getOptionProvider();
            int optionCount = options.getOption().size();
            if (optionCount > 0) {
                for (FloatVariableType.Options.Option typeOption : options.getOption()) {
                    String name = this.getDisplayName(typeOption.getName(), specification.getBundle());
                    Float value = Float.valueOf(typeOption.getValue());
                    v.getOptions().add(new VariableOption(name, (Object)value));
                }
            } else if (optionProvider != null && optionProvider.trim().length() > 0) {
                this.loadDynamicOptions(specification, v.getOptions(), optionProvider, Float.class);
            }
        }
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToDateVariable(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleConf tc, DateVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        DateVariable v = new DateVariable(tc);
        this.buildSimpleVariable(vt, (SimpleVariable<?>)v, path);
        v.setDisplayFormat(vt.getDisplayPattern());
        DateVariableType.Options options = vt.getOptions();
        if (options != null) {
            v.setAnyValueAllowed(options.isAnyValueAllowed());
            String optionProvider = options.getOptionProvider();
            int optionCount = options.getOption().size();
            if (optionCount > 0) {
                for (DateVariableType.Options.Option typeOption : options.getOption()) {
                    String name = this.getDisplayName(typeOption.getName(), specification.getBundle());
                    XMLGregorianCalendar calendar = typeOption.getValue();
                    Date value = calendar != null ? calendar.toGregorianCalendar().getTime() : null;
                    v.getOptions().add(new VariableOption(name, (Object)value));
                }
            } else if (optionProvider != null && optionProvider.trim().length() > 0) {
                this.loadDynamicOptions(specification, v.getOptions(), optionProvider, Date.class);
            }
        }
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToTimeVariable(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleConf tc, TimeVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        TimeVariable v = new TimeVariable(tc);
        this.buildSimpleVariable(vt, (SimpleVariable<?>)v, path);
        v.setDisplayFormat(vt.getDisplayPattern());
        TimeVariableType.Options options = vt.getOptions();
        if (options != null) {
            v.setAnyValueAllowed(options.isAnyValueAllowed());
            String optionProvider = options.getOptionProvider();
            int optionCount = options.getOption().size();
            if (optionCount > 0) {
                for (TimeVariableType.Options.Option typeOption : options.getOption()) {
                    String name = this.getDisplayName(typeOption.getName(), specification.getBundle());
                    XMLGregorianCalendar calendar = typeOption.getValue();
                    Date value = calendar != null ? calendar.toGregorianCalendar().getTime() : null;
                    v.getOptions().add(new VariableOption(name, (Object)value));
                }
            } else if (optionProvider != null && optionProvider.trim().length() > 0) {
                this.loadDynamicOptions(specification, v.getOptions(), optionProvider, Date.class);
            }
        }
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToStringVariable(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleConf tc, StringVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        StringVariable v = new StringVariable(tc);
        this.buildSimpleVariable(vt, (SimpleVariable<?>)v, path);
        v.setLongFormat(vt.isLongFormat());
        StringVariableType.Options options = vt.getOptions();
        if (options != null) {
            v.setAnyValueAllowed(options.isAnyValueAllowed());
            String optionProvider = options.getOptionProvider();
            int optionCount = options.getOption().size();
            if (optionCount > 0) {
                for (StringVariableType.Options.Option typeOption : options.getOption()) {
                    String name = this.getDisplayName(typeOption.getName(), specification.getBundle());
                    String value = typeOption.getValue();
                    v.getOptions().add(new VariableOption(name, (Object)value));
                }
            } else if (optionProvider != null && optionProvider.trim().length() > 0) {
                this.loadDynamicOptions(specification, v.getOptions(), optionProvider, String.class);
            }
        }
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private void buildSimpleVariable(SimpleVariableType vt, SimpleVariable<?> v, List<VariableType> path) throws SpecificationValidationException {
        this.buildVariable(vt, (Variable)v, path);
        v.setRequired(vt.isRequired());
        v.setFilePath(vt.isFilePath());
        v.setKey(vt.isKey());
        v.setSearchField(vt.isSearchField());
        v.setExternalSearchField(vt.isExternalSearchField());
        v.setAttribute(vt.isAttribute());
        v.setJobParameter(vt.isJobParameter());
        v.setJobRuleParameter(vt.isJobRuleParameter());
        v.setBatch(vt.isBatch());
        v.setAutoFillable(vt.isAutoFillable());
        v.setAutoFillProvider(vt.getAutoFillProvider());
        SimpleVariableType.SearchInfo si = vt.getSearchInfo();
        if (si != null) {
            v.setSearchFieldDataProvider(this.trim(si.getDataProvider()));
            List<ParamType> constantsList = si.getConstant();
            if (constantsList != null) {
                for (ParamType constant : constantsList) {
                    String name = constant.getName();
                    String value = constant.getValue();
                    if (this.isNullOrEmpty(name) || this.isNullOrEmpty(value)) {
                        throw new SpecificationValidationException("Search Field Constant Name or Value cannot be null, blank or empty");
                    }
                    v.addSearchFieldValue(this.trim(name), this.trim(value));
                }
            }
        }
    }

    private ComplexVariable convertToComplexVariable(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleConf tc, VariableType vt, List<VariableType> path) throws SpecificationValidationException {
        ComplexVariable v = new ComplexVariable(tc);
        this.buildVariable(vt, (Variable)v, path);
        v.setShowCollapsed(vt.isShowCollapsed());
        List<VariableType> childTypes = vt.getVariable();
        if (childTypes != null) {
            path.add(vt);
            for (VariableType childType : childTypes) {
                Variable child = this.convertToVariable(specification, tc, childType, path);
                v.addChild(child);
            }
            path.remove(vt);
        }
        return v;
    }

    private void buildVariable(VariableType vt, Variable v, List<VariableType> path) {
        v.setName(vt.getName());
        v.setDisplayName(vt.getDisplayName());
        v.setXPath(this.generateXPath(vt, path));
        v.setMax(vt.getMax());
        v.setMin(vt.getMin());
    }

    private <DataType> void loadDynamicOptions(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, List<VariableOption<DataType>> options, String providerClassName, Class<DataType> dataType) throws SpecificationValidationException {
        Object providerInstance = null;
        try {
            ClassLoader classloader = specification.getClassLoader();
            Class<?> providerClass = classloader.loadClass(providerClassName);
            providerInstance = providerClass.newInstance();
        }
        catch (Exception e) {
            String msg = "Failed to create an instance of the variable option provider: " + providerClassName;
            throw new SpecificationValidationException(msg, (Throwable)e);
        }
        if (!(providerInstance instanceof IVariableOptionProvider)) {
            String msg = "The variable option provider: " + providerClassName + " does not implement required interface: " + IVariableOptionProvider.class.getName();
            throw new SpecificationValidationException(msg);
        }
        try {
            IVariableOptionProvider provider = providerInstance;
            for (VariableOption option : provider.getOptions()) {
                dataType.cast(option.getValue());
                options.add(option);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get the load options from variable option provider: " + providerClassName + ", expecting option values of type: " + dataType.getName();
            throw new SpecificationValidationException(msg, (Throwable)e);
        }
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private String trim(String s) {
        return s != null ? s.trim() : null;
    }

    private String getDisplayName(String name, ResourceBundle bundle) {
        if (bundle != null && bundle.containsKey(name)) {
            return bundle.getString(name);
        }
        return name;
    }

    private String generateXPath(VariableType vt, List<VariableType> path) {
        StringBuilder xpath = new StringBuilder();
        xpath.append(PATH_SEPARATOR).append(NAMESPACE_PREFIX).append(ROOT_FIELD);
        for (VariableType ancestor : path) {
            xpath.append(PATH_SEPARATOR).append(NAMESPACE_PREFIX).append(ancestor.getName());
        }
        xpath.append(PATH_SEPARATOR);
        boolean attribute = false;
        if (vt instanceof SimpleVariableType) {
            SimpleVariableType simpleVT = (SimpleVariableType)vt;
            attribute = simpleVT.isAttribute();
        }
        xpath.append(attribute ? ATTRIBUTE : NAMESPACE_PREFIX);
        xpath.append(vt.getName());
        return xpath.toString();
    }

    private Variable convertChildVariables(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleConf tc, SimpleVariableType vt, SimpleVariable<?> v, List<VariableType> path) throws SpecificationValidationException {
        ComplexVariable outputVariable = v;
        boolean hasChildren = vt.getVariable() != null && vt.getVariable().size() > 0;
        boolean hasTTVChildren = DataTypeMappingReader.getInstance().hasChildren(v.getXPath());
        if (hasChildren || hasTTVChildren) {
            ComplexVariable wrapper = this.convertToComplexVariable(specification, tc, vt, path);
            wrapper.setXPath("");
            wrapper.getChildren().add(0, v);
            v.setName(SimpleVariable.WRAPPED_FIELD_NAME);
            v.setMax(1);
            v.setMin(0);
            outputVariable = wrapper;
        }
        return outputVariable;
    }
}

