/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.provider.xport;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderInstance;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderProperties;
import com.tandbergtv.watchpoint.pmm.title.provider.TitleProviderInstance;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.AbstractTitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.xport.TitleProviderInstanceParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XportTitleProvider
extends AbstractTitleProvider
implements ITitleProvider {
    private static final String INSTANCE_CONFIG_RESOURCE = "./instances.xml";
    private Map<String, TitleProviderInstance> instances = new HashMap<String, TitleProviderInstance>();

    public XportTitleProvider(ITitleProviderProperties properties, ClassLoader classLoader) {
        super(properties, classLoader);
        this.initialize();
    }

    private synchronized void initialize() {
        this.instances.clear();
        TitleProviderInstanceParser parser = new TitleProviderInstanceParser();
        InputStream stream = this.getInstanceConfigurationStream();
        List<TitleProviderInstance> instanceList = parser.parse(stream);
        for (TitleProviderInstance instance : instanceList) {
            String instanceKey = this.systemId + "-" + instance.getKey();
            instance.setKey(instanceKey);
            this.instances.put(instanceKey, instance);
        }
    }

    private InputStream getInstanceConfigurationStream() {
        return this.classLoader.getResourceAsStream(INSTANCE_CONFIG_RESOURCE);
    }

    @Override
    public String getProviderInstanceURL(String key) {
        TitleProviderInstance instance = this.instances.get(key);
        String name = "ProviderURL";
        return instance != null ? instance.getProperties().get(name) : null;
    }

    @Override
    public Collection<ITitleProviderInstance> getProviderInstances() {
        ArrayList<ITitleProviderInstance> allInstances = new ArrayList<ITitleProviderInstance>();
        allInstances.addAll(this.instances.values());
        return allInstances;
    }

    @Override
    public ITitleProviderInstance getProviderInstance(String key) {
        return this.instances.get(key);
    }

    @Override
    public String getTitleDisplayURL(Title title) {
        if (title.getExternalLocation() == null || title.getExternalLocation().trim().length() == 0) {
            return null;
        }
        String providerInstanceURL = this.getProviderInstanceURL(title.getExternalLocation());
        return "http://" + providerInstanceURL + "/index.html";
    }
}

