/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.cms.title.search.IAssetInfoProvider;
import com.tandbergtv.cms.title.search.entities.AssetSearchInfo;
import com.tandbergtv.cms.title.search.entities.SearchColumn;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.AssetSearchQueryBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleAssetJoinBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.type.DateType;
import org.hibernate.type.FloatType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.transaction.annotation.Transactional;

public class AssetInfoProvider
implements IAssetInfoProvider {
    private final SessionFactory sessionFactory = this.getSessionFactory();
    private static final Logger logger = Logger.getLogger(AssetInfoProvider.class);
    private static final AssetSearchQueryBuilder asqb = new AssetSearchQueryBuilder();
    private static final TitleAssetJoinBuilder tajb = new TitleAssetJoinBuilder();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String UNION = "\r\nUNION\r\n";
    private static final String PACKAGE_ALIAS = "PACKAGE_ASSET";
    private static final String ASSET_ALIAS = "ASSET";
    private static final String FIELD_TABLE_ALIAS_BASE = "scf";
    private static final String FIELD_ALIAS_BASE = "sc";
    private static final String ASSET_ID = DBNameFinder.getInstance().getColumnName(Asset.class, "id");
    private static final String ASSET_TYPE = DBNameFinder.getInstance().getColumnName(Asset.class, "type");
    private static final String ASSET_TYPE_FILE = "FILE";
    private static final String PACKAGE_ASSET_ID = "PACKAGE_ASSET." + ASSET_ID;
    private static final String ASSET_ID_W_ALIAS = "ASSET." + ASSET_ID;
    private static final String TITLE_ALIAS = "T";
    private static final String ASSETLIST_MAP_ALIAS = "alm";
    private static final String ASSETLIST_MAP_ASSETLISTID = "alm.ASSETLIST_ID";
    private static final String ASSETLIST_MAP_ORDER = "alm.order_";
    private static final String ASSETLIST_MAP_ASSETID = "alm.ASSET_ID";
    private static final String TITLE_ID = "T." + DBNameFinder.getInstance().getColumnName(Title.class, "id");
    private static final String TITLE_PARTNER_ID = "T." + DBNameFinder.getInstance().getColumnName(Title.class, "partnerId");
    private static final String TITLE_ID_ALIAS = "TitleId";
    private static final String TITLE_PARTNER_ID_ALIAS = "TitlePartnerId";
    private static final String ASSET_ID_ALIAS = "AssetId";
    private static final String RELATION_ALIAS = "rel";
    private static final String OWNING_ASSET_ID_ALIAS = "OwningAssetId";
    private static final String OWNING_ASSET_ID = "rel." + DBNameFinder.getInstance().getColumnName(Relation.class, "ownerAsset");
    private static final String TARGET_ASSET_ID = "rel." + DBNameFinder.getInstance().getColumnName(Relation.class, "targetAsset");
    private static final String RELATION_DELETE_REVISION = "rel." + DBNameFinder.getInstance().getColumnName(Relation.class, "deleteRevision");

    private SessionFactory getSessionFactory() {
        try {
            ApplicationContextHelper applicationContextHelper = ApplicationContextHelper.getInstance();
            return applicationContextHelper.getSessionFactory();
        }
        catch (Exception e) {
            logger.error((Object)"Could not get SessionFactory from Application Context", (Throwable)e);
            throw new IllegalStateException("Could not get SessionFactory from Application Context");
        }
    }

    @Transactional
    public List<AssetSearchInfo> getAssetInfo(long titleId, List<SearchColumn> searchColumns) {
        String queryStr = this.buildQuery(searchColumns, SearchIdentifier.TITLE_ID);
        logger.debug((Object)queryStr);
        SQLQuery query = this.buildQuery(queryStr, searchColumns, titleId);
        return this.getTitleSearchResults(query, searchColumns, false);
    }

    @Transactional
    public List<AssetSearchInfo> getTitleAssetInfo(Long assetListId, List<SearchColumn> searchColumns) {
        String queryStr = this.buildQuery(searchColumns, SearchIdentifier.ASSET_LIST_ID);
        logger.debug((Object)queryStr);
        SQLQuery query = this.buildQuery(queryStr, searchColumns, assetListId);
        return this.getTitleSearchResults(query, searchColumns, true);
    }

    private List<AssetSearchInfo> getTitleSearchResults(SQLQuery query, List<SearchColumn> searchColumns, boolean hasOrder) {
        List queryResults = query.list();
        ArrayList<AssetSearchInfo> results = new ArrayList<AssetSearchInfo>();
        int offset = hasOrder ? 1 : 0;
        for (Object[] o : queryResults) {
            long titleId = (Long)o[0];
            Long titlePartnerId = (Long)o[1];
            long assetId = (Long)o[2];
            String assetType = o[3].toString();
            long owningAssetId = (Long)o[4];
            HashMap<String, String> row = new HashMap<String, String>();
            Iterator<SearchColumn> scIterator = searchColumns.iterator();
            for (int i = 5; i < o.length - offset; ++i) {
                SearchColumn currSearchCol = this.getNextXpath(scIterator);
                if (o[i] == null) {
                    row.put(currSearchCol.getFieldName(), "");
                    continue;
                }
                String dt = currSearchCol.getDataType();
                if (dt.equals("date")) {
                    try {
                        row.put(currSearchCol.getFieldName(), sdf.format((Date)o[i]));
                    }
                    catch (ClassCastException e) {
                        logger.warn((Object)"Odd I should have been able to cast a date to a date.");
                        row.put(currSearchCol.getFieldName(), o[i].toString());
                    }
                    continue;
                }
                row.put(currSearchCol.getFieldName(), o[i].toString());
            }
            results.add(new AssetSearchInfo(titleId, titlePartnerId, assetId, assetType, owningAssetId, row));
        }
        return results;
    }

    private SearchColumn getNextXpath(Iterator<SearchColumn> scIterator) {
        if (!scIterator.hasNext()) {
            throw new RuntimeException("Ran out of metaDataFields");
        }
        SearchColumn curr = scIterator.next();
        if (curr.isMetaData()) {
            return curr;
        }
        return this.getNextXpath(scIterator);
    }

    private SQLQuery buildQuery(String queryStr, List<SearchColumn> searchColumns, Long id) {
        SQLQuery query = this.sessionFactory.getCurrentSession().createSQLQuery(queryStr);
        query = query.addScalar(TITLE_ID_ALIAS, (Type)new LongType());
        query = query.addScalar(TITLE_PARTNER_ID_ALIAS, (Type)new LongType());
        query = query.addScalar(ASSET_ID_ALIAS, (Type)new LongType());
        query = query.addScalar(ASSET_TYPE, (Type)new StringType());
        query = query.addScalar(OWNING_ASSET_ID_ALIAS, (Type)new LongType());
        int index = 1;
        for (SearchColumn sc : searchColumns) {
            if (!sc.isMetaData()) continue;
            Object dataType = sc.getDataType().equals("string") ? new StringType() : (sc.getDataType().equals("integer") ? new LongType() : (sc.getDataType().equals("float") ? new FloatType() : (sc.getDataType().equals("date") ? new DateType() : new StringType())));
            query = query.addScalar(FIELD_ALIAS_BASE + index++, (Type)dataType);
        }
        query.setLong(0, id.longValue());
        query.setLong(1, id.longValue());
        return query;
    }

    private String buildQuery(List<SearchColumn> searchColumns, SearchIdentifier idType) {
        StringBuffer query = new StringBuffer();
        StringBuilder packageJoins = new StringBuilder();
        StringBuilder packageFields = new StringBuilder();
        this.fieldBuilder(searchColumns, packageJoins, packageFields, PACKAGE_ALIAS);
        query.append(QueryConstants.SELECT);
        query.append(TITLE_ID);
        query.append(QueryConstants.AS);
        query.append(TITLE_ID_ALIAS);
        query.append(", ");
        query.append(TITLE_PARTNER_ID);
        query.append(QueryConstants.AS);
        query.append(TITLE_PARTNER_ID_ALIAS);
        query.append(", ");
        query.append(PACKAGE_ASSET_ID);
        query.append(QueryConstants.AS);
        query.append(ASSET_ID_ALIAS);
        query.append(", ");
        this.appendAssetField(query, PACKAGE_ALIAS, ASSET_TYPE);
        query.append(", ");
        query.append("0");
        query.append(QueryConstants.AS);
        query.append(OWNING_ASSET_ID_ALIAS);
        query.append(", ");
        query.append((CharSequence)packageFields);
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append(", ");
            query.append(ASSETLIST_MAP_ORDER);
        }
        this.appendMainJoin(query);
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            this.appendAssetListJoin(query, PACKAGE_ALIAS);
        }
        query.append((CharSequence)packageJoins);
        this.buildWhere(query, TITLE_ID, idType, PACKAGE_ALIAS, false);
        this.appendGroupBy(query, PACKAGE_ALIAS, idType, false);
        query.append(UNION);
        StringBuilder assetJoins = new StringBuilder();
        StringBuilder assetFields = new StringBuilder();
        this.fieldBuilder(searchColumns, assetJoins, assetFields, ASSET_ALIAS);
        query.append(QueryConstants.SELECT);
        query.append(TITLE_ID);
        query.append(QueryConstants.AS);
        query.append(TITLE_ID_ALIAS);
        query.append(", ");
        query.append(TITLE_PARTNER_ID);
        query.append(QueryConstants.AS);
        query.append(TITLE_PARTNER_ID_ALIAS);
        query.append(", ");
        query.append(ASSET_ID_W_ALIAS);
        query.append(QueryConstants.AS);
        query.append(ASSET_ID_ALIAS);
        query.append(", ");
        this.appendAssetField(query, ASSET_ALIAS, ASSET_TYPE);
        query.append(", ");
        query.append(OWNING_ASSET_ID);
        query.append(QueryConstants.AS);
        query.append(OWNING_ASSET_ID_ALIAS);
        query.append(", ");
        query.append((CharSequence)assetFields);
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append(", ");
            query.append(ASSETLIST_MAP_ORDER);
        }
        this.appendMainJoin(query);
        this.joinOntoAsset(query);
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            this.appendAssetListJoin(query, ASSET_ALIAS);
        }
        this.appendRelationJoin(query, ASSET_ALIAS);
        query.append((CharSequence)assetJoins);
        this.buildWhere(query, ASSETLIST_MAP_ASSETLISTID, idType, ASSET_ALIAS, true);
        this.appendGroupBy(query, ASSET_ALIAS, idType, true);
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append("\r\nOrder BY order_");
        } else {
            query.append("\r\nOrder BY TitleId,AssetId");
        }
        return query.toString();
    }

    private void appendAssetListJoin(StringBuffer sb, String assetAlias) {
        sb.append("\r\nJOIN CMS_ASSETLIST_ASSET_MAP ");
        sb.append(ASSETLIST_MAP_ALIAS);
        sb.append("\r\n ON( ");
        sb.append(assetAlias);
        sb.append(".");
        sb.append(ASSET_ID);
        sb.append(" = ");
        sb.append(ASSETLIST_MAP_ASSETID);
        sb.append(")");
    }

    private void appendRelationJoin(StringBuffer sb, String assetAlias) {
        sb.append("\r\nJOIN MDM_RELATION ");
        sb.append(RELATION_ALIAS);
        sb.append("\r\n ON( ");
        sb.append(TARGET_ASSET_ID);
        sb.append(" = ");
        sb.append(assetAlias);
        sb.append(".");
        sb.append(ASSET_ID);
        sb.append(")");
    }

    private void buildWhere(StringBuffer sb, String idField, SearchIdentifier idType, String typeAlias, boolean deleteRevision) {
        sb.append("WHERE ");
        if (idType.equals((Object)SearchIdentifier.TITLE_ID)) {
            sb.append(TITLE_ID);
        } else {
            sb.append(ASSETLIST_MAP_ASSETLISTID);
        }
        sb.append(" = ? AND ");
        sb.append(asqb.getDefaultConditions(PACKAGE_ALIAS));
        sb.append(" AND ");
        sb.append(typeAlias);
        sb.append(".");
        sb.append(ASSET_TYPE);
        sb.append(" != ");
        sb.append("'");
        sb.append(ASSET_TYPE_FILE);
        sb.append("'");
        if (deleteRevision) {
            sb.append(" AND ");
            sb.append(RELATION_DELETE_REVISION);
            sb.append(" = 0");
        }
    }

    private void appendMainJoin(StringBuffer query) {
        query.append("\r\nFROM ");
        query.append(DBNameFinder.getInstance().getTableName(Title.class));
        query.append(" ");
        query.append(TITLE_ALIAS);
        this.joinOntoAssetMain(query);
    }

    private void joinOntoAssetMain(StringBuffer sb) {
        String tableName = DBNameFinder.getInstance().getTableName(Asset.class);
        sb.append("\r\nJOIN ");
        sb.append(tableName);
        sb.append(" ");
        sb.append(PACKAGE_ALIAS);
        sb.append("\r\nON (");
        sb.append(tajb.getJoin(TITLE_ALIAS, PACKAGE_ALIAS));
        sb.append(")");
    }

    private void joinOntoAsset(StringBuffer sb) {
        String tableName = DBNameFinder.getInstance().getTableName(Asset.class);
        sb.append("\r\nJOIN ");
        sb.append(tableName);
        sb.append(" ");
        sb.append(ASSET_ALIAS);
        sb.append("\r\nON (");
        sb.append(PACKAGE_ALIAS);
        sb.append(".");
        sb.append(ASSET_ID);
        sb.append(" = ");
        sb.append(ASSET_ALIAS);
        sb.append(".");
        sb.append("ROOTASSET_ID");
        sb.append(")\r\n");
    }

    private void appendGroupBy(StringBuffer query, String assetAlias, SearchIdentifier searchType, boolean owningAsset) {
        query.append("\r\nGROUP BY ");
        query.append(TITLE_ID);
        query.append(", ");
        query.append(TITLE_PARTNER_ID);
        query.append(", ");
        this.appendAssetField(query, assetAlias, ASSET_ID);
        query.append(", ");
        this.appendAssetField(query, assetAlias, ASSET_TYPE);
        if (owningAsset) {
            query.append(", ");
            query.append(OWNING_ASSET_ID);
        }
        if (searchType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append(", ");
            query.append(ASSETLIST_MAP_ORDER);
        }
    }

    private void appendAssetField(StringBuffer query, String assetAlias, String field) {
        query.append(assetAlias);
        query.append(".");
        query.append(field);
    }

    private void fieldBuilder(List<SearchColumn> searchColumns, StringBuilder joins, StringBuilder fields, String assetAlias) {
        int index = 1;
        for (SearchColumn sc : searchColumns) {
            if (!sc.isMetaData()) continue;
            String xpath = sc.getFieldName();
            String fieldTableAlias = FIELD_TABLE_ALIAS_BASE + index;
            String fieldAlias = FIELD_ALIAS_BASE + index;
            joins.append("LEFT JOIN  MDM_FIELD ");
            joins.append(fieldTableAlias);
            joins.append("\r\nON (");
            joins.append(fieldTableAlias);
            joins.append(".ASSET_ID = ");
            joins.append(assetAlias);
            joins.append(".ID AND ");
            joins.append(fieldTableAlias);
            joins.append(".TTVXPATH = '");
            joins.append(xpath);
            joins.append("') \r\n");
            if (index > 1) {
                fields.append(", ");
            }
            fields.append("MAX (");
            fields.append(fieldTableAlias);
            fields.append(".");
            fields.append(this.getDataTypeCol(xpath));
            fields.append(")");
            fields.append(QueryConstants.AS);
            fields.append(fieldAlias);
            ++index;
        }
    }

    private String getDataTypeCol(String xpath) {
        String dataType = DataTypeMappingReader.getInstance().determineDataType(xpath);
        if (dataType.equals("string") || dataType.equals("time") || dataType.equals("boolean")) {
            return "VALUE";
        }
        if (dataType.equals("date")) {
            return "DATEVALUE";
        }
        if (dataType.equals("integer")) {
            return "INTVALUE";
        }
        if (dataType.equals("float")) {
            return "FLOATVALUE";
        }
        return "VALUE";
    }

    public String getServiceName() {
        return "Asset Info Provider";
    }

    public void start() {
    }

    public void stop() {
    }

    private static enum SearchIdentifier {
        TITLE_ID,
        ASSET_LIST_ID;

    }
}

