/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.util.List;

public class QueryBuilderHelper {
    public static String getCondition(String fieldName, LogicalOperator lop, List<String> values, String alias, SearchType searchType) {
        StringBuffer sb = new StringBuffer();
        sb.append(alias);
        sb.append(".");
        sb.append(fieldName);
        if (lop.equals((Object)LogicalOperator.IN)) {
            QueryBuilderHelper.handleIn(sb, values, false, searchType);
        } else if (lop.equals((Object)LogicalOperator.NOTIN)) {
            QueryBuilderHelper.handleIn(sb, values, true, searchType);
        } else if (lop.equals((Object)LogicalOperator.ISEMPTY)) {
            sb.append(" IS NULL");
        } else if (lop.equals((Object)LogicalOperator.ISNOTEMPTY)) {
            sb.append(" IS NOT NULL");
        } else {
            if (values.size() != 1) {
                throw new IllegalArgumentException("only one operator for " + lop.name());
            }
            sb.append(QueryBuilderHelper.getNonInOperator(lop));
            sb.append(" ");
            sb.append(QueryBuilderHelper.encodeField(values.get(0), searchType));
        }
        return sb.toString();
    }

    private static String encodeField(String value, SearchType dataType) {
        if (dataType.equals((Object)SearchType.STRING)) {
            return "'" + value + "'";
        }
        if (dataType.equals((Object)SearchType.DATE)) {
            return "to_timestamp('" + value + "','YYYY-MM-DD\"T\"HH24:MI:SS.FF')";
        }
        return value;
    }

    private static void handleIn(StringBuffer sb, List<String> values, boolean not, SearchType searchType) {
        sb.append(" ");
        if (not) {
            sb.append("NOT ");
        }
        sb.append("IN (");
        if (values.size() == 0) {
            throw new IllegalArgumentException("In & Not In operators require a minimum of one value");
        }
        for (int i = 0; i < values.size() - 1; ++i) {
            sb.append(values.get(i));
            sb.append(", ");
        }
        sb.append(values.get(values.size() - 1));
        sb.append(")");
    }

    private static String getNonInOperator(LogicalOperator lop) {
        switch (lop) {
            case EQUAL: {
                return "=";
            }
            case NOTEQUAL: {
                return "<>";
            }
            case LESSTHAN: {
                return "<";
            }
            case LESSTHANEQUAL: {
                return "<=";
            }
            case GREATERTHAN: {
                return ">";
            }
            case GREATERTHANEQUAL: {
                return ">=";
            }
        }
        throw new IllegalArgumentException("Unsupported title operator " + lop.name());
    }
}

