/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.cms.title.search.entities.SearchColumn;
import com.tandbergtv.cms.title.search.entities.TitleSortInfo;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.FieldQueryBuilder;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.QueryHelperBase;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleQuickSearchQueryHelper
extends QueryHelperBase {
    private static final Logger logger = Logger.getLogger(TitleQuickSearchQueryHelper.class);
    private FieldQueryBuilder fieldQueryBuilder = new FieldQueryBuilder();
    protected static final String ORIG_TITLE_ID = "T." + DBNameFinder.getInstance().getColumnName(Title.class, "originalId");

    public String buildQuickSearchCnt(int numPartner) {
        StringBuffer query = new StringBuffer();
        query.append(QueryConstants.SELECT);
        query.append(" COUNT(DISTINCT ");
        query.append(TITLE_ID);
        query.append(") as cnt ");
        this.buildQsFrom(query, new StringBuilder());
        this.buildQsWhere(query, numPartner);
        String result = query.toString();
        logger.debug((Object)result);
        return result;
    }

    public String buildQuickSearch(int numPartner, boolean includePaging, TitleSortInfo sortInfo, List<SearchColumn> searchColumns) {
        StringBuffer sb = new StringBuffer();
        StringBuilder scFieldsInner = new StringBuilder();
        StringBuilder scFieldsOuter = new StringBuilder();
        StringBuilder scJoins = new StringBuilder();
        StringBuilder orderBy = new StringBuilder();
        this.populateResultFieldJoins(searchColumns, scJoins, scFieldsInner, scFieldsOuter, orderBy, sortInfo);
        if (includePaging) {
            sb.append(QueryConstants.SELECT);
            sb.append(DBNameFinder.getInstance().getColumnName(Title.class, "id"));
            sb.append(", ");
            sb.append((CharSequence)scFieldsOuter);
            sb.append(" FROM (");
            sb.append(QueryConstants.SELECT);
            sb.append("rownum rnum, ");
        } else {
            sb.append(QueryConstants.SELECT);
        }
        sb.append(DBNameFinder.getInstance().getColumnName(Title.class, "id"));
        sb.append(", ");
        sb.append((CharSequence)scFieldsOuter);
        sb.append(" FROM (");
        sb.append(QueryConstants.SELECT);
        sb.append(TITLE_ID);
        if (scFieldsInner.length() > 0) {
            sb.append(", ");
            sb.append((CharSequence)scFieldsInner);
        }
        sb.append(", ROW_NUMBER() OVER(PARTITION BY T.ID_ ORDER BY T.ID_) RN");
        this.buildQsFrom(sb, scJoins);
        this.buildQsWhere(sb, numPartner);
        sb.append("\r\n");
        sb.append((CharSequence)orderBy);
        if (includePaging) {
            sb.append(")\r\n WHERE RN   = 1 AND ROWNUM < ?) WHERE RNUM > ? \r\n");
        } else {
            sb.append(")\r\n WHERE RN   = 1");
        }
        String result = sb.toString();
        logger.debug((Object)result);
        return result;
    }

    private void buildQsFrom(StringBuffer sb, StringBuilder scJoins) {
        sb.append("\r\nFROM ");
        sb.append(this.fieldQueryBuilder.getPartialFromClause());
        sb.append("\r\nJOIN ");
        sb.append(DBNameFinder.getInstance().getTableName(Title.class));
        sb.append(" ");
        sb.append("T");
        sb.append("\r\nON (");
        sb.append("T");
        sb.append(".ASSET_ID = ");
        sb.append(this.fieldQueryBuilder.getAlias());
        sb.append(".ROOTASSET_ID) ");
        this.joinOntoAssetMain(sb);
        sb.append((CharSequence)scJoins);
    }

    private void buildQsWhere(StringBuffer sb, int numPartner) {
        sb.append("WHERE CATSEARCH(");
        sb.append(this.fieldQueryBuilder.getAlias());
        sb.append(".");
        sb.append(DBNameFinder.getInstance().getColumnName(Field.class, "value"));
        sb.append(", ?, NULL) > 0  AND ");
        sb.append(this.asqb.getDefaultConditions("PACKAGE_ASSET"));
        sb.append("\r\nAND ");
        sb.append(ORIG_TITLE_ID);
        sb.append(QueryConstants.NULL);
        sb.append("\r\n");
        if (numPartner > 0) {
            sb.append("AND T.Partner_Id in (?");
            for (int i = 1; i < numPartner; ++i) {
                sb.append(", ?");
            }
            sb.append(") ");
        }
    }
}

