/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.InvalidQuickSrchException;
import com.tandbergtv.cms.title.search.TitleQuickSearchHelper;
import com.tandbergtv.cms.title.search.entities.PagingInfo;
import com.tandbergtv.cms.title.search.entities.ParamType;
import com.tandbergtv.cms.title.search.entities.SearchColumn;
import com.tandbergtv.cms.title.search.entities.SearchFieldNode;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.cms.title.search.entities.TitleSearchField;
import com.tandbergtv.cms.title.search.entities.TitleSearchResult;
import com.tandbergtv.cms.title.search.entities.TitleSearchSimpleResult;
import com.tandbergtv.cms.title.search.entities.TitleSortInfo;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.TitleQuickSearchQueryHelper;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchQueryHelper;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

public class TitleSearchService
implements ITitleSearchService {
    private static final Logger logger = Logger.getLogger((String)TitleSearchService.class.getName());
    private final SessionFactory sessionFactory = this.getSessionFactory();
    private TitleSearchQueryHelper searchQueryHelper = new TitleSearchQueryHelper();
    private TitleQuickSearchQueryHelper qsQueryHelper = new TitleQuickSearchQueryHelper();
    private TitleQuickSearchHelper quickSearchHelper = new TitleQuickSearchHelper();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    protected SessionFactory getSessionFactory() {
        try {
            ApplicationContextHelper applicationContextHelper = ApplicationContextHelper.getInstance();
            return applicationContextHelper.getSessionFactory();
        }
        catch (Exception e) {
            logger.error((Object)"Could not get SessionFactory from Application Context", (Throwable)e);
            throw new IllegalStateException("Could not get SessionFactory from Application Context");
        }
    }

    public String getServiceName() {
        return "Title Search";
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public int countIncludeAllcopies(List<SearchFieldNode> searchFields) {
        List<SearchFieldNode> list = searchFields;
        return Conversions.intValue((Object)TitleSearchService.countIncludeAllcopies_aroundBody1$advice(this, list, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("countIncludeAllcopies", List.class).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public List<Title> getTitleCopies(Long masterTitleId) {
        Long l = masterTitleId;
        return (List)TitleSearchService.getTitleCopies_aroundBody3$advice(this, l, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("getTitleCopies", Long.class).getAnnotation(Transactional.class), null);
    }

    public List<Long> getTitleIds(List<SearchFieldNode> searchFields) {
        return this.masterSearchHelper(searchFields, null, null);
    }

    @Transactional
    public List<Title> getTitles(List<Long> titleIds) {
        List<Long> list = titleIds;
        return (List)TitleSearchService.getTitles_aroundBody5$advice(this, list, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("getTitles", List.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<Title> search(List<SearchFieldNode> searchFields) {
        List<SearchFieldNode> list = searchFields;
        return (List)TitleSearchService.search_aroundBody7$advice(this, list, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("search", List.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleSearchResult getSearchResults(List<SearchFieldNode> searchFields, PagingInfo pagingInfo, TitleSortInfo sortInfo, List<Long> partnerIds, List<SearchColumn> searchColumns) {
        List<SearchFieldNode> list = searchFields;
        PagingInfo pagingInfo2 = pagingInfo;
        TitleSortInfo titleSortInfo = sortInfo;
        List<Long> list2 = partnerIds;
        List<SearchColumn> list3 = searchColumns;
        return (TitleSearchResult)TitleSearchService.getSearchResults_aroundBody9$advice(this, list, pagingInfo2, titleSortInfo, list2, list3, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("getSearchResults", List.class, PagingInfo.class, TitleSortInfo.class, List.class, List.class).getAnnotation(Transactional.class), null);
    }

    private List<Long> masterSearchHelper(List<SearchFieldNode> searchFields, PagingInfo pagingInfo, TitleSortInfo sortInfo) {
        String queryStr = this.searchQueryHelper.getQuery(searchFields, sortInfo, pagingInfo, true, false, false, new ArrayList<Integer>(), null, false, new ArrayList<SearchColumn>(), new ArrayList<Long>());
        SQLQuery query = this.sessionFactory.getCurrentSession().createSQLQuery(queryStr).addScalar("id_", (Type)new LongType());
        return query.list();
    }

    @Transactional
    public List<Long> getSiteTitleIds(List<SearchFieldNode> searchFields, Collection<Integer> siteIds, SiteType siteType) {
        List<SearchFieldNode> list = searchFields;
        Collection<Integer> collection = siteIds;
        SiteType siteType2 = siteType;
        return (List)TitleSearchService.getSiteTitleIds_aroundBody11$advice(this, list, collection, siteType2, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("getSiteTitleIds", List.class, Collection.class, SiteType.class).getAnnotation(Transactional.class), null);
    }

    public List<Title> getSiteTitle(List<SearchFieldNode> searchFields, Collection<Integer> siteIds, SiteType siteType) {
        return this.getTitles(this.getSiteTitleIds(searchFields, siteIds, siteType));
    }

    @Transactional
    public List<Long> geAllTitlesIds(List<SearchFieldNode> searchFields, Collection<Integer> siteIds, SiteType siteType) {
        List<SearchFieldNode> list = searchFields;
        Collection<Integer> collection = siteIds;
        SiteType siteType2 = siteType;
        return (List)TitleSearchService.geAllTitlesIds_aroundBody13$advice(this, list, collection, siteType2, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("geAllTitlesIds", List.class, Collection.class, SiteType.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleSearchSimpleResult getSiteTitleIds(List<SearchFieldNode> searchFields, Collection<Integer> siteIds, SiteType siteType, PagingInfo pagingInfo, TitleSortInfo sortInfo, List<Long> partnerIds) {
        List<SearchFieldNode> list = searchFields;
        Collection<Integer> collection = siteIds;
        SiteType siteType2 = siteType;
        PagingInfo pagingInfo2 = pagingInfo;
        TitleSortInfo titleSortInfo = sortInfo;
        List<Long> list2 = partnerIds;
        return (TitleSearchSimpleResult)TitleSearchService.getSiteTitleIds_aroundBody15$advice(this, list, collection, siteType2, pagingInfo2, titleSortInfo, list2, TransactionEnforcer.aspectOf(), TitleSearchService.class.getDeclaredMethod("getSiteTitleIds", List.class, Collection.class, SiteType.class, PagingInfo.class, TitleSortInfo.class, List.class).getAnnotation(Transactional.class), null);
    }

    public TitleSearchResult getTitlesQuickSearch(String searchText, List<Long> partnerIds, PagingInfo pagingInfo, TitleSortInfo sortInfo, List<SearchColumn> searchColumns) throws InvalidQuickSrchException {
        String queryStr = this.qsQueryHelper.buildQuickSearch(partnerIds.size(), pagingInfo != null, sortInfo, searchColumns);
        SQLQuery query = this.buildQuery(queryStr, searchColumns, false);
        this.setQSParameters(query, searchText, partnerIds, pagingInfo);
        String quickSearchFirstWord = this.quickSearchHelper.getFirstWord(searchText);
        TitleSearchResult result = this.getTitleSearchResults(query, searchColumns, quickSearchFirstWord, false);
        String countQueryStr = this.qsQueryHelper.buildQuickSearchCnt(partnerIds.size());
        SQLQuery countQuery = this.sessionFactory.getCurrentSession().createSQLQuery(countQueryStr);
        countQuery = countQuery.addScalar("cnt", (Type)new IntegerType());
        this.setQSParameters(countQuery, searchText, partnerIds, null);
        result.setCount(((Integer)countQuery.uniqueResult()).intValue());
        return result;
    }

    private TitleSearchResult getTitleSearchResults(SQLQuery query, List<SearchColumn> searchColumns, String quickSearchFirstWord, boolean includeCnt) throws InvalidQuickSrchException {
        List queryResults;
        try {
            queryResults = query.list();
        }
        catch (HibernateException e) {
            if (e.getCause() instanceof SQLException) {
                throw new InvalidQuickSrchException((Throwable)e);
            }
            throw e;
        }
        int count = 0;
        if (includeCnt && queryResults.size() > 0) {
            count = (Integer)((Object[])queryResults.get(0))[((Object[])queryResults.get(0)).length - 1];
        }
        ArrayList<TitleSearchResult.SearchRow> results = new ArrayList<TitleSearchResult.SearchRow>();
        int idPos = -1;
        for (int i = 0; i < searchColumns.size(); ++i) {
            SearchColumn sc = searchColumns.get(i);
            if (!sc.getFieldName().equals("id")) continue;
            idPos = i;
            break;
        }
        int rowCntOffset = includeCnt ? 1 : 0;
        int searchColOffset = idPos == -1 ? 1 : 0;
        for (Object[] o : queryResults) {
            long titleId = (Long)o[0];
            ArrayList<String> row = new ArrayList<String>(searchColumns.size());
            if (idPos == 0) {
                row.add(String.valueOf(titleId));
            }
            for (int i = 1; i < o.length - rowCntOffset; ++i) {
                if (idPos == i) {
                    row.add(String.valueOf(titleId));
                }
                if (o[i] == null) {
                    row.add("");
                    continue;
                }
                int searchColIndex = i - searchColOffset;
                String dt = searchColumns.get(searchColIndex).getDataType();
                if (searchColumns.get(searchColIndex).getFieldName().equals("qsMatchingValue")) {
                    row.add(this.quickSearchHelper.trimQsMatchingValue(quickSearchFirstWord, o[i].toString()));
                    continue;
                }
                if (dt.equals("date")) {
                    try {
                        Timestamp st = (Timestamp)o[i];
                        row.add(this.sdf.format(new Date(st.getTime())));
                    }
                    catch (ClassCastException e) {
                        logger.warn((Object)"Odd I should have been able to cast a date to a date.");
                        row.add(o[i].toString());
                    }
                    continue;
                }
                row.add(o[i].toString());
            }
            results.add(new TitleSearchResult.SearchRow(titleId, row));
        }
        return new TitleSearchResult(results, count);
    }

    private SQLQuery buildQuery(String queryStr, List<SearchColumn> searchColumns, boolean includeCount) {
        SQLQuery query = this.sessionFactory.getCurrentSession().createSQLQuery(queryStr);
        query = query.addScalar("id_", (Type)new LongType());
        for (int i = 0; i < searchColumns.size(); ++i) {
            SearchColumn sc = searchColumns.get(i);
            if (sc.getFieldName().equals("id")) continue;
            Object dataType = sc.getDataType().equals("string") ? new StringType() : (sc.getDataType().equals("integer") ? new LongType() : (sc.getDataType().equals("float") ? new FloatType() : (sc.getDataType().equals("date") ? new TimestampType() : new StringType())));
            query = query.addScalar("sc" + i, (Type)dataType);
        }
        if (includeCount) {
            query = query.addScalar("cnt", (Type)new IntegerType());
        }
        return query;
    }

    private void setQSParameters(SQLQuery query, String searchText, List<Long> partnerIds, PagingInfo pagingInfo) {
        int paramIndex = 0;
        query.setString(paramIndex++, searchText);
        for (Long partnerId : partnerIds) {
            query.setLong(paramIndex++, partnerId.longValue());
        }
        if (pagingInfo != null) {
            query.setInteger(paramIndex++, pagingInfo.getStartIndex() + pagingInfo.getMaxRecordCount() + 1);
            query.setInteger(paramIndex++, pagingInfo.getStartIndex());
        }
    }

    public ScrollableResults qwikSrchScrollable(String searchText, List<Long> partnerIds, TitleSortInfo sortInfo, List<SearchColumn> searchColumns, int fetchSize) {
        String queryStr = this.qsQueryHelper.buildQuickSearch(partnerIds.size(), false, sortInfo, searchColumns);
        SQLQuery query = this.buildQuery(queryStr, searchColumns, false);
        this.setQSParameters(query, searchText, partnerIds, null);
        query.setFetchSize(fetchSize);
        return query.scroll(ScrollMode.FORWARD_ONLY);
    }

    public ScrollableResults getTitleScrollable(List<SearchFieldNode> searchFields, TitleSortInfo sortInfo, List<Long> partnerIds, List<SearchColumn> searchColumns, int fetchSize) {
        String queryStr = this.searchQueryHelper.getQuery(searchFields, sortInfo, null, true, false, false, new ArrayList<Integer>(), null, false, searchColumns, partnerIds);
        SQLQuery query = this.buildQuery(queryStr, searchColumns, false);
        query.setFetchSize(fetchSize);
        return query.scroll(ScrollMode.FORWARD_ONLY);
    }

    public List<TitleSearchResult.SearchRow> getSearchResults(List<Long> titleIds, List<SearchColumn> searchColumns) {
        if (titleIds.isEmpty()) {
            return new ArrayList<TitleSearchResult.SearchRow>();
        }
        List<SearchFieldNode> searchCriteria = this.getTitleIdsCriteria(titleIds);
        return this.getSearchResultRows(searchCriteria, null, null, new ArrayList<Long>(), searchColumns);
    }

    public List<TitleSearchResult.SearchRow> getSearchResultRows(List<SearchFieldNode> searchFields, PagingInfo pagingInfo, TitleSortInfo sortInfo, List<Long> partnerIds, List<SearchColumn> searchColumns) {
        String idsQueryStr = this.searchQueryHelper.getQuery(searchFields, sortInfo, pagingInfo, true, false, false, new ArrayList<Integer>(), null, false, new ArrayList<SearchColumn>(), partnerIds);
        SQLQuery idsQuery = this.buildQuery(idsQueryStr, new ArrayList<SearchColumn>(), false);
        List ids = idsQuery.list();
        String queryStr = this.searchQueryHelper.getQuery(this.getTitleIdsCriteria(ids), sortInfo, null, true, false, false, new ArrayList<Integer>(), null, false, searchColumns, partnerIds);
        SQLQuery query = this.buildQuery(queryStr, searchColumns, false);
        try {
            return this.getTitleSearchResults(query, searchColumns, "", false).getRows();
        }
        catch (InvalidQuickSrchException e) {
            logger.error((Object)"THIS SHOULD NEVER HAPPEN ", (Throwable)e);
            return new ArrayList<TitleSearchResult.SearchRow>();
        }
    }

    private List<SearchFieldNode> getTitleIdsCriteria(List<Long> titleIds) {
        ArrayList<String> titleIdsStr = new ArrayList<String>();
        for (Long id : titleIds) {
            titleIdsStr.add(String.valueOf(id));
        }
        TitleSearchField tsf = new TitleSearchField("id", titleIdsStr, SearchType.NUMERIC, LogicalOperator.IN, ParamType.LIST, true, true);
        ArrayList<SearchFieldNode> searchCriteria = new ArrayList<SearchFieldNode>();
        searchCriteria.add((SearchFieldNode)tsf);
        return searchCriteria;
    }

    private static final /* synthetic */ int countIncludeAllcopies_aroundBody0(TitleSearchService this_, List searchFields) {
        String queryStr = this_.searchQueryHelper.getCountQuery(searchFields, true, true, true, new ArrayList<Integer>(), SiteType.DISTRIBUTION_SITE, new ArrayList<Long>());
        SQLQuery query = this_.sessionFactory.getCurrentSession().createSQLQuery(queryStr).addScalar("cnt", (Type)new IntegerType());
        return (Integer)query.uniqueResult();
    }

    private static final /* synthetic */ Object countIncludeAllcopies_aroundBody1$advice(TitleSearchService this_, List searchFields, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.intObject((int)TitleSearchService.countIncludeAllcopies_aroundBody0(this_, searchFields));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.intObject((int)TitleSearchService.countIncludeAllcopies_aroundBody0(this_, searchFields));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List getTitleCopies_aroundBody2(TitleSearchService this_, Long masterTitleId) {
        ArrayList<SearchFieldNode> searchFields = new ArrayList<SearchFieldNode>();
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(masterTitleId));
        searchFields.add((SearchFieldNode)new TitleSearchField("originalId", values, SearchType.NUMERIC, LogicalOperator.EQUAL, ParamType.VALUE, false, true));
        String queryStr = this_.searchQueryHelper.getQuery(searchFields, null, null, false, true, true, new ArrayList<Integer>(), SiteType.DISTRIBUTION_SITE, false, new ArrayList<SearchColumn>(), new ArrayList<Long>());
        SQLQuery query = this_.sessionFactory.getCurrentSession().createSQLQuery(queryStr).addScalar("id_", (Type)new LongType());
        List titleIds = query.list();
        if (titleIds.isEmpty()) {
            return new ArrayList();
        }
        return this_.getTitles(titleIds);
    }

    private static final /* synthetic */ Object getTitleCopies_aroundBody3$advice(TitleSearchService this_, Long masterTitleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.getTitleCopies_aroundBody2(this_, masterTitleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchService.getTitleCopies_aroundBody2(this_, masterTitleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List getTitles_aroundBody4(TitleSearchService this_, List titleIds) {
        if (titleIds == null || titleIds.isEmpty()) {
            return new ArrayList();
        }
        Criteria crit = this_.sessionFactory.getCurrentSession().createCriteria(Title.class);
        crit.add(Restrictions.in((String)"id", (Object[])titleIds.toArray()));
        crit.addOrder(Property.forName((String)"id").asc());
        return crit.list();
    }

    private static final /* synthetic */ Object getTitles_aroundBody5$advice(TitleSearchService this_, List titleIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.getTitles_aroundBody4(this_, titleIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchService.getTitles_aroundBody4(this_, titleIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List search_aroundBody6(TitleSearchService this_, List searchFields) {
        List<Long> titleIds = this_.masterSearchHelper(searchFields, null, null);
        List<Title> titles = this_.getTitles(titleIds);
        Title[] result = new Title[titleIds.size()];
        block0: for (Title t : titles) {
            Long id = t.getId();
            for (int i = 0; i < titleIds.size(); ++i) {
                if (!titleIds.get(i).equals(id)) continue;
                result[i] = t;
                continue block0;
            }
        }
        return Arrays.asList(result);
    }

    private static final /* synthetic */ Object search_aroundBody7$advice(TitleSearchService this_, List searchFields, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.search_aroundBody6(this_, searchFields);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchService.search_aroundBody6(this_, searchFields);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ TitleSearchResult getSearchResults_aroundBody8(TitleSearchService this_, List searchFields, PagingInfo pagingInfo, TitleSortInfo sortInfo, List partnerIds, List searchColumns) {
        String idsQueryStr = this_.searchQueryHelper.getQuery(searchFields, sortInfo, pagingInfo, true, false, false, new ArrayList<Integer>(), null, true, new ArrayList<SearchColumn>(), partnerIds);
        SQLQuery idsQuery = this_.buildQuery(idsQueryStr, new ArrayList<SearchColumn>(), true);
        ArrayList<Long> ids = new ArrayList<Long>();
        List idsResult = idsQuery.list();
        if (idsResult.size() == 0) {
            return new TitleSearchResult();
        }
        int count = (Integer)((Object[])idsResult.get(0))[1];
        for (Object[] obj : idsResult) {
            ids.add((Long)obj[0]);
        }
        String queryStr = this_.searchQueryHelper.getQuery(this_.getTitleIdsCriteria(ids), sortInfo, null, true, false, false, new ArrayList<Integer>(), null, false, searchColumns, partnerIds);
        SQLQuery query = this_.buildQuery(queryStr, searchColumns, false);
        try {
            return new TitleSearchResult(this_.getTitleSearchResults(query, searchColumns, "", false).getRows(), count);
        }
        catch (InvalidQuickSrchException e) {
            logger.error((Object)"THIS SHOULD NEVER HAPPEN ", (Throwable)e);
            return new TitleSearchResult();
        }
    }

    private static final /* synthetic */ Object getSearchResults_aroundBody9$advice(TitleSearchService this_, List searchFields, PagingInfo pagingInfo, TitleSortInfo sortInfo, List partnerIds, List searchColumns, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.getSearchResults_aroundBody8(this_, searchFields, pagingInfo, sortInfo, partnerIds, searchColumns);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleSearchResult object = TitleSearchService.getSearchResults_aroundBody8(this_, searchFields, pagingInfo, sortInfo, partnerIds, searchColumns);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List getSiteTitleIds_aroundBody10(TitleSearchService this_, List searchFields, Collection siteIds, SiteType siteType) {
        String queryStr = this_.searchQueryHelper.getQuery(searchFields, null, null, false, false, true, siteIds, siteType, false, new ArrayList<SearchColumn>(), new ArrayList<Long>());
        SQLQuery query = this_.sessionFactory.getCurrentSession().createSQLQuery(queryStr).addScalar("id_", (Type)new LongType());
        return query.list();
    }

    private static final /* synthetic */ Object getSiteTitleIds_aroundBody11$advice(TitleSearchService this_, List searchFields, Collection siteIds, SiteType siteType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.getSiteTitleIds_aroundBody10(this_, searchFields, siteIds, siteType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchService.getSiteTitleIds_aroundBody10(this_, searchFields, siteIds, siteType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List geAllTitlesIds_aroundBody12(TitleSearchService this_, List searchFields, Collection siteIds, SiteType siteType) {
        String queryStr = this_.searchQueryHelper.getQuery(searchFields, null, null, true, true, true, siteIds, siteType, false, new ArrayList<SearchColumn>(), new ArrayList<Long>());
        SQLQuery query = this_.sessionFactory.getCurrentSession().createSQLQuery(queryStr).addScalar("id_", (Type)new LongType());
        return query.list();
    }

    private static final /* synthetic */ Object geAllTitlesIds_aroundBody13$advice(TitleSearchService this_, List searchFields, Collection siteIds, SiteType siteType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.geAllTitlesIds_aroundBody12(this_, searchFields, siteIds, siteType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchService.geAllTitlesIds_aroundBody12(this_, searchFields, siteIds, siteType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ TitleSearchSimpleResult getSiteTitleIds_aroundBody14(TitleSearchService this_, List searchFields, Collection siteIds, SiteType siteType, PagingInfo pagingInfo, TitleSortInfo sortInfo, List partnerIds) {
        String queryStr = this_.searchQueryHelper.getQuery(searchFields, sortInfo, pagingInfo, false, false, true, siteIds, siteType, true, new ArrayList<SearchColumn>(), partnerIds);
        SQLQuery query = this_.sessionFactory.getCurrentSession().createSQLQuery(queryStr).addScalar("id_", (Type)new LongType()).addScalar("cnt", (Type)new IntegerType());
        List queryResults = query.list();
        int count = 0;
        if (queryResults.size() > 0) {
            count = (Integer)((Object[])queryResults.get(0))[1];
        }
        ArrayList<Long> titleIds = new ArrayList<Long>();
        for (Object[] o : queryResults) {
            titleIds.add((Long)o[0]);
        }
        return new TitleSearchSimpleResult(titleIds, count);
    }

    private static final /* synthetic */ Object getSiteTitleIds_aroundBody15$advice(TitleSearchService this_, List searchFields, Collection siteIds, SiteType siteType, PagingInfo pagingInfo, TitleSortInfo sortInfo, List partnerIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchService.getSiteTitleIds_aroundBody14(this_, searchFields, siteIds, siteType, pagingInfo, sortInfo, partnerIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleSearchSimpleResult object = TitleSearchService.getSiteTitleIds_aroundBody14(this_, searchFields, siteIds, siteType, pagingInfo, sortInfo, partnerIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

