/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities;

import java.util.Date;

public class ProgressItem {
    private Long id;
    private String name;
    private String value;
    private Boolean isSuccess;
    private Long titleId;
    private Long assetListId;
    private Date timestamp;
    private String titleVersion;
    private String sourceComponentName;
    private String sourceEntityName;
    private String sourceId;
    private Boolean isActive;
    private static final int MAX_VALUE = 3997;

    protected ProgressItem() {
        this.isActive = true;
    }

    public ProgressItem(String name, String value, long titleId, String titleVersion, String sourceComponentName, String sourceEntityName, String sourceId) {
        this.name = name;
        this.value = this.trimValue(value);
        this.titleId = titleId;
        this.timestamp = new Date();
        this.isSuccess = true;
        this.titleVersion = titleVersion;
        this.sourceComponentName = sourceComponentName;
        this.sourceEntityName = sourceEntityName;
        this.sourceId = sourceId;
        this.isActive = true;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = this.trimValue(value);
    }

    public Boolean getIsSuccess() {
        return this.isSuccess;
    }

    public void setIsSuccess(Boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public Long getTitleId() {
        return this.titleId;
    }

    public Long getAssetListId() {
        return this.assetListId;
    }

    public void setAssetListId(Long assetListId) {
        this.assetListId = assetListId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return "[" + this.id + "] " + this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgressItem)) {
            return false;
        }
        ProgressItem other = (ProgressItem)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getTitleRevision() {
        return this.titleVersion;
    }

    public void setTitleVersion(String titleVersion) {
        this.titleVersion = titleVersion;
    }

    public String getSourceComponentName() {
        return this.sourceComponentName;
    }

    public void setSourceComponentName(String sourceComponentName) {
        this.sourceComponentName = sourceComponentName;
    }

    public String getSourceEntityName() {
        return this.sourceEntityName;
    }

    public void setSourceEntityName(String sourceEntityName) {
        this.sourceEntityName = sourceEntityName;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    private String trimValue(String val) {
        if (val != null && val.length() > 3997) {
            val = val.substring(0, 3996) + "...";
        }
        return val;
    }
}

