/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.tandbergtv.watchpoint.pmm.title.ingest.IngestMappingType;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAsset;
import java.util.Collection;

public class ContentMapping {
    private String filePath;
    private Collection<TitleAsset> titleAssets;

    public ContentMapping(String filePath, Collection<TitleAsset> titleAssets) {
        this.filePath = filePath;
        this.titleAssets = titleAssets;
    }

    public boolean hasUniqueMatch() {
        return IngestMappingType.UNIQUE_MATCH.equals((Object)this.getMappingType());
    }

    public boolean hasNoMatch() {
        return IngestMappingType.NO_MATCH.equals((Object)this.getMappingType());
    }

    public boolean hasDuplicateMatches() {
        return IngestMappingType.DUPLICATE_MATCHES.equals((Object)this.getMappingType());
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Collection<TitleAsset> getTitleAssets() {
        return this.titleAssets;
    }

    public IngestMappingType getMappingType() {
        if (this.titleAssets == null || this.titleAssets.size() == 0) {
            return IngestMappingType.NO_MATCH;
        }
        if (this.titleAssets.size() == 1) {
            return IngestMappingType.UNIQUE_MATCH;
        }
        return IngestMappingType.DUPLICATE_MATCHES;
    }
}

